package com.ejianc.business.pub.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pub.bean.BillCodeRuleAttrEntity;
import com.ejianc.business.pub.bean.BillCodeRuleEntity;
import com.ejianc.business.pub.bean.BillCodeRuleSNEntity;
import com.ejianc.business.pub.service.IBillCodeRuleAttrService;
import com.ejianc.business.pub.service.IBillCodeRuleSNService;
import com.ejianc.business.pub.service.IBillCodeRuleService;
import com.ejianc.business.pub.vo.BillCodeRuleSNVO;
import com.ejianc.business.pub.vo.BillCodeRuleVO;
import com.ejianc.business.pub.vo.enumvo.RuleElemType;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleApiVO;
import com.ejianc.business.ztpc.billcode.bean.GenerateBillCodeSNVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/ztpcBillCode/")
public class BillCodeRuleApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeRuleService codeService;

    @Autowired
    private IBillCodeRuleAttrService attrService;

    @Autowired
    private IBillCodeRuleSNService snService;

    @RequestMapping(value = "generateBillCode", method= RequestMethod.POST)
    @ResponseBody
    public CommonResponse<GenerateBillCodeSNVO> generateBillCode(@RequestBody BillCodeRuleApiVO apiVO) throws IntrospectionException {
        //查询编码规则
        QueryWrapper<BillCodeRuleEntity> ruleQuery = new QueryWrapper<>();
        ruleQuery.eq("project_id", apiVO.getProjectId());
        ruleQuery.eq("category_id", apiVO.getCategoryId());
        ruleQuery.eq("rule_type", apiVO.getRuleType());

        BillCodeRuleEntity billCodeRuleEntity = codeService.getOne(ruleQuery, false);

        if(billCodeRuleEntity == null ){
            return CommonResponse.error("未匹配到取号编码规则，请检查!");
        }

        GenerateBillCodeSNVO retSnVO = new GenerateBillCodeSNVO();

        //幂等
//        QueryWrapper<BillCodeRuleSNEntity> snDuplicateWrapper = new QueryWrapper<>();
//        snDuplicateWrapper.eq("rule_id",billCodeRuleEntity.getId());
//        snDuplicateWrapper.eq("source_pid",apiVO.getSourcePid());
//
//        BillCodeRuleSNEntity snDuplicateEntity = snService.getOne(snDuplicateWrapper, false);
//        if(snDuplicateEntity != null){
//            retSnVO = BeanMapper.map(snDuplicateEntity, GenerateBillCodeSNVO.class);
//            return CommonResponse.success(apiVO.getSourceCode()+"已生成编码",retSnVO);
//        }

        //查询编码规则明细
        QueryParam attQuery = new QueryParam();
        attQuery.getParams().put("rule_id",new Parameter(QueryParam.EQ, billCodeRuleEntity.getId()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("id", QueryParam.DESC);

        List<BillCodeRuleAttrEntity> ruleAttrEntities = attrService.queryList(attQuery, false);

        /**开始组装编码start**/
        StringBuffer sb = new StringBuffer();
//        BillCodeRuleSNEntity saveEntity = new BillCodeRuleSNEntity();
        for (BillCodeRuleAttrEntity attrEntity : ruleAttrEntities) {
            if(RuleElemType.常量.getCode().equals(attrEntity.getRuleElemType())){
                sb.append(attrEntity.getElemValue()).append("—");
            }else if( RuleElemType.自定义流水依据.getCode().equals(attrEntity.getRuleElemType())){
                String ruleElemCode = attrEntity.getRuleElemCode();
                try {
                    Object fieldValue = getFieldValue(apiVO, ruleElemCode);
                    sb.append(fieldValue.toString()).append("—");

                    //反射动态赋值
                    PropertyDescriptor propertyDescriptor = new PropertyDescriptor(ruleElemCode, retSnVO.getClass());
                    Method method = propertyDescriptor.getWriteMethod();
                    method.invoke(retSnVO, fieldValue.toString());
                } catch (NoSuchFieldException e) {
                    e.printStackTrace();
                    return CommonResponse.error("字段【 " + ruleElemCode + "】未设置get、set方法！!");
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return CommonResponse.error("字段【 " + ruleElemCode + "】未传入对应的值！!");
                } catch (InvocationTargetException e) {
                    e.printStackTrace();
                    return CommonResponse.error("字段【 " + ruleElemCode + "】未设置get、set方法！!");
                }
            }else if(RuleElemType.流水号.getCode().equals(attrEntity.getRuleElemType())){
                QueryWrapper<BillCodeRuleSNEntity> snWrapper1 = new QueryWrapper<>();
                QueryWrapper<BillCodeRuleSNEntity> snWrapper2 = new QueryWrapper<>();
                List<BillCodeRuleSNEntity> snEntities = null;
                if(StringUtils.isNotEmpty(retSnVO.getRule05())){
                    //根据专业查询当前的流水
                    snWrapper1.select("start_sn,id");
                    snWrapper1.eq("rule_id",billCodeRuleEntity.getId());
                    snWrapper1.eq("is_init","1");
                    snWrapper1.eq("rule05",retSnVO.getRule05());
                    snWrapper1.orderByAsc("id");
                    snEntities = snService.list(snWrapper1);
                }
                if(snEntities == null || snEntities.size() == 0){
                    //查询初始化的流水号
                    snWrapper2.select("start_sn,id");
                    snWrapper2.eq("rule_id",billCodeRuleEntity.getId());
                    snWrapper2.eq("is_init","0");
                    snWrapper2.orderByAsc("id");
                    snEntities = snService.list(snWrapper2);
                }
                //key——startSn，value——id,id没啥用
                Map<Integer, Long> snMap = snEntities.stream().collect(Collectors.toMap(BillCodeRuleSNEntity::getStartSn,BillCodeRuleSNEntity::getId));

                int initialNumber = attrEntity.getStartNum() == null ? 0 : attrEntity.getStartNum();//起始流水号
                Object[] objArr = generateSerialNumber(initialNumber, attrEntity.getElemLength(), snMap);
                sb.append(objArr[1].toString()).append("—");

                retSnVO.setStartSn( Integer.parseInt(objArr[0].toString()) );//序列数值
                retSnVO.setCurrSn(objArr[1].toString());//序列格式化
            }
        }
        String generateBillCode = sb.substring(0, sb.length() - 1);

        //保存规则sn流水
        retSnVO.setProjectId(apiVO.getProjectId());
        retSnVO.setProjectCode(apiVO.getProjectCode());
        retSnVO.setProjectName(apiVO.getProjectName());

        retSnVO.setCategoryId(apiVO.getCategoryId());
        retSnVO.setRuleType(apiVO.getRuleType());

        retSnVO.setIsInit("1");//非初始化
        retSnVO.setRuleId(billCodeRuleEntity.getId());//规则id
        retSnVO.setSourcePid(apiVO.getSourcePid());//来源id
        retSnVO.setSourceCode(apiVO.getSourceCode());//来源单据编码
        retSnVO.setSourceType(apiVO.getSourceType());//来源单据类型
        retSnVO.setSourceTypeName(apiVO.getSourceTypeName());;//来源单据类型名称
        retSnVO.setGenerateBillCode(generateBillCode);//序列化编码
//        snService.saveOrUpdate(saveEntity);
        /**组装编码end**/

        return CommonResponse.success("生成编码成功",retSnVO);
    }


    /**
     * 提号
     * @param generateBillCodeSNVO
     * @return
     */
    @RequestMapping(value = "commitBillCode", method= RequestMethod.POST)
    @ResponseBody
    public CommonResponse commitBillCode(@RequestBody GenerateBillCodeSNVO generateBillCodeSNVO) {
        //先根据来源id还号
        Map sourceMap = new HashMap<String, Object>() ;
        List idList = new ArrayList<String>();
        idList.add(generateBillCodeSNVO.getSourcePid());
        sourceMap.put("ids",idList);
        this.releaseBillCode(sourceMap);

        //再提号
        BillCodeRuleSNEntity snEntity = BeanMapper.map(generateBillCodeSNVO, BillCodeRuleSNEntity.class);
        snService.saveOrUpdate(snEntity);
        return CommonResponse.success("处理成功！");
    }

    /**
     * 还号
     * @param sourceIds 来源单据id，可以传多个，以list的形式
     * @return
     */
    @RequestMapping(value = "releaseBillCode", method= RequestMethod.POST)
    @ResponseBody
    public CommonResponse releaseBillCode(@RequestBody Map<String, Object> sourceIds) {
        if(sourceIds.get("ids") == null){
            return CommonResponse.error("ids不能为空");
        }

        ArrayList<String> sourcePidList = (ArrayList<String>)sourceIds.get("ids");
        QueryWrapper<BillCodeRuleSNEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.in("source_pid", sourcePidList);
        boolean flag = snService.remove(deleteWrapper,false);
        if(flag){
            return CommonResponse.success("还号成功");
        }else{
            return CommonResponse.error("还号失败");
        }
    }


    /**
     * @param initialNumber     初始化值
     * @param digitCount    流水号位数
     * @param snMap    流水号集合
     * @return
     */
    public static Object[] generateSerialNumber(int initialNumber, int digitCount,Map snMap) {
        int nextSerialNumber = getNextSerialNumber(initialNumber); // 将流水号递增1
        while (snMap.containsKey(nextSerialNumber)) {
            nextSerialNumber = getNextSerialNumber(nextSerialNumber);
        }

        String format = "%0" + digitCount + "d"; // 根据位数生成格式化字符串
        String serialNumber = String.format(format, nextSerialNumber);

        Object[] objArr = new Object[]{nextSerialNumber,serialNumber};
        return objArr;
    }

    private static int getNextSerialNumber(int currentSerialNumber) {
        return currentSerialNumber + 1;
    }
    public static <T, V> V getFieldValue(T object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (V) field.get(object);
    }
}
