package com.ejianc.business.pub.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 取号编码规则
 * 
 * @author generator
 * 
 */
 @TableName("ejc_ztpccom_billcode_rule")
public class BillCodeRuleEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 所属项目部Id
    @TableField(value="org_name")
    private String orgName; // 所属项目部name
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 组织ID
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 组织名称

    @TableField(value="rule_name")
    private String ruleName; // 规则名称
    @TableField(value="rule_type")
    private String ruleType; // 规则类型，0内部编码，1外部编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="category_id")
    private Long categoryId; // 所属分类主键Id
    @TableField(value="category_name")
    private String categoryName; // 所属分类名称
    @TableField(value="org_code")
    private String orgCode; // 所属项目部code


    @TableField(exist=false)
    @SubEntity(serviceName="billCodeRuleAttrService",pidName = "ruleId")//此处有pid="xxx"，默认值pid="pid"
    private List<BillCodeRuleAttrEntity> billCodeRuleAttrList = new ArrayList<>(); // 明细实体

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }
    public String getRuleType() {
        return ruleType;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getCategoryId() {
        return categoryId;
    }

    public void setCategoryId(Long categoryId) {
        this.categoryId = categoryId;
    }
    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public List<BillCodeRuleAttrEntity> getBillCodeRuleAttrList() {
        return billCodeRuleAttrList;
    }

    public void setBillCodeRuleAttrList(List<BillCodeRuleAttrEntity> billCodeRuleAttrList) {
        this.billCodeRuleAttrList = billCodeRuleAttrList;
    }
}
