/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pub.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pub.bean.DataDictionaryCategoryEntity;
import com.ejianc.business.pub.service.IDataDictionaryCategoryService;
import com.ejianc.business.pub.vo.DataDictionaryCategoryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"dataDictionaryCategory"})
public class DataDictionaryCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IDataDictionaryCategoryService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProjectSetApi projectSetApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<DataDictionaryCategoryVO> saveOrUpdate(@RequestBody DataDictionaryCategoryVO saveOrUpdateVO) {
        CommonResponse<DataDictionaryCategoryVO> response = this.service.saveOrUpdateCategory(saveOrUpdateVO);
        return response;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<DataDictionaryCategoryVO> queryDetail(Long id) {
        DataDictionaryCategoryEntity entity = (DataDictionaryCategoryEntity)((Object)this.service.selectById(id));
        DataDictionaryCategoryVO vo = (DataDictionaryCategoryVO)((Object)BeanMapper.map((Object)((Object)entity), DataDictionaryCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DataDictionaryCategoryVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DataDictionaryCategoryVO dataDictionaryCategoryVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList<String> departmentIds = new ArrayList<String>();
        orgVOList.stream().forEach(org -> departmentIds.add(org.getId() + ""));
        if (CollectionUtils.isNotEmpty(departmentIds)) {
            departmentIds.add("group");
            param.getParams().put("orgCode", new Parameter("in", departmentIds));
        }
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("category_id", "desc");
        orderMap.put("level", "asc");
        orderMap.put("line", "asc");
        List<DataDictionaryCategoryVO> dataList = this.service.queryDataDictionaryCategoryList(param);
        this.logger.info("dataList\uff1a", (Object)JSONObject.toJSONString(dataList));
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("leaf").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        List treeData = ResultAsTree.createTreeData((List)resultMapList);
        return CommonResponse.success((Object)treeData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DataDictionaryCategory-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refDataDictionaryCategoryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<DataDictionaryCategoryVO>> refDataDictionaryCategoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), DataDictionaryCategoryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryCategoryRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> queryCategoryRefTree(@RequestParam(required=false) String condition) {
        List categoryEntities;
        if (StringUtils.isBlank((CharSequence)condition)) {
            return null;
        }
        Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
        String projectId = conditionMap.get("projectId").toString();
        CommonResponse responseVO = this.projectSetApi.getProjectId(new Long(projectId));
        QueryParam parentParam = new QueryParam();
        if (responseVO.getCode() == 0 && responseVO.getData() != null) {
            ProjectPoolSetVO projectPoolSetVO = (ProjectPoolSetVO)responseVO.getData();
            parentParam.getParams().put("orgCode", new Parameter("eq", (Object)projectPoolSetVO.getProjectDepartmentId()));
            String categoryName = conditionMap.get("categoryName").toString();
            parentParam.getParams().put("categoryName", new Parameter("eq", (Object)categoryName));
        }
        if ((categoryEntities = this.service.queryList(parentParam, false)) == null || categoryEntities.size() == 0) {
            parentParam.getParams().put("orgCode", new Parameter("eq", (Object)"group"));
            categoryEntities = this.service.queryList(parentParam, false);
            if (categoryEntities == null || categoryEntities.size() == 0) {
                return null;
            }
        }
        QueryParam queryParam = new QueryParam();
        if (conditionMap.get("isTop") != null) {
            queryParam.getParams().put("parentId", new Parameter("eq", (Object)((DataDictionaryCategoryEntity)((Object)categoryEntities.get(0))).getId()));
        } else if (conditionMap.get("parentId") != null) {
            queryParam.getParams().put("parentId", new Parameter("eq", (Object)conditionMap.get("parentId").toString()));
        } else {
            queryParam.getParams().put("innerCode", new Parameter("like_left", (Object)((DataDictionaryCategoryEntity)((Object)categoryEntities.get(0))).getId()));
        }
        List<DataDictionaryCategoryVO> dataList = this.service.queryDataDictionaryCategoryList(queryParam);
        for (DataDictionaryCategoryVO categoryVO : dataList) {
            if (!categoryVO.getCategoryName().equals(conditionMap.get("categoryName").toString())) continue;
            categoryVO.setName(categoryVO.getCategoryName() + "\uff08" + categoryVO.getLevel() + "\uff09");
            break;
        }
        if (ListUtil.isEmpty(dataList)) {
            return new ArrayList<Map<String, Object>>();
        }
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("leaf").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        List treeData = ResultAsTree.createTreeData((List)resultMapList);
        return treeData;
    }
}

