/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pub.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pub.bean.BillCodeRuleAttrEntity;
import com.ejianc.business.pub.bean.BillCodeRuleEntity;
import com.ejianc.business.pub.bean.BillCodeRuleSNEntity;
import com.ejianc.business.pub.service.IBillCodeRuleAttrService;
import com.ejianc.business.pub.service.IBillCodeRuleSNService;
import com.ejianc.business.pub.service.IBillCodeRuleService;
import com.ejianc.business.pub.vo.enumvo.RuleElemType;
import com.ejianc.business.ztpc.billcode.bean.BillCodeApiVO;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleSNVO;
import com.ejianc.business.ztpc.billcode.bean.RuleTypeEnum;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ztpcBillCode/"})
public class BillCodeRuleApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeRuleService codeService;
    @Autowired
    private IBillCodeRuleAttrService attrService;
    @Autowired
    private IBillCodeRuleSNService snService;

    @RequestMapping(value={"generateBillCode"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BillCodeApiVO> generateBillCode(@RequestBody BillCodeApiVO apiVO) throws IntrospectionException {
        String stringInfo = JSONObject.toJSONString((Object)apiVO);
        this.logger.info("\u53d6\u53f7\u53c2\u6570---->" + stringInfo);
        List snList = apiVO.getSnList();
        if (snList == null || snList.size() == 0) {
            return CommonResponse.error((String)"snList\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
        }
        ArrayList<BillCodeRuleSNVO> snRetList = new ArrayList<BillCodeRuleSNVO>();
        for (BillCodeRuleSNVO snVO : snList) {
            QueryWrapper ruleQuery = new QueryWrapper();
            ruleQuery.eq((Object)"project_id", (Object)apiVO.getProjectId());
            ruleQuery.eq((Object)"category_id", (Object)apiVO.getCategoryId());
            ruleQuery.eq((Object)"rule_type", (Object)snVO.getRuleType());
            BillCodeRuleEntity billCodeRuleEntity = (BillCodeRuleEntity)((Object)this.codeService.getOne((Wrapper)ruleQuery, false));
            if (billCodeRuleEntity == null) {
                if (RuleTypeEnum.\u5185\u90e8\u7f16\u7801.getCode().equals(snVO.getRuleType())) {
                    return CommonResponse.error((String)(RuleTypeEnum.\u5185\u90e8\u7f16\u7801.getName() + "-\u672a\u5339\u914d\u5230\u53d6\u53f7\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5!"));
                }
                if (RuleTypeEnum.\u5916\u90e8\u7f16\u7801.getCode().equals(snVO.getRuleType())) {
                    return CommonResponse.error((String)(RuleTypeEnum.\u5916\u90e8\u7f16\u7801.getName() + "-\u672a\u5339\u914d\u5230\u53d6\u53f7\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5!"));
                }
            }
            BillCodeRuleSNVO retSnVO = new BillCodeRuleSNVO();
            QueryWrapper snDuplicateWrapper = new QueryWrapper();
            snDuplicateWrapper.eq((Object)"rule_id", (Object)billCodeRuleEntity.getId());
            snDuplicateWrapper.eq((Object)"source_pid", (Object)snVO.getSourcePid());
            this.buildDuplicateWrapper((QueryWrapper<BillCodeRuleSNEntity>)snDuplicateWrapper, snVO);
            BillCodeRuleSNEntity snDuplicateEntity = (BillCodeRuleSNEntity)((Object)this.snService.getOne((Wrapper)snDuplicateWrapper, false));
            if (snDuplicateEntity != null) {
                this.logger.info(snVO.getSourceCode() + "----" + snDuplicateEntity.getGenerateBillCode() + "\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u53d6\u53f7---->");
                retSnVO = (BillCodeRuleSNVO)BeanMapper.map((Object)((Object)snDuplicateEntity), BillCodeRuleSNVO.class);
                snRetList.add(retSnVO);
                continue;
            }
            QueryParam attQuery = new QueryParam();
            attQuery.getParams().put("rule_id", new Parameter("eq", (Object)billCodeRuleEntity.getId()));
            LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
            orderMap.put("id", "asc");
            attQuery.setOrderMap(orderMap);
            List ruleAttrEntities = this.attrService.queryList(attQuery, false);
            String separator = billCodeRuleEntity.getSeparatorStr() == null ? "" : billCodeRuleEntity.getSeparatorStr();
            StringBuffer sb = new StringBuffer();
            for (BillCodeRuleAttrEntity attrEntity : ruleAttrEntities) {
                if (RuleElemType.\u5e38\u91cf.getCode().equals(attrEntity.getRuleElemType())) {
                    sb.append(attrEntity.getElemValue()).append(separator);
                    continue;
                }
                if (RuleElemType.\u81ea\u5b9a\u4e49\u6d41\u6c34\u4f9d\u636e.getCode().equals(attrEntity.getRuleElemType())) {
                    String ruleElemCode = attrEntity.getRuleElemCode();
                    try {
                        Object fieldValue = BillCodeRuleApi.getFieldValue(apiVO, ruleElemCode);
                        sb.append(fieldValue.toString()).append(separator);
                        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(ruleElemCode, retSnVO.getClass());
                        Method method = propertyDescriptor.getWriteMethod();
                        method.invoke((Object)retSnVO, fieldValue.toString());
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                        return CommonResponse.error((String)("\u5b57\u6bb5\u3010 " + ruleElemCode + "\u3011\u672a\u8bbe\u7f6eget\u3001set\u65b9\u6cd5\uff01!"));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return CommonResponse.error((String)("\u5b57\u6bb5\u3010 " + ruleElemCode + "\u3011\u672a\u4f20\u5165\u5bf9\u5e94\u7684\u503c\uff01!"));
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                        return CommonResponse.error((String)("\u5b57\u6bb5\u3010 " + ruleElemCode + "\u3011\u672a\u8bbe\u7f6eget\u3001set\u65b9\u6cd5\uff01!"));
                    }
                }
                if (!RuleElemType.\u6d41\u6c34\u53f7.getCode().equals(attrEntity.getRuleElemType())) continue;
                QueryWrapper snWrapper1 = new QueryWrapper();
                List snEntities = null;
                if (RuleTypeEnum.\u5916\u90e8\u7f16\u7801.getCode().equals(snVO.getRuleType())) {
                    snWrapper1.select(new String[]{"start_sn,id"});
                    snWrapper1.eq((Object)"rule_id", (Object)billCodeRuleEntity.getId());
                    snWrapper1.eq((Object)"is_init", (Object)"1");
                    this.buildDuplicateWrapper((QueryWrapper<BillCodeRuleSNEntity>)snWrapper1, retSnVO);
                    snEntities = this.snService.list((Wrapper)snWrapper1);
                } else if (RuleTypeEnum.\u5916\u90e8\u7f16\u7801.getCode().equals(snVO.getRuleType())) {
                    snWrapper1.select(new String[]{"start_sn,id"});
                    snWrapper1.eq((Object)"rule_id", (Object)billCodeRuleEntity.getId());
                    snWrapper1.eq((Object)"is_init", (Object)"1");
                    snEntities = this.snService.list((Wrapper)snWrapper1);
                }
                if (snEntities == null || snEntities.size() == 0) {
                    QueryWrapper snWrapper2 = new QueryWrapper();
                    snWrapper2.select(new String[]{"start_sn,id"});
                    snWrapper2.eq((Object)"rule_id", (Object)billCodeRuleEntity.getId());
                    snWrapper2.eq((Object)"is_init", (Object)"0");
                    snWrapper2.orderByAsc((Object)"id");
                    snEntities = this.snService.list((Wrapper)snWrapper2);
                }
                Map<Integer, Long> snMap = snEntities.stream().collect(Collectors.toMap(BillCodeRuleSNEntity::getStartSn, BaseEntity::getId));
                int initialNumber = attrEntity.getStartNum() == null ? 0 : attrEntity.getStartNum();
                Object[] objArr = BillCodeRuleApi.generateSerialNumber(initialNumber, attrEntity.getElemLength(), snMap);
                sb.append(objArr[1].toString()).append(separator);
                retSnVO.setStartSn(Integer.valueOf(Integer.parseInt(objArr[0].toString())));
                retSnVO.setCurrSn(objArr[1].toString());
            }
            String generateBillCode = sb.substring(0, sb.length() - 1);
            retSnVO.setProjectId(apiVO.getProjectId());
            retSnVO.setProjectCode(apiVO.getProjectCode());
            retSnVO.setProjectName(apiVO.getProjectName());
            retSnVO.setCategoryId(apiVO.getCategoryId());
            retSnVO.setRuleType(snVO.getRuleType());
            retSnVO.setIsInit("1");
            retSnVO.setRuleId(billCodeRuleEntity.getId());
            retSnVO.setSourcePid(snVO.getSourcePid());
            retSnVO.setSourceCode(snVO.getSourceCode());
            retSnVO.setSourceType(snVO.getSourceType());
            retSnVO.setSourceTypeName(snVO.getSourceTypeName());
            retSnVO.setGenerateBillCode(generateBillCode);
            snRetList.add(retSnVO);
            String retSnVOInfo = JSONObject.toJSONString((Object)retSnVO);
            this.logger.info("\u53d6\u53f7\u8fd4\u56de\u4fe1\u606f---->" + retSnVOInfo);
        }
        apiVO.setSnList(snRetList);
        return CommonResponse.success((String)"\u751f\u6210\u7f16\u7801\u6210\u529f", (Object)apiVO);
    }

    public void buildDuplicateWrapper(QueryWrapper<BillCodeRuleSNEntity> snDuplicateWrapper, BillCodeRuleSNVO snVO) {
        if (StringUtils.isNotEmpty((String)snVO.getRule05())) {
            snDuplicateWrapper.eq((Object)"rule05", (Object)snVO.getRule05());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule07())) {
            snDuplicateWrapper.eq((Object)"rule07", (Object)snVO.getRule07());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule08())) {
            snDuplicateWrapper.eq((Object)"rule08", (Object)snVO.getRule08());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule09())) {
            snDuplicateWrapper.eq((Object)"rule09", (Object)snVO.getRule09());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule10())) {
            snDuplicateWrapper.eq((Object)"rule10", (Object)snVO.getRule10());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule11())) {
            snDuplicateWrapper.eq((Object)"rule11", (Object)snVO.getRule11());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule12())) {
            snDuplicateWrapper.eq((Object)"rule12", (Object)snVO.getRule12());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule13())) {
            snDuplicateWrapper.eq((Object)"rule13", (Object)snVO.getRule13());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule14())) {
            snDuplicateWrapper.eq((Object)"rule14", (Object)snVO.getRule14());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule15())) {
            snDuplicateWrapper.eq((Object)"rule15", (Object)snVO.getRule15());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule16())) {
            snDuplicateWrapper.eq((Object)"rule16", (Object)snVO.getRule16());
        }
    }

    @RequestMapping(value={"commitBillCode"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse commitBillCode(@RequestBody BillCodeApiVO apiVO) {
        String strInfo = JSONObject.toJSONString((Object)apiVO);
        this.logger.info("\u63d0\u53f7\u53c2\u6570---->" + strInfo);
        List snList = apiVO.getSnList();
        if (snList == null || snList.size() == 0) {
            return CommonResponse.error((String)"snList\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
        }
        ArrayList<BillCodeRuleSNEntity> snEntityList = new ArrayList<BillCodeRuleSNEntity>();
        for (BillCodeRuleSNVO snVO : snList) {
            QueryWrapper snQueryWrapper = new QueryWrapper();
            snQueryWrapper.eq((Object)"source_pid", (Object)snVO.getSourcePid());
            snQueryWrapper.eq((Object)"rule_type", (Object)snVO.getRuleType());
            snQueryWrapper.eq((Object)"generate_bill_code", (Object)snVO.getGenerateBillCode());
            int count = this.snService.count((Wrapper)snQueryWrapper);
            if (count > 0) continue;
            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
            ArrayList<Long> idList = new ArrayList<Long>();
            idList.add(snVO.getSourcePid());
            sourceMap.put("ids", idList);
            this.releaseBillCode(sourceMap);
            BillCodeRuleSNEntity snEntity = (BillCodeRuleSNEntity)((Object)BeanMapper.map((Object)snVO, BillCodeRuleSNEntity.class));
            snEntityList.add(snEntity);
        }
        this.snService.saveOrUpdateBatch(snEntityList, snEntityList.size(), false);
        return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01");
    }

    @RequestMapping(value={"releaseBillCode"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse releaseBillCode(@RequestBody Map<String, Object> sourceIds) {
        this.logger.info("\u8fd8\u53f7\u53c2\u6570---->" + sourceIds.toString());
        if (sourceIds.get("ids") == null) {
            return CommonResponse.error((String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList sourcePidList = (ArrayList)sourceIds.get("ids");
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.in((Object)"source_pid", (Collection)sourcePidList);
        this.snService.remove((Wrapper)deleteWrapper, false);
        return CommonResponse.success((String)"\u8fd8\u53f7\u6210\u529f");
    }

    public static Object[] generateSerialNumber(int initialNumber, int digitCount, Map snMap) {
        int nextSerialNumber = BillCodeRuleApi.getNextSerialNumber(initialNumber);
        while (snMap.containsKey(nextSerialNumber)) {
            nextSerialNumber = BillCodeRuleApi.getNextSerialNumber(nextSerialNumber);
        }
        String format = "%0" + digitCount + "d";
        String serialNumber = String.format(format, nextSerialNumber);
        Object[] objArr = new Object[]{nextSerialNumber, serialNumber};
        return objArr;
    }

    private static int getNextSerialNumber(int currentSerialNumber) {
        return currentSerialNumber + 1;
    }

    public static <T, V> V getFieldValue(T object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (V)field.get(object);
    }
}

