/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.pub.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pub.bean.BillCodeRuleEntity;
import com.ejianc.business.pub.bean.BillCodeRuleSNEntity;
import com.ejianc.business.pub.mapper.BillCodeRuleMapper;
import com.ejianc.business.pub.service.IBillCodeRuleSNService;
import com.ejianc.business.pub.service.IBillCodeRuleService;
import com.ejianc.business.pub.vo.BillCodeRuleAttrVO;
import com.ejianc.business.pub.vo.BillCodeRuleVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="billCodeRuleService")
public class BillCodeRuleServiceImpl
extends BaseServiceImpl<BillCodeRuleMapper, BillCodeRuleEntity>
implements IBillCodeRuleService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IBillCodeRuleService service;
    @Autowired
    private IBillCodeRuleSNService billCodeRuleSNService;
    private static final String BILL_CODE = "ZTPC_BILL_CODE";

    @Override
    public CommonResponse<BillCodeRuleVO> saveOrUpdate(BillCodeRuleVO saveOrUpdateVO) {
        List billCodeRuleAttrList = saveOrUpdateVO.getBillCodeRuleAttrList().stream().filter(o -> !"del".equals(o.getRowState())).collect(Collectors.toList());
        Integer startNum = 0;
        if (billCodeRuleAttrList != null && billCodeRuleAttrList.size() > 0) {
            for (BillCodeRuleAttrVO billCodeRuleAttrVO : billCodeRuleAttrList) {
                if (!"rule06".equals(billCodeRuleAttrVO.getRuleElemCode())) continue;
                if (billCodeRuleAttrVO.getElemLength() == null) {
                    return CommonResponse.error((String)"\u5b50\u8868\u3010\u7f16\u7801\u89c4\u5219\u5b50\u5143\u7d20\u3011\u5e8f\u5217\u53f7\u5fc5\u987b\u8bbe\u7f6e\u5143\u7d20\u957f\u5ea6\uff01");
                }
                if (billCodeRuleAttrVO.getStartNum() == null) {
                    return CommonResponse.error((String)"\u5b50\u8868\u3010\u7f16\u7801\u89c4\u5219\u5b50\u5143\u7d20\u3011\u5e8f\u5217\u53f7\u5fc5\u987b\u8bbe\u7f6e\u6d41\u6c34\u8d77\u59cb\u53f7\uff01");
                }
                startNum = billCodeRuleAttrVO.getStartNum();
            }
        } else {
            return CommonResponse.error((String)"\u5b50\u8868\u3010\u7f16\u7801\u89c4\u5219\u5b50\u5143\u7d20\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BillCodeRuleEntity entity = (BillCodeRuleEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), BillCodeRuleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setId(IdWorker.getId());
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        QueryWrapper SNQuery1 = new QueryWrapper();
        SNQuery1.eq((Object)"rule_id", (Object)entity.getId());
        SNQuery1.eq((Object)"is_init", (Object)"1");
        BillCodeRuleSNEntity snServiceOne = (BillCodeRuleSNEntity)((Object)this.billCodeRuleSNService.getOne((Wrapper)SNQuery1, false));
        if (snServiceOne != null) {
            return CommonResponse.error((String)"\u8be5\u53d6\u53f7\u89c4\u5219\u5df2\u88ab\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        BillCodeRuleVO vo = (BillCodeRuleVO)((Object)BeanMapper.map((Object)((Object)entity), BillCodeRuleVO.class));
        QueryWrapper SNQuery2 = new QueryWrapper();
        SNQuery2.eq((Object)"rule_id", (Object)entity.getId());
        SNQuery2.eq((Object)"is_init", (Object)"0");
        BillCodeRuleSNEntity snInitOne = (BillCodeRuleSNEntity)((Object)this.billCodeRuleSNService.getOne((Wrapper)SNQuery2, false));
        if (snInitOne == null) {
            snInitOne = new BillCodeRuleSNEntity();
            snInitOne.setRuleId(entity.getId());
            snInitOne.setIsInit("0");
            snInitOne.setStartSn(startNum);
        } else {
            snInitOne.setStartSn(startNum);
        }
        this.billCodeRuleSNService.saveOrUpdate((Object)snInitOne);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }
}

