package com.ejianc.business.pub.controller;

import java.io.Serializable;

import com.ejianc.business.pub.util.Constants;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.pub.bean.DataDictionaryCategoryEntity;
import com.ejianc.business.pub.service.IDataDictionaryCategoryService;
import com.ejianc.business.pub.vo.DataDictionaryCategoryVO;

/**
 * 数据字典分类
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dataDictionaryCategory")
public class DataDictionaryCategoryController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IDataDictionaryCategoryService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProjectSetApi projectSetApi;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DataDictionaryCategoryVO> saveOrUpdate(@RequestBody DataDictionaryCategoryVO saveOrUpdateVO) {
        CommonResponse<DataDictionaryCategoryVO> response = service.saveOrUpdateCategory(saveOrUpdateVO);
    	return response;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DataDictionaryCategoryVO> queryDetail(Long id) {
    	DataDictionaryCategoryEntity entity = service.selectById(id);
    	DataDictionaryCategoryVO vo = BeanMapper.map(entity, DataDictionaryCategoryVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DataDictionaryCategoryVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DataDictionaryCategoryVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DataDictionaryCategoryVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<Map<String, Object>>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
//        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //项目部 id
        List<String> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            departmentIds.add(org.getId()+"");
        });

        if(CollectionUtils.isNotEmpty(departmentIds)) {
            departmentIds.add(Constants.LEVEL_GROUP);
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgCode", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("category_id", QueryParam.DESC);
        orderMap.put("level", QueryParam.ASC);
        orderMap.put("line", QueryParam.ASC);

        List<DataDictionaryCategoryVO> dataList = service.queryDataDictionaryCategoryList(param);

        logger.info("dataList：", JSONObject.toJSONString(dataList));
        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("leaf").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });
        List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
        return CommonResponse.success(treeData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DataDictionaryCategoryEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DataDictionaryCategory-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDataDictionaryCategoryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DataDictionaryCategoryVO>> refDataDictionaryCategoryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DataDictionaryCategoryEntity> page = service.queryPage(param,false);
        IPage<DataDictionaryCategoryVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DataDictionaryCategoryVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 物资分类树
     *
     * @param condition
     * @return
     */
    @RequestMapping(value = "/queryCategoryRefTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> queryCategoryRefTree(@RequestParam(required = false) String condition) {
        if (StringUtils.isBlank(condition)) {
            return null;
        }

        //先根据项目id + 分类名称查询根节点
        Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
        String projectId = conditionMap.get("projectId").toString();
        CommonResponse<ProjectPoolSetVO> responseVO = projectSetApi.getProjectId(new Long(projectId));

        QueryParam parentParam = new QueryParam();
        if(responseVO.getCode() == 0 && responseVO.getData() != null) {
            ProjectPoolSetVO projectPoolSetVO = responseVO.getData();
            parentParam.getParams().put("orgCode", new Parameter(QueryParam.EQ, projectPoolSetVO.getProjectDepartmentId()));

            String categoryName = conditionMap.get("categoryName").toString();
            parentParam.getParams().put("categoryName", new Parameter(QueryParam.EQ, categoryName));
        }

        List<DataDictionaryCategoryEntity> categoryEntities = service.queryList(parentParam, false);
        if(categoryEntities == null || categoryEntities.size() == 0){
            //根据项目查询跟节点为空，查询公共的
            parentParam.getParams().put("orgCode", new Parameter(QueryParam.EQ, Constants.LEVEL_GROUP));
            categoryEntities = service.queryList(parentParam, false);

            //第二次查询还是空，那就是无数据
            if(categoryEntities == null || categoryEntities.size() == 0){
                return null;
            }
        }

        //再根据innerCode查询所有子节点
        QueryParam queryParam = new QueryParam();
        if(conditionMap.get("isTop") != null){
            //查询一级节点
            queryParam.getParams().put("parentId", new Parameter(QueryParam.EQ, categoryEntities.get(0).getId()));
        }else if(conditionMap.get("parentId") != null){
            //根据父节点查询子节点
            queryParam.getParams().put("parentId", new Parameter(QueryParam.EQ, conditionMap.get("parentId").toString()));
        }else{
            queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE_LEFT, categoryEntities.get(0).getId()));
        }
        List<DataDictionaryCategoryVO> dataList = service.queryDataDictionaryCategoryList(queryParam);
        for (DataDictionaryCategoryVO categoryVO : dataList) {
            if(categoryVO.getCategoryName().equals(conditionMap.get("categoryName").toString())){
                categoryVO.setName(categoryVO.getCategoryName() + "（" + categoryVO.getLevel() + "）");
            } else {
                categoryVO.setName(categoryVO.getCategoryCode() + "-" + categoryVO.getCategoryName());
            }
        }

        if (ListUtil.isEmpty(dataList)) {
            return new ArrayList<>();
        }

        List<Map> resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l-> {
            if(l.get("leaf").equals(false)){
                l.put("children", new ArrayList<>());
            }
        });
        List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);
        return treeData;
    }
}
