package com.ejianc.business.pub.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.pub.bean.BillCodeRuleAttrEntity;
import com.ejianc.business.pub.bean.BillCodeRuleEntity;
import com.ejianc.business.pub.bean.BillCodeRuleSNEntity;
import com.ejianc.business.pub.service.IBillCodeRuleAttrService;
import com.ejianc.business.pub.service.IBillCodeRuleSNService;
import com.ejianc.business.pub.service.IBillCodeRuleService;
import com.ejianc.business.pub.vo.BillCodeRuleVO;
import com.ejianc.business.pub.vo.enumvo.RuleElemType;
import com.ejianc.business.ztpc.billcode.bean.BillCodeApiVO;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleSNVO;
import com.ejianc.business.ztpc.billcode.bean.RuleTypeEnum;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.*;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/api/ztpcBillCode/")
public class BillCodeRuleApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeRuleService codeService;

    @Autowired
    private IBillCodeRuleAttrService attrService;

    @Autowired
    private IBillCodeRuleSNService snService;

    @RequestMapping(value = "generateBillCode", method= RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BillCodeApiVO> generateBillCode(@RequestBody BillCodeApiVO apiVO) throws IntrospectionException {
        String stringInfo = JSONObject.toJSONString(apiVO);
        logger.info("取号参数---->" + stringInfo);

        List<BillCodeRuleSNVO> snList = apiVO.getSnList();
        if(snList == null || snList.size() == 0){
            return CommonResponse.error("snList不允许为空!");
        }

        List<BillCodeRuleSNVO> snRetList = new ArrayList<>();//用来存放返回的流水VO
        for (BillCodeRuleSNVO snVO : snList) {
            //查询编码规则
            QueryWrapper<BillCodeRuleEntity> ruleQuery = new QueryWrapper<>();
            ruleQuery.eq("project_id", apiVO.getProjectId());
            ruleQuery.eq("category_id", apiVO.getCategoryId());
            ruleQuery.eq("rule_type", snVO.getRuleType());

            BillCodeRuleEntity billCodeRuleEntity = codeService.getOne(ruleQuery, false);

            if(billCodeRuleEntity == null ){
                if(RuleTypeEnum.内部编码.getCode().equals(snVO.getRuleType())){
                    return CommonResponse.error(RuleTypeEnum.内部编码.getName() + "-未匹配到取号编码规则，请检查!");
                }else if(RuleTypeEnum.外部编码.getCode().equals(snVO.getRuleType())){
                    return CommonResponse.error(RuleTypeEnum.外部编码.getName() + "-未匹配到取号编码规则，请检查!");
                }
            }

            BillCodeRuleSNVO retSnVO = new BillCodeRuleSNVO();

            //幂等
            QueryWrapper<BillCodeRuleSNEntity> snDuplicateWrapper = new QueryWrapper<>();
            snDuplicateWrapper.eq("rule_id",billCodeRuleEntity.getId());
            snDuplicateWrapper.eq("source_pid",snVO.getSourcePid());
            buildDuplicateWrapper(snDuplicateWrapper,snVO);

            BillCodeRuleSNEntity snDuplicateEntity = snService.getOne(snDuplicateWrapper, false);
            if(snDuplicateEntity != null){
                logger.info(snVO.getSourceCode()+"----"+snDuplicateEntity.getGenerateBillCode() + "已存在，无需重复取号---->");
                retSnVO = BeanMapper.map(snDuplicateEntity, BillCodeRuleSNVO.class);
                snRetList.add(retSnVO);
                continue;
            }

            /**开始组装编码start**/
            //查询编码规则明细
            QueryParam attQuery = new QueryParam();
            attQuery.getParams().put("rule_id",new Parameter(QueryParam.EQ, billCodeRuleEntity.getId()));
            LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
            orderMap.put("id", QueryParam.ASC);
            attQuery.setOrderMap(orderMap);

            List<BillCodeRuleAttrEntity> ruleAttrEntities = attrService.queryList(attQuery, false);
            String separator = billCodeRuleEntity.getSeparatorStr() == null ? "" : billCodeRuleEntity.getSeparatorStr();
            StringBuffer sb = new StringBuffer();
//          BillCodeRuleSNEntity saveEntity = new BillCodeRuleSNEntity();
            for (BillCodeRuleAttrEntity attrEntity : ruleAttrEntities) {
                if(RuleElemType.常量.getCode().equals(attrEntity.getRuleElemType())){
                    sb.append(attrEntity.getElemValue()).append(separator);
                }else if( RuleElemType.自定义流水依据.getCode().equals(attrEntity.getRuleElemType())){
                    String ruleElemCode = attrEntity.getRuleElemCode();
                    try {
                        Object fieldValue = getFieldValue(snVO, ruleElemCode);
                        sb.append(fieldValue.toString()).append(separator);

                        //反射动态赋值
                        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(ruleElemCode, retSnVO.getClass());
                        Method method = propertyDescriptor.getWriteMethod();
                        method.invoke(retSnVO, fieldValue.toString());
                    } catch (NoSuchFieldException e) {
                        e.printStackTrace();
                        return CommonResponse.error("字段【 " + ruleElemCode + "】未设置get、set方法！!");
                    } catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return CommonResponse.error("字段【 " + ruleElemCode + "】未传入对应的值！!");
                    } catch (InvocationTargetException e) {
                        e.printStackTrace();
                        return CommonResponse.error("字段【 " + ruleElemCode + "】未设置get、set方法！!");
                    }
                }else if(RuleElemType.流水号.getCode().equals(attrEntity.getRuleElemType())){
                    QueryWrapper<BillCodeRuleSNEntity> snWrapper1 = new QueryWrapper<>();
                    List<BillCodeRuleSNEntity> snEntities = null;
                    if(RuleTypeEnum.外部编码.getCode().equals(snVO.getRuleType())) {
                        //专业不同、取号重新计数
                        snWrapper1.select("start_sn,id");
                        snWrapper1.eq("rule_id", billCodeRuleEntity.getId());
                        snWrapper1.eq("rule_type", RuleTypeEnum.外部编码.getCode());
                        snWrapper1.eq("is_init", "1");
//                        snWrapper1.ne("source_pid", snVO.getSourcePid());
                        buildDuplicateWrapper(snWrapper1, retSnVO);
                        snEntities = snService.list(snWrapper1);
                    }else if(RuleTypeEnum.内部编码.getCode().equals(snVO.getRuleType())){
                        //内部编码不管自定义流水依据怎么切换，流水号按顺序排，不重置
                        snWrapper1.select("start_sn,id");
                        snWrapper1.eq("rule_id", billCodeRuleEntity.getId());
                        snWrapper1.eq("rule_type", RuleTypeEnum.内部编码.getCode());
                        snWrapper1.eq("is_init", "1");
//                        snWrapper1.ne("source_pid", snVO.getSourcePid());
                        snEntities = snService.list(snWrapper1);
                    }

                    if(snEntities == null || snEntities.size() == 0){
                        //如果无数据，查询初始化的流水号
                        QueryWrapper<BillCodeRuleSNEntity> snWrapper2 = new QueryWrapper<>();
                        snWrapper2.select("start_sn,id");
                        snWrapper2.eq("rule_id",billCodeRuleEntity.getId());
                        snWrapper2.eq("is_init","0");
                        snWrapper2.orderByAsc("id");
                        snEntities = snService.list(snWrapper2);
                    }

                    List<Integer> startSnList = snEntities.stream().map(BillCodeRuleSNEntity::getStartSn).collect(Collectors.toList());

                    int initialNumber = attrEntity.getStartNum() == null ? 0 : attrEntity.getStartNum();//起始流水号
                    Object[] objArr = generateSerialNumber(initialNumber, attrEntity.getElemLength(), startSnList);
                    sb.append(objArr[1].toString()).append(separator);

                    retSnVO.setStartSn( Integer.parseInt(objArr[0].toString()) );//序列数值
                    retSnVO.setCurrSn(objArr[1].toString());//序列格式化
                }
            }
            if(StringUtils.isNotEmpty(separator)){
                String generateBillCode = sb.substring(0, sb.length() - separator.length());
                retSnVO.setGenerateBillCode(generateBillCode);//序列化编码
            }else{
                retSnVO.setGenerateBillCode(sb.toString());//序列化编码
            }

            //保存规则sn流水
            retSnVO.setProjectId(apiVO.getProjectId());
            retSnVO.setProjectCode(apiVO.getProjectCode());
            retSnVO.setProjectName(apiVO.getProjectName());
            retSnVO.setCategoryId(apiVO.getCategoryId());

            retSnVO.setRuleType(snVO.getRuleType());
            retSnVO.setIsInit("1");//非初始化
            retSnVO.setRuleId(billCodeRuleEntity.getId());//规则id
            retSnVO.setSourcePid(snVO.getSourcePid());//来源id
            retSnVO.setSourceCode(snVO.getSourceCode());//来源单据编码
            retSnVO.setSourceType(snVO.getSourceType());//来源单据类型
            retSnVO.setSourceTypeName(snVO.getSourceTypeName());;//来源单据类型名称
            snRetList.add(retSnVO);
//        snService.saveOrUpdate(saveEntity);
            /**组装编码end**/
            String retSnVOInfo = JSONObject.toJSONString(retSnVO);
            logger.info("取号返回信息---->" + retSnVOInfo);
        }
        apiVO.setSnList(snRetList);
        return CommonResponse.success("生成编码成功",apiVO);

    }

    public void buildDuplicateWrapper(QueryWrapper<BillCodeRuleSNEntity> snDuplicateWrapper,BillCodeRuleSNVO snVO){
        if(StringUtils.isNotEmpty(snVO.getRule05())){
            snDuplicateWrapper.eq("rule05",snVO.getRule05());
        }
        if(StringUtils.isNotEmpty(snVO.getRule07())){
            snDuplicateWrapper.eq("rule07",snVO.getRule07());
        }
        if(StringUtils.isNotEmpty(snVO.getRule08())){
            snDuplicateWrapper.eq("rule08",snVO.getRule08());
        }
        if(StringUtils.isNotEmpty(snVO.getRule09())){
            snDuplicateWrapper.eq("rule09",snVO.getRule09());
        }
        if(StringUtils.isNotEmpty(snVO.getRule10())){
            snDuplicateWrapper.eq("rule10",snVO.getRule10());
        }
        if(StringUtils.isNotEmpty(snVO.getRule11())){
            snDuplicateWrapper.eq("rule11",snVO.getRule11());
        }
        if(StringUtils.isNotEmpty(snVO.getRule12())){
            snDuplicateWrapper.eq("rule12",snVO.getRule12());
        }
        if(StringUtils.isNotEmpty(snVO.getRule13())){
            snDuplicateWrapper.eq("rule13",snVO.getRule13());
        }
        if(StringUtils.isNotEmpty(snVO.getRule14())){
            snDuplicateWrapper.eq("rule14",snVO.getRule14());
        }
        if(StringUtils.isNotEmpty(snVO.getRule15())){
            snDuplicateWrapper.eq("rule15",snVO.getRule15());
        }
        if(StringUtils.isNotEmpty(snVO.getRule16())){
            snDuplicateWrapper.eq("rule16",snVO.getRule16());
        }

        if(StringUtils.isNotEmpty(snVO.getRule17())){
            snDuplicateWrapper.eq("rule17",snVO.getRule17());
        }
        if(StringUtils.isNotEmpty(snVO.getRule18())){
            snDuplicateWrapper.eq("rule18",snVO.getRule18());
        }
        if(StringUtils.isNotEmpty(snVO.getRule19())){
            snDuplicateWrapper.eq("rule19",snVO.getRule19());
        }
        if(StringUtils.isNotEmpty(snVO.getRule20())){
            snDuplicateWrapper.eq("rule20",snVO.getRule20());
        }
        if(StringUtils.isNotEmpty(snVO.getRule21())){
            snDuplicateWrapper.eq("rule21",snVO.getRule21());
        }
        if(StringUtils.isNotEmpty(snVO.getRule22())){
            snDuplicateWrapper.eq("rule22",snVO.getRule22());
        }
        if(StringUtils.isNotEmpty(snVO.getRule23())){
            snDuplicateWrapper.eq("rule23",snVO.getRule23());
        }
        if(StringUtils.isNotEmpty(snVO.getRule24())){
            snDuplicateWrapper.eq("rule24",snVO.getRule24());
        }
        if(StringUtils.isNotEmpty(snVO.getRule25())){
            snDuplicateWrapper.eq("rule25",snVO.getRule25());
        }
        if(StringUtils.isNotEmpty(snVO.getRule26())){
            snDuplicateWrapper.eq("rule26",snVO.getRule26());
        }
    }

    /**
     * 提号
     * @param apiVO
     * @return
     */
    @RequestMapping(value = "commitBillCode", method= RequestMethod.POST)
    @ResponseBody
    public CommonResponse commitBillCode(@RequestBody BillCodeApiVO apiVO) {
        String strInfo = JSONObject.toJSONString(apiVO);
        logger.info("提号参数---->" + strInfo);

        List<BillCodeRuleSNVO> snList = apiVO.getSnList();
        if(snList == null || snList.size() == 0){
            return CommonResponse.error("snList不允许为空!");
        }
        List<BillCodeRuleSNEntity> snEntityList = new ArrayList<>();
        for (BillCodeRuleSNVO snVO : snList) {
            QueryWrapper<BillCodeRuleSNEntity> snQueryWrapper = new QueryWrapper<>();
            snQueryWrapper.eq("source_pid",snVO.getSourcePid());
            snQueryWrapper.eq("rule_type",snVO.getRuleType());
            snQueryWrapper.eq("generate_bill_code",snVO.getGenerateBillCode());
            int count = snService.count(snQueryWrapper);
            if(count > 0){
                //如果号段没有变化，不用重复提交
                continue;
            }else{
                //先根据来源id还号
                Map sourceMap = new HashMap<String, Object>() ;
                List idList = new ArrayList<String>();
                idList.add(snVO.getSourcePid());
                sourceMap.put("ids",idList);
                this.releaseBillCode(sourceMap);

                //再提号
                BillCodeRuleSNEntity snEntity = BeanMapper.map(snVO, BillCodeRuleSNEntity.class);
                snEntityList.add(snEntity);
            }
        }
        snService.saveOrUpdateBatch(snEntityList,snEntityList.size(),false);
        return CommonResponse.success("处理成功！");
    }

    /**
     * 还号
     * @param sourceIds 来源单据id，可以传多个，以list的形式
     * @return
     */
    @RequestMapping(value = "releaseBillCode", method= RequestMethod.POST)
    @ResponseBody
    public CommonResponse releaseBillCode(@RequestBody Map<String, Object> sourceIds) {
        logger.info("还号参数---->" + sourceIds.toString());

        if(sourceIds.get("ids") == null){
            return CommonResponse.error("ids不能为空");
        }

        ArrayList<String> sourcePidList = (ArrayList<String>)sourceIds.get("ids");
        QueryWrapper<BillCodeRuleSNEntity> deleteWrapper = new QueryWrapper<>();
        deleteWrapper.in("source_pid", sourcePidList);
        snService.remove(deleteWrapper,false);
        return CommonResponse.success("还号成功");
    }


    /**
     * @param initialNumber     初始化值
     * @param digitCount    流水号位数
     * @param startSnList    流水号集合
     * @return
     */
    public static Object[] generateSerialNumber(int initialNumber, int digitCount, List<Integer> startSnList) {
        int nextSerialNumber = getNextSerialNumber(initialNumber); // 将流水号递增1
        while (startSnList.contains(nextSerialNumber)) {
            nextSerialNumber = getNextSerialNumber(nextSerialNumber);
        }

        String format = "%0" + digitCount + "d"; // 根据位数生成格式化字符串
        String serialNumber = String.format(format, nextSerialNumber);

        Object[] objArr = new Object[]{nextSerialNumber,serialNumber};
        return objArr;
    }

    private static int getNextSerialNumber(int currentSerialNumber) {
        return currentSerialNumber + 1;
    }
    public static <T, V> V getFieldValue(T object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (V) field.get(object);
    }

    /**
     * 获取单据编码规则
     *
     * @param projectId  项目ID
     * @param categoryId 文档分类主键ID
     * @param ruleType   规则类型，0内部编码，1外部编码
     * @return 单据编码规则
     */
    @RequestMapping(value = "getBillCodeRule", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BillCodeRuleVO> getBillCodeRule(@RequestParam("projectId") Long projectId,
                                                                @RequestParam("categoryId") Long categoryId,
                                                                @RequestParam("ruleType") String ruleType) {
        if (projectId == null || categoryId == null || StringUtils.isBlank(ruleType)) {
            return CommonResponse.error("获取单据编码规则 失败！查询参数不能为空！");
        }
        BillCodeRuleVO billCodeRuleVO;
        //查询编码规则
        QueryWrapper<BillCodeRuleEntity> ruleQuery = new QueryWrapper<>();
        ruleQuery.eq("project_id", projectId);
        ruleQuery.eq("category_id", categoryId);
        ruleQuery.eq("rule_type", ruleType);

        BillCodeRuleEntity billCodeRuleEntity = codeService.getOne(ruleQuery, false);

        if (billCodeRuleEntity == null) {
            if (RuleTypeEnum.内部编码.getCode().equals(ruleType)) {
                return CommonResponse.error(RuleTypeEnum.内部编码.getName() + "-未匹配到取号编码规则，请检查!");
            } else if (RuleTypeEnum.外部编码.getCode().equals(ruleType)) {
                return CommonResponse.error(RuleTypeEnum.外部编码.getName() + "-未匹配到取号编码规则，请检查!");
            }
            return CommonResponse.error(RuleTypeEnum.内部编码.getName() + "/" + RuleTypeEnum.外部编码.getName() + "-未匹配到取号编码规则，请检查!");
        }
        //查询编码规则明细
        QueryParam attQuery = new QueryParam();
        attQuery.getParams().put("rule_id", new Parameter(QueryParam.EQ, billCodeRuleEntity.getId()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<>();
        orderMap.put("id", QueryParam.ASC);
        attQuery.setOrderMap(orderMap);

        List<BillCodeRuleAttrEntity> ruleAttrEntities = attrService.queryList(attQuery, false);
        billCodeRuleEntity.setBillCodeRuleAttrList(ruleAttrEntities);
        billCodeRuleVO = BeanMapper.map(billCodeRuleEntity, BillCodeRuleVO.class);
        return CommonResponse.success(billCodeRuleVO);
    }
}
