package com.ejianc.business.pub.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pub.util.Constants;
import com.ejianc.business.pub.vo.DataDictionaryCategoryVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pub.mapper.DataDictionaryCategoryMapper;
import com.ejianc.business.pub.bean.DataDictionaryCategoryEntity;
import com.ejianc.business.pub.service.IDataDictionaryCategoryService;

import java.util.*;

/**
 * 数据字典分类
 * 
 * @author generator
 * 
 */
@Service("dataDictionaryCategoryService")
public class DataDictionaryCategoryServiceImpl extends BaseServiceImpl<DataDictionaryCategoryMapper, DataDictionaryCategoryEntity> implements IDataDictionaryCategoryService{
    @Autowired
    private IDataDictionaryCategoryService service;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<DataDictionaryCategoryVO> saveOrUpdateCategory(DataDictionaryCategoryVO saveOrUpdateVO) {
        DataDictionaryCategoryEntity entity = BeanMapper.map(saveOrUpdateVO, DataDictionaryCategoryEntity.class);

        if(entity.getId() == null || entity.getId() == 0){
            entity.setId(IdWorker.getId());

            if(entity.getParentId() != null && entity.getParentId() > 0) {
                DataDictionaryCategoryEntity DataDictionaryCategoryEntity = service.selectById(entity.getParentId());
                entity.setInnerCode(DataDictionaryCategoryEntity.getInnerCode()+"|"+entity.getId());
            }else{
                entity.setInnerCode(entity.getId().toString());
            }

            int orgType = sessionManager.getUserContext().getOrgType();
            if(orgType == 1){
                //集团
                entity.setOrgId(sessionManager.getUserContext().getOrgId());
                entity.setOrgCode("group");
                entity.setOrgName(sessionManager.getUserContext().getOrgName());
                entity.setLevel("公共级");
            }else if(orgType == 5){
                //项目部
                entity.setOrgId(sessionManager.getUserContext().getOrgId());
                entity.setOrgCode(sessionManager.getUserContext().getOrgId()+"");
                entity.setOrgName(sessionManager.getUserContext().getOrgName());
                entity.setLevel("项目级");
            }else{
                return CommonResponse.error("当前组织不允许新增");
            }

            service.save(entity);
            DataDictionaryCategoryVO vo = BeanMapper.map(entity, DataDictionaryCategoryVO.class);
            return CommonResponse.success("保存或修改单据成功！",vo);
        }else {
            LambdaUpdateWrapper<DataDictionaryCategoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(DataDictionaryCategoryEntity::getId,saveOrUpdateVO.getId());
            updateWrapper.set(DataDictionaryCategoryEntity::getCategoryName,saveOrUpdateVO.getCategoryName());
            updateWrapper.set(DataDictionaryCategoryEntity::getCategoryCode,saveOrUpdateVO.getCategoryCode());
            updateWrapper.set(DataDictionaryCategoryEntity::getOrgId,sessionManager.getUserContext().getOrgId());
            updateWrapper.set(DataDictionaryCategoryEntity::getOrgName,sessionManager.getUserContext().getOrgName());
            updateWrapper.set(DataDictionaryCategoryEntity::getRemarks,saveOrUpdateVO.getRemarks());
            updateWrapper.set(DataDictionaryCategoryEntity::getSequence,saveOrUpdateVO.getSequence());
            updateWrapper.set(DataDictionaryCategoryEntity::getUpdateUserCode,sessionManager.getUserContext().getUserCode());
            updateWrapper.set(DataDictionaryCategoryEntity::getUpdateTime,new Date());
            updateWrapper.set(DataDictionaryCategoryEntity::getCategoryProperty,saveOrUpdateVO.getCategoryProperty());

            int orgType = sessionManager.getUserContext().getOrgType();
            if(orgType == 1){
                //集团
                updateWrapper.set(DataDictionaryCategoryEntity::getOrgCode, Constants.LEVEL_GROUP);
                updateWrapper.set(DataDictionaryCategoryEntity::getLevel,Constants.LEVEL_PUB);
            }else if(orgType == 5){
                //项目部
                updateWrapper.set(DataDictionaryCategoryEntity::getOrgCode,sessionManager.getUserContext().getOrgId()+"");
                updateWrapper.set(DataDictionaryCategoryEntity::getLevel,Constants.LEVEL_PROJECT);
            }else{
                return CommonResponse.error("当前组织不允许编辑");
            }
            service.update(updateWrapper);

//            Long tenantId = InvocationInfoProxy.getTenantid();
//            List<Long> ids = new ArrayList<>();
//            ids.add(entity.getId());
//            List<DataDictionaryCategoryEntity> labsubCategoryEntities1 = labsubCategoryMapper.queryByInnerCodes(tenantId, ids);
//            ids.clear();
//            labsubCategoryEntities1.forEach(item->{
//                ids.add(item.getId());
//                // 更新字表的数据
//                labsubItemService.updateByCategoryId(item.getId(),entity.getSubjectId(),entity.getSubjectName());
//            });
//            labsubCategoryMapper.updateSubject(tenantId,entity.getSubjectId(),entity.getSubjectName(),ids);

            DataDictionaryCategoryEntity DataDictionaryCategoryEntity = service.selectById(saveOrUpdateVO.getId());
            if (DataDictionaryCategoryEntity!=null){
                // TODO: 2023/6/5   更新数据字典的分类名称
//                LambdaUpdateWrapper<LabsubItemEntity> lambdaUpdateWrapper = new LambdaUpdateWrapper<>();
//                lambdaUpdateWrapper.eq(LabsubItemEntity::getCategoryId,saveOrUpdateVO.getId());
//                lambdaUpdateWrapper.set(LabsubItemEntity::getCategoryName,DataDictionaryCategoryEntity.getCategoryName());
//                labsubItemService.update(lambdaUpdateWrapper);
            }
            return CommonResponse.success("保存或修改单据成功！");
        }

    }

    @Override
    public List<DataDictionaryCategoryVO> queryDataDictionaryCategoryList(QueryParam queryParam) {
        Map<String, Parameter> paramMap = queryParam.getParams();

        Map<String,Object> condition = new HashMap<>();
        for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
//        //放入租户ID进map
//        condition.put("tenantId", InvocationInfoProxy.getTenantid());
//        int orgType = sessionManager.getUserContext().getOrgType();
//        if(orgType == 1){
//            //集团
//            ArrayList<String> orgCodes = new ArrayList<String>();
//            orgCodes.add("group");
//            condition.put("orgCode", orgCodes);
//        }else if(orgType == 5){
//            //项目部
//            ArrayList<String> orgCodes = new ArrayList<String>();
//            orgCodes.add("group");
//            orgCodes.add(sessionManager.getUserContext().getOrgId()+"");
//            condition.put("orgCode", orgCodes);
//        }else{
//
//        }
        List<DataDictionaryCategoryVO> resultList = baseMapper.queryDataDictionaryCategoryList(condition);
        return resultList;
    }

}
