package com.ejianc.business.pub.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.pub.util.Constants;
import com.ejianc.business.pub.util.DetailIndexExcelReader;
import com.ejianc.business.pub.vo.DataDictionaryCategoryImportVO;
import com.ejianc.business.pub.vo.DataDictionaryCategoryVO;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.JsonArray;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pub.mapper.DataDictionaryCategoryMapper;
import com.ejianc.business.pub.bean.DataDictionaryCategoryEntity;
import com.ejianc.business.pub.service.IDataDictionaryCategoryService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 数据字典分类
 * 
 * @author generator
 * 
 */
@Service("dataDictionaryCategoryService")
public class DataDictionaryCategoryServiceImpl extends BaseServiceImpl<DataDictionaryCategoryMapper, DataDictionaryCategoryEntity> implements IDataDictionaryCategoryService{
    @Autowired
    private IDataDictionaryCategoryService service;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProjectSetApi projectSetApi;

    @Override
    public CommonResponse<DataDictionaryCategoryVO> saveOrUpdateCategory(DataDictionaryCategoryVO saveOrUpdateVO) {
        DataDictionaryCategoryEntity entity = BeanMapper.map(saveOrUpdateVO, DataDictionaryCategoryEntity.class);

        if(entity.getId() == null || entity.getId() == 0){
            entity.setId(IdWorker.getId());

            if(entity.getParentId() != null && entity.getParentId() > 0) {
                DataDictionaryCategoryEntity DataDictionaryCategoryEntity = service.selectById(entity.getParentId());
                entity.setInnerCode(DataDictionaryCategoryEntity.getInnerCode()+"|"+entity.getId());
            }else{
                entity.setInnerCode(entity.getId().toString());
            }

            int orgType = sessionManager.getUserContext().getOrgType();
            if(orgType == 1){
                //集团
                entity.setOrgId(sessionManager.getUserContext().getOrgId());
                entity.setOrgCode("group");
                entity.setOrgName(sessionManager.getUserContext().getOrgName());
                entity.setLevel("公共级");
            }else if(orgType == 5){
                //项目部
                entity.setOrgId(sessionManager.getUserContext().getOrgId());
                entity.setOrgCode(sessionManager.getUserContext().getOrgId()+"");
                entity.setOrgName(sessionManager.getUserContext().getOrgName());
                entity.setLevel("项目级");
            }else{
                return CommonResponse.error("当前组织不允许新增");
            }

            service.save(entity);
            DataDictionaryCategoryVO vo = BeanMapper.map(entity, DataDictionaryCategoryVO.class);
            return CommonResponse.success("保存或修改单据成功！",vo);
        }else {
            LambdaUpdateWrapper<DataDictionaryCategoryEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(DataDictionaryCategoryEntity::getId,saveOrUpdateVO.getId());
            updateWrapper.set(DataDictionaryCategoryEntity::getCategoryName,saveOrUpdateVO.getCategoryName());
            updateWrapper.set(DataDictionaryCategoryEntity::getCategoryCode,saveOrUpdateVO.getCategoryCode());
            updateWrapper.set(DataDictionaryCategoryEntity::getOrgId,sessionManager.getUserContext().getOrgId());
            updateWrapper.set(DataDictionaryCategoryEntity::getOrgName,sessionManager.getUserContext().getOrgName());
            updateWrapper.set(DataDictionaryCategoryEntity::getRemarks,saveOrUpdateVO.getRemarks());
            updateWrapper.set(DataDictionaryCategoryEntity::getSequence,saveOrUpdateVO.getSequence());
            updateWrapper.set(DataDictionaryCategoryEntity::getUpdateUserCode,sessionManager.getUserContext().getUserCode());
            updateWrapper.set(DataDictionaryCategoryEntity::getUpdateTime,new Date());
            updateWrapper.set(DataDictionaryCategoryEntity::getCategoryProperty,saveOrUpdateVO.getCategoryProperty());

            int orgType = sessionManager.getUserContext().getOrgType();
            if(orgType == 1){
                //集团
                updateWrapper.set(DataDictionaryCategoryEntity::getOrgCode, Constants.LEVEL_GROUP);
                updateWrapper.set(DataDictionaryCategoryEntity::getLevel,Constants.LEVEL_PUB);
            }else if(orgType == 5){
                //项目部
                updateWrapper.set(DataDictionaryCategoryEntity::getOrgCode,sessionManager.getUserContext().getOrgId()+"");
                updateWrapper.set(DataDictionaryCategoryEntity::getLevel,Constants.LEVEL_PROJECT);
            }else{
                return CommonResponse.error("当前组织不允许编辑");
            }
            service.update(updateWrapper);

//            Long tenantId = InvocationInfoProxy.getTenantid();
//            List<Long> ids = new ArrayList<>();
//            ids.add(entity.getId());
//            List<DataDictionaryCategoryEntity> labsubCategoryEntities1 = labsubCategoryMapper.queryByInnerCodes(tenantId, ids);
//            ids.clear();
//            labsubCategoryEntities1.forEach(item->{
//                ids.add(item.getId());
//                // 更新字表的数据
//                labsubItemService.updateByCategoryId(item.getId(),entity.getSubjectId(),entity.getSubjectName());
//            });
//            labsubCategoryMapper.updateSubject(tenantId,entity.getSubjectId(),entity.getSubjectName(),ids);

            DataDictionaryCategoryEntity DataDictionaryCategoryEntity = service.selectById(saveOrUpdateVO.getId());
            if (DataDictionaryCategoryEntity!=null){
                // TODO: 2023/6/5   更新数据字典的分类名称
//                LambdaUpdateWrapper<LabsubItemEntity> lambdaUpdateWrapper = new LambdaUpdateWrapper<>();
//                lambdaUpdateWrapper.eq(LabsubItemEntity::getCategoryId,saveOrUpdateVO.getId());
//                lambdaUpdateWrapper.set(LabsubItemEntity::getCategoryName,DataDictionaryCategoryEntity.getCategoryName());
//                labsubItemService.update(lambdaUpdateWrapper);
            }
            return CommonResponse.success("保存或修改单据成功！");
        }

    }

    @Override
    public Map<String, Long> materialClassificationTree(Map<String, String> conditionMap) {
        QueryParam parentParam = new QueryParam();
            String categoryName = conditionMap.get("categoryName").toString();
            parentParam.getParams().put("categoryName", new Parameter(QueryParam.EQ, categoryName));

        List<DataDictionaryCategoryEntity> categoryEntities = service.queryList(parentParam, false);
        Map<String, Long> map = new HashMap<>();
        if (ListUtil.isNotEmpty(categoryEntities)){
            map.put("name",categoryEntities.get(0).getId());
        }
        return map;
    }

    @Override
    public List<DataDictionaryCategoryVO> queryDataDictionaryCategoryList(QueryParam queryParam) {
        Map<String, Parameter> paramMap = queryParam.getParams();

        Map<String,Object> condition = new HashMap<>();
        for(Map.Entry<String, Parameter> entry:paramMap.entrySet()) {
            condition.put(entry.getKey(), entry.getValue().getValue());
        }
//        //放入租户ID进map
//        condition.put("tenantId", InvocationInfoProxy.getTenantid());
//        int orgType = sessionManager.getUserContext().getOrgType();
//        if(orgType == 1){
//            //集团
//            ArrayList<String> orgCodes = new ArrayList<String>();
//            orgCodes.add("group");
//            condition.put("orgCode", orgCodes);
//        }else if(orgType == 5){
//            //项目部
//            ArrayList<String> orgCodes = new ArrayList<String>();
//            orgCodes.add("group");
//            orgCodes.add(sessionManager.getUserContext().getOrgId()+"");
//            condition.put("orgCode", orgCodes);
//        }else{
//
//        }
        List<DataDictionaryCategoryVO> resultList = baseMapper.queryDataDictionaryCategoryList(condition);
        return resultList;
    }

    @Override
    public CommonResponse<JSONObject> excelDataDictionaryCategoryImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<DataDictionaryCategoryImportVO> successList = new ArrayList<>();
        List<DataDictionaryCategoryImportVO> errorList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            } else {
                if (result != null && result.size() > 0) {
                    if (result.size() > 10000) {
                        return CommonResponse.error("数据字典分类信息超过10000条，请分批上传！");
                    }

                    for (int i = 0; i < result.size(); i++) {
                        boolean flag = true;
                        List<String> datas = result.get(i);
                        StringBuilder errorMessage = new StringBuilder("");
                        DataDictionaryCategoryImportVO vo = new DataDictionaryCategoryImportVO();
                        vo.setId(IdWorker.getId());
                        DataDictionaryCategoryEntity parentCategory = null;
                        //父级编码
                        String parentCode = datas.get(0);
                        //分类属性
                        String categoryProperty = datas.get(1);
                        //分类编码
                        String categoryCode = datas.get(2);
                        //分类名称
                        String categoryName = datas.get(3);
                        //备注
                        String remark = datas.get(4);
                        //排序
                        String sequence = datas.get(5);
                        //级次
                        String level = datas.get(6);

                        if (StringUtils.isNotEmpty(parentCode)){
                            parentCategory = getOne(new QueryWrapper<DataDictionaryCategoryEntity>().lambda()
                                    .eq(DataDictionaryCategoryEntity::getDr, 0)
                                    .eq(DataDictionaryCategoryEntity::getCategoryCode, parentCode)
                                    .eq(DataDictionaryCategoryEntity::getCategoryProperty, "树")
                            );
                            if (parentCategory == null){
                                flag = false;
                                errorMessage.append("未找到父级字典分类");
                            }
                            vo.setParentId(parentCategory.getId());
                            vo.setInnerCode(parentCategory.getInnerCode()+"|"+vo.getId());
                        }else {
                            vo.setInnerCode(vo.getId().toString());
                        }

                        if (StringUtils.isNotEmpty(categoryProperty)){
                            if ("树".equals(categoryProperty) || "表".equals(categoryProperty)){
                                if (vo.getParentId() != null && vo.getParentId() > 0){
                                    vo.setCategoryProperty("树");
                                }else {
                                    vo.setCategoryProperty(categoryProperty);
                                }
                            }else {
                                flag = false;
                                errorMessage.append("分类属性格式错误");
                            }
                        }else {
                            flag = false;
                            errorMessage.append("分类属性为空");
                        }

                        if (StringUtils.isNotEmpty(categoryCode)){
                            vo.setCategoryCode(categoryCode);
                        }else {
                            flag = false;
                            errorMessage.append("分类编码为空");
                        }

                        if (StringUtils.isNotEmpty(categoryName)){
                            vo.setCategoryCode(categoryName);
                        }else {
                            flag = false;
                            errorMessage.append("分类名称为空");
                        }

                        if (StringUtils.isNotEmpty(remark)){
                            vo.setRemarks(remark);
                        }

                        if (StringUtils.isNotEmpty(sequence) && StringUtils.isNumeric(sequence)){
                            vo.setSequence(Integer.valueOf(sequence));
                        }else {
                            vo.setSequence(0);
                        }

                        vo.setRowIndex((i + 2));
                        if (flag) {
                            successList.add(vo);
                        } else {
                            vo.setErrorMessage(errorMessage.toString());
                            errorList.add(vo);
                        }
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList.stream().sorted(Comparator.comparing(DataDictionaryCategoryImportVO::getRowIndex)).collect(Collectors.toList()));
        return CommonResponse.success(json);
    }
}
