package com.ejianc.business.pub.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.pub.util.Constants;
import com.ejianc.business.pub.vo.DataDictionaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProjectPoolApi;
import com.ejianc.foundation.share.api.IProjectSetApi;
import com.ejianc.foundation.share.vo.ProjectPoolSetVO;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.pub.mapper.DataDictionaryMapper;
import com.ejianc.business.pub.bean.DataDictionaryEntity;
import com.ejianc.business.pub.service.IDataDictionaryService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 数据字典
 * 
 * @author generator
 * 
 */
@Service("dataDictionaryService")
public class DataDictionaryServiceImpl extends BaseServiceImpl<DataDictionaryMapper, DataDictionaryEntity> implements IDataDictionaryService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IDataDictionaryService service;

    @Autowired
    private IProjectPoolApi projectPoolApi;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IProjectSetApi projectSetApi;
    private static final String BILL_CODE = "DICTIONARY";//此处需要根据实际修改

    @Override
    public CommonResponse<DataDictionaryVO> saveOrUpdate(DataDictionaryVO saveOrUpdateVO) {
        DataDictionaryEntity entity = BeanMapper.map(saveOrUpdateVO, DataDictionaryEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            //数据校验
            QueryWrapper<DataDictionaryEntity> query1 = new QueryWrapper<>();
            query1.eq("category_id", saveOrUpdateVO.getCategoryId());
            query1.eq("level", Constants.LEVEL_PUB);
            query1.eq("dictionary_code", saveOrUpdateVO.getDictionaryCode());
            int count1 = service.count(query1);
            if (count1 > 0) {
                return CommonResponse.error("保存失败！该编码在公共级已创建，不允许重复：" + saveOrUpdateVO.getDictionaryCode());
            }

            QueryWrapper<DataDictionaryEntity> query2 = new QueryWrapper<>();
            query2.eq("category_id", saveOrUpdateVO.getCategoryId());
            query2.eq("level", Constants.LEVEL_PUB);//公共级
            query2.eq("dictionary_name", saveOrUpdateVO.getDictionaryName());
            int count2 = service.count(query2);
            if (count2 > 0) {
                return CommonResponse.error("保存失败！该名称在公共级已创建，不允许重复：" + saveOrUpdateVO.getDictionaryName());
            }

            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else{
            entity = service.selectById(saveOrUpdateVO.getId());
            entity.setDictionaryCode(saveOrUpdateVO.getDictionaryCode());
            entity.setDictionaryName(saveOrUpdateVO.getDictionaryName());
            entity.setLine(saveOrUpdateVO.getLine());
        }
        UserContext userContext = sessionManager.getUserContext();
        int orgType = userContext.getOrgType();
        if(orgType == 1){
            //集团
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgCode("group");
            entity.setOrgName(userContext.getOrgName());
            entity.setLevel(Constants.LEVEL_PUB);

        }else if(orgType == 5){
            //项目部
            entity.setOrgId(userContext.getOrgId());
            entity.setOrgCode(userContext.getOrgId()+"");
            entity.setOrgName(userContext.getOrgName());
            entity.setLevel(Constants.LEVEL_PROJECT);

            CommonResponse<ProjectVO> projectVOCommonResponse = projectPoolApi.queryProjectByProjectDepartmentId(userContext.getOrgId());
            ProjectVO projectVO = projectVOCommonResponse.getData();
            entity.setProjectId(projectVO.getId());
            entity.setProjectCode(projectVO.getBillCode());
            entity.setProjectName(projectVO.getProjectName());
        }else{
            return CommonResponse.error("当前组织不允许新增或修改");
        }

        service.saveOrUpdate(entity, false);
        DataDictionaryVO vo = BeanMapper.map(entity, DataDictionaryVO.class);
        return CommonResponse.success("保存成功",vo);
    }

    @Override
    public List<DataDictionaryVO> queryUnitBumber(Map<String, String> conditionMap) {

        QueryParam param = new QueryParam();
        if(null == conditionMap.get("projectId")) {
            return null;
        }else if(null == conditionMap.get("categoryCode")){
            return null;
        }

        Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
        CommonResponse<ProjectPoolSetVO> responseVO = projectSetApi.getProjectId(projectId);
        List<DataDictionaryVO> dataDictionaryVOS = null;

        if(responseVO.getCode() == 0 && responseVO.getData() != null) {
            ProjectPoolSetVO projectPoolSetVO = responseVO.getData();

            List<String> orgCodes = new ArrayList<>();
            orgCodes.add(projectPoolSetVO.getProjectDepartmentId().toString());
            orgCodes.add(Constants.LEVEL_GROUP);

            param.getParams().put("orgCode", new Parameter(QueryParam.IN, orgCodes));

            String categoryCode = conditionMap.get("categoryCode").toString();
            param.getParams().put("categoryCode", new Parameter(QueryParam.EQ, categoryCode));
            /** 租户隔离 */
            IPage<DataDictionaryEntity> page = service.queryPage(param, false);
             dataDictionaryVOS = BeanMapper.mapList(page.getRecords(), DataDictionaryVO.class);

        }
        return dataDictionaryVOS;
    }
}
