/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.ConSchemePlanEntity;
import com.ejianc.ztpc.mapper.ConSchemePlanMapper;
import com.ejianc.ztpc.service.IConSchemePlanService;
import com.ejianc.ztpc.util.DetailIndexExcelReader;
import com.ejianc.ztpc.vo.ConSchemePlanImportVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="conSchemePlanService")
public class ConSchemePlanServiceImpl
extends BaseServiceImpl<ConSchemePlanMapper, ConSchemePlanEntity>
implements IConSchemePlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ConSchemePlanMapper mapper;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<JSONObject> excelConSchemePlanImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<ConSchemePlanImportVO> successList = new ArrayList<ConSchemePlanImportVO>();
        ArrayList<ConSchemePlanImportVO> errorList = new ArrayList<ConSchemePlanImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5377\u518c\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            Map projDataMapAll = this.mapper.queryMapProjAll().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2));
            Map projDataMap = this.mapper.queryMapProjLocal().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            for (int i = 0; i < result.size(); ++i) {
                String specialtyType;
                ConSchemePlanImportVO vo;
                StringBuilder errorMessage;
                List datas;
                boolean flag;
                block54: {
                    block53: {
                        block52: {
                            block51: {
                                flag = true;
                                datas = (List)result.get(i);
                                errorMessage = new StringBuilder("");
                                vo = new ConSchemePlanImportVO();
                                vo.setId(IdWorker.getId());
                                String projectName = (String)datas.get(0);
                                Map projectNameMap = (Map)projDataMap.get(projectName);
                                if (StringUtils.isBlank((CharSequence)projectName) || MapUtils.isEmpty((Map)projectNameMap)) {
                                    errorMessage.append("[\u5de5\u7a0b\u540d\u79f0]").append(projectName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                                    flag = false;
                                } else {
                                    vo.setProjectName((String)projectNameMap.get("name"));
                                    vo.setProjectCode((String)projectNameMap.get("code"));
                                    Object id = projectNameMap.get("id");
                                    if (id instanceof String) {
                                        vo.setProjectId(Long.parseLong((String)id));
                                    } else {
                                        vo.setProjectId((Long)id);
                                    }
                                    Object engineeringTypeId = projectNameMap.get("engineering_type_id");
                                    if (engineeringTypeId instanceof String) {
                                        vo.setEngineeringTypeId(Long.parseLong((String)engineeringTypeId));
                                    } else {
                                        vo.setEngineeringTypeId((Long)engineeringTypeId);
                                    }
                                    Object projectLeave = projectNameMap.get("project_rank");
                                    if (engineeringTypeId instanceof String) {
                                        vo.setProjectLeave(Long.parseLong((String)projectLeave));
                                    } else {
                                        vo.setProjectLeave((Long)projectLeave);
                                    }
                                }
                                String consSchemeName = (String)datas.get(1);
                                if (StringUtils.isBlank((CharSequence)consSchemeName)) {
                                    errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u540d\u79f0]\u4e3a\u7a7a;");
                                    flag = false;
                                } else {
                                    vo.setConsSchemeName(consSchemeName);
                                }
                                specialtyType = (String)datas.get(2);
                                CommonResponse specialtyTypeDefdoc = this.iDefdocApi.getDefDocByDefCode("ct_specialty_type");
                                if (StringUtils.isBlank((CharSequence)specialtyType)) {
                                    errorMessage.append("[\u4e13\u4e1a\u5206\u7c7b]\u4e3a\u7a7a;");
                                    flag = false;
                                } else if (!specialtyTypeDefdoc.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)specialtyTypeDefdoc.getData()))) {
                                    errorMessage.append("[\u4e13\u4e1a\u5206\u7c7b]").append(specialtyType).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                                    flag = false;
                                } else {
                                    Long defdocDetailId = ((List)specialtyTypeDefdoc.getData()).stream().filter(a -> specialtyType.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                                    vo.setSpecialtyType(defdocDetailId);
                                }
                                String consSchemeType = (String)datas.get(3);
                                CommonResponse consSchemeTypeDefdoc = this.iDefdocApi.getDefDocByDefCode("ct_cons_scheme_type");
                                if (StringUtils.isBlank((CharSequence)consSchemeType)) {
                                    errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u7c7b\u522b]\u4e3a\u7a7a;");
                                    flag = false;
                                } else if (!consSchemeTypeDefdoc.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)consSchemeTypeDefdoc.getData()))) {
                                    errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u7c7b\u522b]").append(specialtyType).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                                    flag = false;
                                } else {
                                    Long defdocDetailId = ((List)consSchemeTypeDefdoc.getData()).stream().filter(a -> consSchemeType.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                                    vo.setConsSchemeType(defdocDetailId);
                                }
                                String approvalPower = (String)datas.get(4);
                                if (StringUtils.isBlank((CharSequence)approvalPower)) {
                                    errorMessage.append("[\u6279\u51c6\u6743\u9650]\u4e3a\u7a7a;");
                                    flag = false;
                                } else {
                                    vo.setApprovalPower(approvalPower);
                                }
                                String planRedactDate = (String)datas.get(5);
                                if (StringUtils.isBlank((CharSequence)planRedactDate)) {
                                    errorMessage.append("[\u8ba1\u5212\u7f16\u5236\u65f6\u95f4]\u4e3a\u7a7a;");
                                    flag = false;
                                } else {
                                    try {
                                        vo.setPlanRedactDate(DateUtils.parseDate((String)planRedactDate, (String[])new String[]{"yyyy-MM-dd"}));
                                    }
                                    catch (Exception e3) {
                                        errorMessage.append("[\u8ba1\u5212\u7f16\u5236\u65f6\u95f4]\u65e5\u671f\u683c\u5f0f\u9519\u8bef;");
                                        flag = false;
                                        if (!this.logger.isErrorEnabled()) break block51;
                                        this.logger.error("\u65bd\u5de5\u65b9\u6848\u7f16\u5236\u8ba1\u5212\u6e05\u5355 \u5bfc\u5165-\u6821\u9a8c\u6570\u636e \u5931\u8d25\uff01\u8ba1\u5212\u7f16\u5236\u65f6\u95f4\u7684\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                                    }
                                }
                            }
                            String redactFinishDate = (String)datas.get(6);
                            if (StringUtils.isBlank((CharSequence)redactFinishDate)) {
                                errorMessage.append("[\u7f16\u5236\u5b8c\u6210\u65f6\u95f4]\u4e3a\u7a7a;");
                                flag = false;
                            } else {
                                try {
                                    vo.setRedactFinishDate(DateUtils.parseDate((String)redactFinishDate, (String[])new String[]{"yyyy-MM-dd"}));
                                }
                                catch (Exception e4) {
                                    errorMessage.append("[\u7f16\u5236\u5b8c\u6210\u65f6\u95f4]\u65e5\u671f\u683c\u5f0f\u9519\u8bef;");
                                    flag = false;
                                    if (!this.logger.isErrorEnabled()) break block52;
                                    this.logger.error("\u65bd\u5de5\u65b9\u6848\u7f16\u5236\u8ba1\u5212\u6e05\u5355 \u5bfc\u5165-\u6821\u9a8c\u6570\u636e \u5931\u8d25\uff01\u7f16\u5236\u5b8c\u6210\u65f6\u95f4\u7684\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                                }
                            }
                        }
                        String orgExpertExamine = (String)datas.get(7);
                        if (StringUtils.isBlank((CharSequence)orgExpertExamine)) {
                            errorMessage.append("[\u7ec4\u7ec7\u4e13\u5bb6\u5ba1\u67e5\u8981\u6c42]\u4e3a\u7a7a;");
                            flag = false;
                        } else {
                            vo.setOrgExpertExamine("\u662f".equals(orgExpertExamine) ? "Y" : ("\u5426".equals(orgExpertExamine) ? "N" : ""));
                        }
                        String consTimeFrame = (String)datas.get(8);
                        if (StringUtils.isBlank((CharSequence)consTimeFrame)) {
                            errorMessage.append("[\u65bd\u5de5\u65f6\u6bb5]\u4e3a\u7a7a;");
                            flag = false;
                        } else {
                            try {
                                List<String> consTimeFrameList = Arrays.asList(consTimeFrame.split("~"));
                                DateUtils.parseDate((String)consTimeFrameList.get(0), (String[])new String[]{"yyyy-MM-dd"});
                                DateUtils.parseDate((String)consTimeFrameList.get(1), (String[])new String[]{"yyyy-MM-dd"});
                                vo.setConsTimeFrame(consTimeFrame);
                            }
                            catch (Exception e5) {
                                errorMessage.append("[\u65bd\u5de5\u65f6\u6bb5]\u65e5\u671f\u683c\u5f0f\u9519\u8bef;");
                                flag = false;
                                if (!this.logger.isErrorEnabled()) break block53;
                                this.logger.error("\u65bd\u5de5\u65b9\u6848\u7f16\u5236\u8ba1\u5212\u6e05\u5355 \u5bfc\u5165-\u6821\u9a8c\u6570\u636e \u5931\u8d25\uff01\u7f16\u5236\u5b8c\u6210\u65f6\u95f4\u7684\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                            }
                        }
                    }
                    String finishConsSchemeDate = (String)datas.get(9);
                    if (StringUtils.isBlank((CharSequence)finishConsSchemeDate)) {
                        errorMessage.append("[\u5b8c\u6210\u65bd\u5de5\u65b9\u6848\u65f6\u95f4]\u4e3a\u7a7a;");
                        flag = false;
                    } else {
                        try {
                            vo.setFinishConsSchemeDate(DateUtils.parseDate((String)finishConsSchemeDate, (String[])new String[]{"yyyy-MM-dd"}));
                        }
                        catch (Exception e6) {
                            errorMessage.append("[\u5b8c\u6210\u65bd\u5de5\u65b9\u6848\u65f6\u95f4]\u65e5\u671f\u683c\u5f0f\u9519\u8bef;");
                            flag = false;
                            if (!this.logger.isErrorEnabled()) break block54;
                            this.logger.error("\u65bd\u5de5\u65b9\u6848\u7f16\u5236\u8ba1\u5212\u6e05\u5355 \u5bfc\u5165-\u6821\u9a8c\u6570\u636e \u5931\u8d25\uff01\u5b8c\u6210\u65bd\u5de5\u65b9\u6848\u65f6\u95f4\u7684\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                        }
                    }
                }
                String projectTrait = (String)datas.get(10);
                CommonResponse projectTraitDefdoc = this.iDefdocApi.getDefDocByDefCode("ct_project_trait");
                if (StringUtils.isBlank((CharSequence)projectTrait)) {
                    errorMessage.append("[\u5206\u90e8\u5206\u9879\u5de5\u7a0b\u7279\u5f81]\u4e3a\u7a7a;");
                    flag = false;
                } else if (!projectTraitDefdoc.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)projectTraitDefdoc.getData()))) {
                    errorMessage.append("[\u5206\u90e8\u5206\u9879\u5de5\u7a0b\u7279\u5f81]").append(specialtyType).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                    flag = false;
                } else {
                    Long defdocDetailId = ((List)projectTraitDefdoc.getData()).stream().filter(a -> projectTrait.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                    vo.setProjectTrait(defdocDetailId);
                }
                String keyPointExplain = (String)datas.get(11);
                if (StringUtils.isBlank((CharSequence)keyPointExplain)) {
                    errorMessage.append("[\u4e13\u9879\u65bd\u5de5\u65b9\u6848\u5173\u6ce8\u91cd\u70b9]\u4e3a\u7a7a;");
                    flag = false;
                } else {
                    vo.setKeyPointExplain(keyPointExplain);
                }
                vo.setRedactDept(this.sessionManager.getUserContext().getDeptId());
                vo.setRowIndex(i + 2);
                Map stringStringMap = (Map)projDataMapAll.get(String.valueOf(vo.getProjectId()));
                vo.setOrgId((Long)stringStringMap.get("orgId"));
                vo.setOrgCode((String)stringStringMap.get("orgCode"));
                vo.setOrgName((String)stringStringMap.get("orgName"));
                vo.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                vo.setParentOrgCode((String)stringStringMap.get("parentOrgCode"));
                vo.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                if (flag) {
                    successList.add(vo);
                    continue;
                }
                vo.setErrorMessage(errorMessage.toString());
                errorList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList.stream().sorted(Comparator.comparing(ConSchemePlanImportVO::getRowIndex)).collect(Collectors.toList()));
        return CommonResponse.success((Object)json);
    }
}

