package com.ejianc.ztpc.enumUtils;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @ClassName ConOrgDesignStateEnum
 * @Description 施工组织设计的状态枚举
 * @Author WC
 * @Date 2023/7/21 14:50
 * @Version 1.0
 **/
public enum ConOrgDesignStateEnum {
    // 正在编制
    ONE("1", "正在编制"),
    // 已编制
    TWO("2", "已编制"),
    // 批准生效
    THREE("3", "批准生效");

    private final String code;
    private final String name;
    private static final Map<String, ConOrgDesignStateEnum> enumMap;
    private static final Map<String, ConOrgDesignStateEnum> enumNameMap;

    private ConOrgDesignStateEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static ConOrgDesignStateEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    public static ConOrgDesignStateEnum getEnumByName(String name) {
        return enumNameMap.get(name);
    }

    static {
        enumMap = EnumSet.allOf(ConOrgDesignStateEnum.class).stream().collect(Collectors.toMap(ConOrgDesignStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
        enumNameMap = EnumSet.allOf(ConOrgDesignStateEnum.class).stream().collect(Collectors.toMap(ConOrgDesignStateEnum::getName, Function.identity(), (k1, k2) -> k2));
    }
}
