package com.ejianc.ztpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.ConSchemePlanEntity;
import com.ejianc.ztpc.mapper.ConSchemePlanMapper;
import com.ejianc.ztpc.service.IConSchemePlanService;
import com.ejianc.ztpc.util.DetailIndexExcelReader;
import com.ejianc.ztpc.vo.ConSchemePlanImportVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 施工方案编制计划表
 *
 * @author generator
 */
@Service("conSchemePlanService")
public class ConSchemePlanServiceImpl extends BaseServiceImpl<ConSchemePlanMapper, ConSchemePlanEntity> implements IConSchemePlanService {
    /*
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ConSchemePlanMapper mapper;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<JSONObject> excelConSchemePlanImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<ConSchemePlanImportVO> successList = new ArrayList<>();
        List<ConSchemePlanImportVO> errorList = new ArrayList<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            } else {
                if (result != null && result.size() > 0) {
                    if (result.size() > 10000) {
                        return CommonResponse.error("卷册信息超过10000条，请分批上传！");
                    }
                    Map<String, Map<String, Object>> projDataMapAll = mapper.queryMapProjAll().stream().collect(
                            Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2)
                    );
                    Map<String, Map<String, Object>> projDataMap = mapper.queryMapProjLocal().stream().collect(
                            Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2)
                    );

                    for (int i = 0; i < result.size(); i++) {
                        boolean flag = true;
                        List<String> datas = result.get(i);
                        StringBuilder errorMessage = new StringBuilder("");
                        ConSchemePlanImportVO vo = new ConSchemePlanImportVO();
                        vo.setId(IdWorker.getId());

                        // 工程名称
                        String projectName = datas.get(0);
                        Map<String, Object> projectNameMap = projDataMap.get(projectName);
                        if (StringUtils.isBlank(projectName) || MapUtils.isEmpty(projectNameMap)) {
                            errorMessage.append("[工程名称]").append(projectName).append(":错误参照无法获取;");
                            flag = false;
                        } else {
                            vo.setProjectName((String) projectNameMap.get("name"));
                            vo.setProjectCode((String) projectNameMap.get("code"));
                            Object id = projectNameMap.get("id");
                            if (id instanceof String) {
                                vo.setProjectId(Long.parseLong((String) id));
                            } else {
                                vo.setProjectId((Long) id);
                            }
                            /*
                             * 项目信息自动带出的数据
                             */
                            // 工程类别
                            Object engineeringTypeId = projectNameMap.get("engineering_type_id");
                            if (engineeringTypeId instanceof String) {
                                vo.setEngineeringTypeId(Long.parseLong((String) engineeringTypeId));
                            } else {
                                vo.setEngineeringTypeId((Long) engineeringTypeId);
                            }
                            // 项目分级
                            Object projectLeave = projectNameMap.get("project_rank");
                            if (engineeringTypeId instanceof String) {
                                vo.setProjectLeave(Long.parseLong((String) projectLeave));
                            } else {
                                vo.setProjectLeave((Long) projectLeave);
                            }
                        }
                        // 施工方案名称
                        String consSchemeName = datas.get(1);
                        if (StringUtils.isBlank(consSchemeName)) {
                            errorMessage.append("[施工方案名称]为空;");
                            flag = false;
                        } else {
                            vo.setConsSchemeName(consSchemeName);
                        }
                        // 专业分类
                        String specialtyType = datas.get(2);
                        CommonResponse<List<DefdocDetailVO>> specialtyTypeDefdoc = iDefdocApi.getDefDocByDefCode("ct_specialty_type");
                        if (StringUtils.isBlank(specialtyType)) {
                            errorMessage.append("[专业分类]为空;");
                            flag = false;
                        } else if (!specialtyTypeDefdoc.isSuccess() || CollectionUtils.isEmpty(specialtyTypeDefdoc.getData())) {
                            errorMessage.append("[专业分类]").append(specialtyType).append(":错误参照无法获取;");
                            flag = false;
                        } else {
                            Long defdocDetailId = specialtyTypeDefdoc.getData().stream().filter(a -> specialtyType.equals(a.getName())).map(DefdocDetailVO::getId).findFirst().orElse(null);
                            vo.setSpecialtyType(defdocDetailId);
                        }
                        // 施工方案类别
                        String consSchemeType = datas.get(3);
                        CommonResponse<List<DefdocDetailVO>> consSchemeTypeDefdoc = iDefdocApi.getDefDocByDefCode("ct_cons_scheme_type");
                        if (StringUtils.isBlank(consSchemeType)) {
                            errorMessage.append("[施工方案类别]为空;");
                            flag = false;
                        } else if (!consSchemeTypeDefdoc.isSuccess() || CollectionUtils.isEmpty(consSchemeTypeDefdoc.getData())) {
                            errorMessage.append("[施工方案类别]").append(specialtyType).append(":错误参照无法获取;");
                            flag = false;
                        } else {
                            Long defdocDetailId = consSchemeTypeDefdoc.getData().stream().filter(a -> consSchemeType.equals(a.getName())).map(DefdocDetailVO::getId).findFirst().orElse(null);
                            vo.setConsSchemeType(defdocDetailId);
                        }
                        // 批准权限
                        String approvalPower = datas.get(4);
                        if (StringUtils.isBlank(approvalPower)) {
                            errorMessage.append("[批准权限]为空;");
                            flag = false;
                        } else {
                            vo.setApprovalPower(approvalPower);
                        }
                        // 计划编制时间
                        String planRedactDate = datas.get(5);
                        if (StringUtils.isBlank(planRedactDate)) {
                            errorMessage.append("[计划编制时间]为空;");
                            flag = false;
                        } else {
                            try {
                                vo.setPlanRedactDate(DateUtils.parseDate(planRedactDate, "yyyy-MM-dd"));
                            } catch (Exception e) {
                                errorMessage.append("[计划编制时间]日期格式错误;");
                                flag = false;
                                if (logger.isErrorEnabled()) {
                                    logger.error("施工方案编制计划清单 导入-校验数据 失败！计划编制时间的日期格式错误");
                                }
                            }
                        }
                        // 组织专家审查要求
                        String orgExpertExamine = datas.get(6);
                        if (StringUtils.isBlank(orgExpertExamine)) {
                            errorMessage.append("[组织专家审查要求]为空;");
                            flag = false;
                        } else {
                            vo.setOrgExpertExamine("是".equals(orgExpertExamine) ? "Y" : "否".equals(orgExpertExamine) ? "N" : "");
                        }
                        // 施工时段
                        String consTimeFrame = datas.get(7);
                        if (StringUtils.isBlank(consTimeFrame)) {
                            errorMessage.append("[施工时段]为空;");
                            flag = false;
                        } else {
                            try {
                                List<String> consTimeFrameList = Arrays.asList(consTimeFrame.split("~"));
                                DateUtils.parseDate(consTimeFrameList.get(0), "yyyy-MM-dd");
                                DateUtils.parseDate(consTimeFrameList.get(1), "yyyy-MM-dd");
                                vo.setConsTimeFrame(consTimeFrame);
                                vo.setConsTimeFrameList(consTimeFrameList);
                            } catch (Exception e) {
                                errorMessage.append("[施工时段]日期格式错误;");
                                flag = false;
                                if (logger.isErrorEnabled()) {
                                    logger.error("施工方案编制计划清单 导入-校验数据 失败！编制完成时间的日期格式错误");
                                }
                            }
                        }
                        // 完成施工方案时间
                        String finishConsSchemeDate = datas.get(8);
                        if (StringUtils.isBlank(finishConsSchemeDate)) {
                            errorMessage.append("[完成施工方案时间]为空;");
                            flag = false;
                        } else {
                            try {
                                vo.setFinishConsSchemeDate(DateUtils.parseDate(finishConsSchemeDate, "yyyy-MM-dd"));
                            } catch (Exception e) {
                                errorMessage.append("[完成施工方案时间]日期格式错误;");
                                flag = false;
                                if (logger.isErrorEnabled()) {
                                    logger.error("施工方案编制计划清单 导入-校验数据 失败！完成施工方案时间的日期格式错误");
                                }
                            }
                        }
                        // 分部分项工程特征
                        String projectTrait = datas.get(9);
                        CommonResponse<List<DefdocDetailVO>> projectTraitDefdoc = iDefdocApi.getDefDocByDefCode("ct_project_trait");
                        if (!"C".equals(consSchemeType) && StringUtils.isBlank(projectTrait)) {
                            errorMessage.append("[分部分项工程特征]为空;");
                            flag = false;
                        } else if (!projectTraitDefdoc.isSuccess() || CollectionUtils.isEmpty(projectTraitDefdoc.getData())) {
                            errorMessage.append("[分部分项工程特征]").append(specialtyType).append(":错误参照无法获取;");
                            flag = false;
                        } else {
                            Long defdocDetailId = projectTraitDefdoc.getData().stream().filter(a -> projectTrait.equals(a.getName())).map(DefdocDetailVO::getId).findFirst().orElse(null);
                            vo.setProjectTrait(defdocDetailId);
                        }
                        // 专项施工方案关注重点
                        String keyPointExplain = datas.get(10);
                        if (StringUtils.isBlank(keyPointExplain)) {
                            errorMessage.append("[专项施工方案关注重点]为空;");
                            flag = false;
                        } else {
                            vo.setKeyPointExplain(keyPointExplain);
                        }
                        // 编制部门
                        vo.setRedactDept(sessionManager.getUserContext().getDeptId());
                        vo.setRowIndex((i + 2));
                        Map<String, Object> stringStringMap = projDataMapAll.get(String.valueOf(vo.getProjectId()));
                        vo.setOrgId((Long) stringStringMap.get("orgId"));
                        vo.setOrgCode((String) stringStringMap.get("orgCode"));
                        vo.setOrgName((String) stringStringMap.get("orgName"));
                        vo.setParentOrgId((Long) stringStringMap.get("parentOrgId"));
                        vo.setParentOrgCode((String) stringStringMap.get("parentOrgCode"));
                        vo.setParentOrgName((String) stringStringMap.get("parentOrgName"));
                        if (flag) {
                            successList.add(vo);
                        } else {
                            vo.setErrorMessage(errorMessage.toString());
                            errorList.add(vo);
                        }
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList.stream().sorted(Comparator.comparing(ConSchemePlanImportVO::getRowIndex)).collect(Collectors.toList()));
        return CommonResponse.success(json);
    }
}
