/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.ztpc.bean.CheckDrawInfoEntity;
import com.ejianc.ztpc.bean.DrawingCheckEntity;
import com.ejianc.ztpc.mapper.DrawingCheckMapper;
import com.ejianc.ztpc.service.IDrawingCheckService;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="drawingCheck")
public class DrawingCheckBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IDrawingCheckService drawingCheckService;
    @Autowired
    private DrawingCheckMapper drawingCheckMapper;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        List<String> drawCodeList;
        DrawingCheckEntity entity;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("afterSubmitProcessor\uff0c\u5f00\u59cb\u56de\u5199\u72b6\u6001\uff0cbillId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        }
        if (Objects.nonNull((Object)(entity = (DrawingCheckEntity)((Object)this.drawingCheckService.selectById(billId)))) && CollectionUtils.isNotEmpty(entity.getCheckDrawInfoList()) && CollectionUtils.isNotEmpty(drawCodeList = this.drawingCheckMapper.selectDrawCode(entity.getCheckDrawInfoList().stream().map(CheckDrawInfoEntity::getDrawId).collect(Collectors.toList())))) {
            return CommonResponse.error((String)String.format("\u56fe\u7eb8\u4fe1\u606f\u5df2\u4f1a\u7b7e\uff0c\u4f1a\u68c0\u7684\u56fe\u7eb8[%s]", JSONObject.toJSONString(drawCodeList)));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("afterApprovalProcessor\uff0c\u5f00\u59cb\u56de\u5199\u72b6\u6001\uff0cbillId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        DrawingCheckEntity entity = (DrawingCheckEntity)((Object)this.drawingCheckService.selectById(billId));
        if (Objects.nonNull((Object)entity) && CollectionUtils.isNotEmpty(entity.getCheckDrawInfoList())) {
            this.drawingCheckMapper.updateDrawInfoCheckState(entity.getCheckDrawInfoList().stream().map(CheckDrawInfoEntity::getDrawId).collect(Collectors.toList()));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

