/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.ztpc.bean.ConSchemePlanEntity;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.bean.GreatDangerProjectEntity;
import com.ejianc.ztpc.enumUtils.ConOrgDesignStateEnum;
import com.ejianc.ztpc.enumUtils.SchemeStateEnum;
import com.ejianc.ztpc.service.IConSchemePlanService;
import com.ejianc.ztpc.service.IConstructionSchemeService;
import com.ejianc.ztpc.service.IGreatDangerProjectService;
import com.ejianc.ztpc.vo.ConstructionSchemeVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"constructionScheme"})
public class ConstructionSchemeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IConstructionSchemeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IConSchemePlanService conSchemePlanService;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private IGreatDangerProjectService greatDangerProjectService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConstructionSchemeVO> saveOrUpdate(@RequestBody ConstructionSchemeVO saveOrUpdateVO) {
        ConstructionSchemeVO vo;
        boolean sign;
        ConSchemePlanEntity conOrgDesignPlanEntity = (ConSchemePlanEntity)((Object)this.conSchemePlanService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(BaseEntity::getId, (Object)saveOrUpdateVO.getConsSchemeId())).eq(ConSchemePlanEntity::getExecuteState, (Object)ConOrgDesignStateEnum.THREE.getCode())).last("LIMIT 1")));
        if (Objects.nonNull((Object)conOrgDesignPlanEntity)) {
            return CommonResponse.error((String)"\u8be5\u65bd\u5de5\u65b9\u6848\u7f16\u5236\u8ba1\u5212\u5df2\u4f7f\u7528\uff01");
        }
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getConsTimeFrameList())) {
            saveOrUpdateVO.setConsTimeFrame(saveOrUpdateVO.getConsTimeFrameList().get(0) + "~" + saveOrUpdateVO.getConsTimeFrameList().get(1));
        }
        Date redactFinishDate = new Date();
        saveOrUpdateVO.setRedactFinishDate(redactFinishDate);
        ConstructionSchemeEntity entity = (ConstructionSchemeEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ConstructionSchemeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (sign = this.service.saveOrUpdate((Object)entity, false)) {
            this.conSchemePlanService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(ConSchemePlanEntity::getRedactFinishDate, (Object)redactFinishDate)).eq(BaseEntity::getDr, (Object)0)).eq(BaseEntity::getId, (Object)entity.getConsSchemeId()));
        }
        if (StringUtils.isNotBlank((CharSequence)(vo = (ConstructionSchemeVO)((Object)BeanMapper.map((Object)((Object)entity), ConstructionSchemeVO.class))).getConsTimeFrame())) {
            vo.setConsTimeFrameList(Arrays.asList(vo.getConsTimeFrame().split("~")));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConstructionSchemeVO> queryDetail(Long id) {
        ConstructionSchemeEntity entity = (ConstructionSchemeEntity)((Object)this.service.selectById(id));
        ConstructionSchemeVO vo = (ConstructionSchemeVO)((Object)BeanMapper.map((Object)((Object)entity), ConstructionSchemeVO.class));
        if (StringUtils.isNotBlank((CharSequence)vo.getConsTimeFrame())) {
            vo.setConsTimeFrameList(Arrays.asList(vo.getConsTimeFrame().split("~")));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConstructionSchemeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ConstructionSchemeVO constructionSchemeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ConstructionSchemeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConstructionSchemeVO.class));
        pageData.getRecords().forEach(a -> {
            block3: {
                try {
                    if (StringUtils.isNotBlank((CharSequence)a.getConsTimeFrame())) {
                        String startDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(DateUtils.parseDate((String)a.getConsTimeFrame().split("~")[0], (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"}));
                        String endDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(DateUtils.parseDate((String)a.getConsTimeFrame().split("~")[1], (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"}));
                        a.setConsTimeFrameList(Arrays.asList(a.getConsTimeFrame().split("~")));
                        a.setConsTimeFrame(startDate + "~" + endDate);
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("\u65bd\u5de5\u65b9\u6848\u7f16\u8f91\u8ba1\u5212\u6e05\u5355 \u8f6c\u6362\u65bd\u5de5\u65f6\u6bb5 \u5931\u8d25\uff01");
                }
            }
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ConstructionScheme-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refConstructionSchemeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ConstructionSchemeVO>> refConstructionSchemeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition) && Objects.nonNull((_con = JSONObject.parseObject((String)condition)).get((Object)"projectId"))) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        param.getParams().put("fileState", new Parameter("eq", (Object)"Y"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConstructionSchemeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/upgrade"})
    @ResponseBody
    public CommonResponse<Void> upgrade(@RequestBody ConstructionSchemeVO vo) {
        ConstructionSchemeEntity entity = (ConstructionSchemeEntity)((Object)BeanMapper.map((Object)((Object)vo), ConstructionSchemeEntity.class));
        entity.setId(null);
        entity.setCreateUserCode(null);
        entity.setCreateTime(null);
        entity.setFileState("N");
        entity.setExecuteState(null);
        entity.setExecuteStateName(null);
        entity.setBillState(null);
        entity.setRedactFinishDate(new Date());
        entity.setOpinionInfoList(null);
        boolean sign = this.service.saveOrUpdate((Object)entity, false);
        if (sign) {
            this.iAttachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(vo.getId()), "BT230801000000001", "textAttachment", String.valueOf(entity.getId()), "BT230801000000001", "textAttachment");
        }
        return CommonResponse.success();
    }

    @PostMapping(value={"/upExpertArgumentFile"})
    @ResponseBody
    public CommonResponse<Void> upExpertArgumentFile(@RequestBody ConstructionSchemeVO vo) {
        ConstructionSchemeEntity entity = (ConstructionSchemeEntity)((Object)this.service.selectById(vo.getId()));
        GreatDangerProjectEntity greatDangerProject = (GreatDangerProjectEntity)((Object)this.greatDangerProjectService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(GreatDangerProjectEntity::getConsSchemeId, (Object)vo.getId())).last("LIMIT 1")));
        greatDangerProject.setExpertAtteDate(new Date());
        greatDangerProject.setState(SchemeStateEnum.ONE.getCode());
        greatDangerProject.setStateName(SchemeStateEnum.ONE.getName());
        this.greatDangerProjectService.saveOrUpdate((Object)greatDangerProject, false);
        if (Objects.nonNull((Object)greatDangerProject)) {
            this.iAttachmentApi.deleteFileByParam(greatDangerProject.getId(), "BT230921000000001", "expertArgumentFile");
            this.iAttachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), "BT230801000000001", "expertArgumentFile", String.valueOf(greatDangerProject.getId()), "BT230921000000001", "expertArgumentFile");
        }
        return CommonResponse.success();
    }
}

