package com.ejianc.ztpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.DataDictionaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.mapper.ConSchemePlanMapper;
import com.ejianc.ztpc.service.IConstructionSchemeService;
import com.ejianc.ztpc.util.DetailIndexExcelReader;
import com.ejianc.ztpc.util.EJCDateUtil;
import com.ejianc.ztpc.util.ToolUtil;
import com.ejianc.ztpc.vo.ConSchemePlanImportVO;
import com.ejianc.ztpc.vo.ConstructionSchemeImportVO;
import com.ejianc.ztpc.vo.ProjectDisclosureImportVO;
import com.ejianc.ztpcdata.api.IExternalApi;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.ztpc.mapper.ProjectDisclosureMapper;
import com.ejianc.ztpc.bean.ProjectDisclosureEntity;
import com.ejianc.ztpc.service.IProjectDisclosureService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 项目交底表
 *
 * @author generator
 */
@Service("projectDisclosureService")
public class ProjectDisclosureServiceImpl extends BaseServiceImpl<ProjectDisclosureMapper, ProjectDisclosureEntity> implements IProjectDisclosureService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProjectDisclosureMapper mapper;
    @Autowired
    private ConSchemePlanMapper conSchemePlanMapper;
    @Autowired
    private IConstructionSchemeService constructionSchemeService;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExternalApi iExternalApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;

    @Override
    public CommonResponse<JSONObject> excelProjectDisclosureImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<ProjectDisclosureImportVO> successList = new ArrayList<>();
        List<ProjectDisclosureImportVO> errorList = new ArrayList<>();
        Map<String, String> dictionaryQueryMap = new HashMap<>();

        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            } else {
                if (result != null && result.size() > 0) {
                    if (result.size() > 10000) {
                        return CommonResponse.error("卷册信息超过10000条，请分批上传！");
                    }
                    Map<String, Map<String, Object>> projDataMapAll = conSchemePlanMapper.queryMapProjAll().stream().collect(
                            Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2)
                    );
                    List<Map<String, Object>> mapProjLocal = Lists.newArrayList();
                    CommonResponse<List<Map<String, Object>>> response = iExternalApi.getMapProjLocal();
                    if (response.isSuccess()) {
                        mapProjLocal = response.getData();
                    }
                    Map<String, Map<String, Object>> projDataMap = mapProjLocal.stream().collect(
                            Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2)
                    );

                    //部门
                    List<Map<String,Object>> deptList = Lists.newArrayList();
                    CommonResponse<List<Map<String, Object>>> allDeptCommonResponse = iExternalApi.queryAllDept();
                    if (allDeptCommonResponse.isSuccess() && ToolUtil.isNotEmpty(allDeptCommonResponse.getData())){
                        deptList =allDeptCommonResponse.getData();
                    }
                    Map<String, Map<String, Object>> testDept = deptList.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")),Function.identity(),(e1, e2)-> e2));

                    //人
                    List<Map<String, Object>> employeeList = Lists.newArrayList();
                    CommonResponse<List<Map<String, Object>>> employeeResponse = iExternalApi.getMapAllEmployee();
                    if (employeeResponse.isSuccess()&& ListUtil.isNotEmpty(employeeResponse.getData())) {
                        employeeList = employeeResponse.getData();
                    }
                    Map<String, Map<String,Object>> employee = employeeList.stream().collect(
                            Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                    );


                    //交底类型自定义档案
                    CommonResponse<List<DefdocDetailVO>> ctDisclosureType = iDefdocApi.getDefDocByDefCode("ct_disclosure_type");

                    for (int i = 0; i < result.size(); i++) {
                        boolean flag = true;
                        List<String> datas = result.get(i);
                        StringBuilder errorMessage = new StringBuilder("");
                        ProjectDisclosureImportVO vo = new ProjectDisclosureImportVO();
                        vo.setId(IdWorker.getId());

                        //编制人
                        vo.setRedactUser(InvocationInfoProxy.getUserid());
                        //编制时间
                        vo.setRedactDate(new Date());

                        // 工程名称
                        String projectName = datas.get(0);
                        Map<String, Object> projectNameMap = projDataMap.get(projectName);
                        if (StringUtils.isBlank(projectName) || MapUtils.isEmpty(projectNameMap)) {
                            errorMessage.append("[工程名称]").append(projectName).append(":错误参照无法获取;");
                            flag = false;
                        } else {
                            vo.setProjectName((String) projectNameMap.get("name"));
                            vo.setProjectCode((String) projectNameMap.get("code"));
                            Object id = projectNameMap.get("id");
                            if (id instanceof String) {
                                vo.setProjectId(Long.parseLong((String) id));
                            } else {
                                vo.setProjectId((Long) id);
                            }
                            /*
                             * 项目信息自动带出的数据
                             */
                            // 工程类别
                            Object engineeringTypeId = projectNameMap.get("engineering_type_id");
                            if (engineeringTypeId instanceof String) {
                                vo.setEngineeringTypeId(Long.parseLong((String) engineeringTypeId));
                            } else {
                                vo.setEngineeringTypeId((Long) engineeringTypeId);
                            }
                            // 项目分级
                            Object projectLeave = projectNameMap.get("project_rank");
                            if (projectLeave instanceof String) {
                                vo.setProjectLeave(Long.parseLong((String) projectLeave));
                            } else {
                                vo.setProjectLeave((Long) projectLeave);
                            }
                        }

                        //施工方案名称
                        String consSchemeIdName = datas.get(1);
                        ConstructionSchemeEntity constructionSchemeEntity = constructionSchemeService.getOne(
                                new QueryWrapper<ConstructionSchemeEntity>().lambda()
                                        .eq(ConstructionSchemeEntity::getProjectId, vo.getProjectId())
                                        .eq(ConstructionSchemeEntity::getDr, 0)
                                        .eq(ConstructionSchemeEntity::getConsSchemeName, consSchemeIdName)
                                        .last(" LIMIT 1 ")
                        );
                        if (ToolUtil.isEmpty(consSchemeIdName)) {
                            errorMessage.append("[施工方案名称]为空;");
                            flag = false;
                        } else {
                            if (constructionSchemeEntity == null) {
                                errorMessage.append("[施工方案名称]:").append(consSchemeIdName).append("参照获取失败;");
                                flag = false;
                            } else {
                                vo.setConsSchemeId(constructionSchemeEntity.getId());
                                vo.setConsSchemeCode(constructionSchemeEntity.getCode());
                                vo.setConsSchemeName(constructionSchemeEntity.getConsSchemeName());
                                vo.setConsSchemeFileVersion(constructionSchemeEntity.getFileVersion());
                            }
                        }

                        //交底名称
                        String disclosureName = datas.get(2);
                        if (ToolUtil.isEmpty(disclosureName)) {
                            errorMessage.append("[交底名称]为空;");
                            flag = false;
                        } else {
                            vo.setDisclosureName(disclosureName);
                        }

                        //内部编码
                        String internalCode = datas.get(3);
                        if (ToolUtil.isEmpty(internalCode)) {
                            errorMessage.append("[内部编码]为空;");
                            flag = false;
                        } else {
                            vo.setInternalCode(internalCode);
                        }

                        //外部编码
                        String outsideCode = datas.get(4);
                        if (ToolUtil.isNotEmpty(outsideCode)){
                            vo.setOutsideCode(outsideCode);
                        }

                        //交底类型
                        String disclosureTypeName = datas.get(5);
                        if (ToolUtil.isEmpty(disclosureTypeName)) {
                            errorMessage.append("[交底类型]为空;");
                            flag = false;
                        } else if (!ctDisclosureType.isSuccess() || CollectionUtils.isEmpty(ctDisclosureType.getData())) {
                            errorMessage.append("[交底类型]").append(disclosureTypeName).append(":错误参照无法获取;");
                            flag = false;
                        } else {
                            Long defdocDetailId = ctDisclosureType.getData().stream().filter(a -> disclosureTypeName.equals(a.getName())).map(DefdocDetailVO::getId).findFirst().orElse(null);
                            if (defdocDetailId == null){
                                errorMessage.append("[交底类型]:未找到对应参照;");
                                flag = false;
                            }else {
                                vo.setDisclosureType(defdocDetailId);
                            }
                        }
                        
                        //版本
                        String disclosureVersion = datas.get(6);
                        if (ToolUtil.isEmpty(disclosureVersion)){
                            errorMessage.append("[版本]为空;");
                            flag = false;
                        }else {
                            vo.setDisclosureVersion(disclosureVersion);
                        }

                        //专业
                        String specialtyName = datas.get(7);
                        if (ToolUtil.isNotEmpty(specialtyName)) {
                            dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                            dictionaryQueryMap.put("categoryCode", "specialty");
                            CommonResponse<List<DataDictionaryVO>> specialtyCommonResponse = billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                            if (specialtyCommonResponse.isSuccess()) {
                                List<DataDictionaryVO> data = specialtyCommonResponse.getData();
                                if (data != null) {
                                    DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> specialtyName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                    if (dataDictionaryVO == null) {
                                        errorMessage.append("[专业]").append(specialtyName).append(":错误参照无法获取;");
                                        flag = false;
                                    } else {
                                        vo.setSpecialty(dataDictionaryVO.getId());
                                    }
                                }
                            }
                        }

                        //机组
                        String mgrpName = datas.get(8);
                        if (ToolUtil.isNotEmpty(mgrpName)) {
                            dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                            dictionaryQueryMap.put("categoryCode", "mgrp");
                            CommonResponse<List<DataDictionaryVO>> mgrpCommonResponse = billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                            if (mgrpCommonResponse.isSuccess()) {
                                List<DataDictionaryVO> data = mgrpCommonResponse.getData();
                                if (data != null) {
                                    DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> mgrpName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                    if (dataDictionaryVO == null) {
                                        errorMessage.append("[机组]").append(mgrpName).append(":错误参照无法获取;");
                                        flag = false;
                                    } else {
                                        vo.setMgrp(dataDictionaryVO.getId());
                                    }
                                }
                            }
                        }

                        //被交底部门/班组
                        String byDisclosureDeptName = datas.get(9);
                        if (ToolUtil.isEmpty(byDisclosureDeptName)) {
//                            errorMessage.append("[被交底部门/班组]为空;");
//                            flag=false;
                        } else{
                            Map<String, Object> stringObjectMap = testDept.get(byDisclosureDeptName);
                            if (ToolUtil.isNotEmpty(stringObjectMap)){
                                vo.setByDisclosureDept((Long)stringObjectMap.get("id"));
                            }else {
                                errorMessage.append("[被交底部门/班组]" + byDisclosureDeptName + ":错误参照无法获取;");
                                flag = false;
                            }
                        }

                        //施工单位
                        String buildUnitName = datas.get(10);
                        if (ToolUtil.isNotEmpty(buildUnitName)){
                            CommonResponse<OrgVO> buildUnit = iOrgApi.findByNameAndTenantId(buildUnitName, InvocationInfoProxy.getTenantid());
                            if (buildUnit.isSuccess() && ToolUtil.isNotEmpty(buildUnit.getData())){
                                vo.setBuildUnit(buildUnit.getData().getId());
                            }else {
                                errorMessage.append("[施工单位]" + buildUnitName + ":错误参照无法获取;");
                                flag = false;
                            }
                        }

                        //施工负责人
                        String buildLeaderName = datas.get(11);
                        if (ToolUtil.isNotEmpty(buildLeaderName)){
                            Map<String, Object> stringObjectMap = employee.get(buildLeaderName);
                            if (stringObjectMap == null){
                                errorMessage.append("[施工负责人]" + buildLeaderName + ":错误参照无法获取;");
                                flag = false;
                            }else {
                                try {
                                    vo.setBuildLeader(Long.parseLong(stringObjectMap.get("id").toString()));
                                }catch (Exception e){
                                    logger.info(e.getMessage()+";"+stringObjectMap.toString()+";");
                                    errorMessage.append("[施工负责人]" + buildLeaderName + ":错误参照无法获取;");
                                    flag = false;
                                }
                            }
                        }

                        //审核人
                        String auditUserName = datas.get(12);
                        if (ToolUtil.isEmpty(auditUserName)){
                            errorMessage.append("[审核人]为空;");
                            flag = false;
                        }else {
                            Map<String, Object> stringObjectMap = employee.get(auditUserName);
                            if (stringObjectMap == null){
                                errorMessage.append("[审核人]" + auditUserName + ":错误参照无法获取;");
                                flag = false;
                            }else {
                                try {
                                    vo.setAuditUser(Long.parseLong(stringObjectMap.get("id").toString()));
                                }catch (Exception e){
                                    logger.info(e.getMessage()+";"+stringObjectMap.toString()+";");
                                    errorMessage.append("[审核人]" + auditUserName + ":错误参照无法获取;");
                                    flag = false;
                                }
                            }
                        }

                        //审核日期
                        String auditDateStr = datas.get(13);
                        if (ToolUtil.isNotEmpty(auditDateStr)) {
                            Date parse = EJCDateUtil.parseDate(auditDateStr, EJCDateUtil.DATE);
                            if (ToolUtil.isNotEmpty(parse)) {
                                vo.setAuditDate(parse);
                            } else {
                                errorMessage.append("[审核日期]" + auditDateStr + ":格式错误");
                                flag = false;
                            }
                        } else {
                            errorMessage.append("[审核日期]为空;");
                            flag = false;
                        }
                        
                        //交底人
                        String disclosureUserName = datas.get(14);
                        if (ToolUtil.isEmpty(disclosureUserName)){
//                            errorMessage.append("[交底人]为空;");
//                            flag = false;
                        }else {
                            Map<String, Object> stringObjectMap = employee.get(disclosureUserName);
                            if (stringObjectMap == null){
                                errorMessage.append("[交底人]" + disclosureUserName + ":错误参照无法获取;");
                                flag = false;
                            }else {
                                try {
                                    vo.setDisclosureUser(Long.parseLong(stringObjectMap.get("id").toString()));
                                }catch (Exception e){
                                    logger.info(e.getMessage()+";"+stringObjectMap.toString()+";");
                                    errorMessage.append("[交底人]" + disclosureUserName + ":错误参照无法获取;");
                                    flag = false;
                                }
                            }
                        }

                        //地点
                        String place = datas.get(15);
                        if (ToolUtil.isNotEmpty(place)){
                            vo.setPlace(place);
                        }

                        //交底时间
                        String disclosureDateStr = datas.get(16);
                        if (ToolUtil.isNotEmpty(disclosureDateStr)) {
                            Date parse = EJCDateUtil.parseDate(disclosureDateStr, EJCDateUtil.DATE);
                            if (ToolUtil.isNotEmpty(parse)) {
                                vo.setDisclosureDate(parse);
                            } else {
                                errorMessage.append("[交底时间]" + disclosureDateStr + ":格式错误");
                                flag = false;
                            }
                        } else {
//                            errorMessage.append("[交底时间]为空;");
//                            flag = false;
                        }

                        //备注
                        String remark = datas.get(17);
                        if (ToolUtil.isNotEmpty(remark)){
                            vo.setRemark(remark);
                        }


                        vo.setRowIndex((i + 2));
                        Map<String, Object> stringStringMap = projDataMapAll.get(String.valueOf(vo.getProjectId()));
                        CommonResponse<OrgVO> orgVO = iOrgApi.getOneById((Long) stringStringMap.get("orgId"));
                        if (!orgVO.isSuccess()) {
                            errorMessage.append("[项目无对应组织]");
                        }
                        vo.setOrgId((Long) stringStringMap.get("orgId"));
                        vo.setOrgCode(orgVO.getData().getCode());
                        vo.setOrgName(orgVO.getData().getName());
                        vo.setParentOrgId((Long) stringStringMap.get("parentOrgId"));
                        vo.setParentOrgCode((String) stringStringMap.get("parentOrgCode"));
                        vo.setParentOrgName((String) stringStringMap.get("parentOrgName"));
                        if (flag) {
                            successList.add(vo);
                        } else {
                            vo.setErrorMessage(errorMessage.toString());
                            errorList.add(vo);
                        }
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList.stream().sorted(Comparator.comparing(ProjectDisclosureImportVO::getRowIndex)).collect(Collectors.toList()));
        return CommonResponse.success(json);
    }
}
