/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.BillcodeRuleEntity;
import com.ejianc.ztpc.bean.BillcodeRuleSnEntity;
import com.ejianc.ztpc.service.IBillcodeRuleAttrService;
import com.ejianc.ztpc.service.IBillcodeRuleService;
import com.ejianc.ztpc.service.IBillcodeRuleSnService;
import com.ejianc.ztpc.vo.BillcodeRuleAttrVO;
import com.ejianc.ztpc.vo.BillcodeRuleVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"billcodeRule"})
public class BillcodeRuleController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BILLCODERULE";
    @Autowired
    private IBillcodeRuleService service;
    @Autowired
    private IBillcodeRuleSnService billcodeRuleSnService;
    @Autowired
    private IBillcodeRuleAttrService billcodeRuleAttrService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BillcodeRuleVO> saveOrUpdate(@RequestBody BillcodeRuleVO saveOrUpdateVO) {
        List billCodeRuleAttrList = saveOrUpdateVO.getBillcodeRuleAttrList().stream().filter(o -> !"del".equals(o.getRowState())).collect(Collectors.toList());
        Integer startNum = 0;
        if (billCodeRuleAttrList != null && billCodeRuleAttrList.size() > 0) {
            for (BillcodeRuleAttrVO billCodeRuleAttrVO : billCodeRuleAttrList) {
                if (!"rule06".equals(billCodeRuleAttrVO.getRuleElemCode())) continue;
                if (billCodeRuleAttrVO.getElemLength() == null) {
                    return CommonResponse.error((String)"\u5b50\u8868\u3010\u7f16\u7801\u89c4\u5219\u5b50\u5143\u7d20\u3011\u5e8f\u5217\u53f7\u5fc5\u987b\u8bbe\u7f6e\u5143\u7d20\u957f\u5ea6\uff01");
                }
                if (billCodeRuleAttrVO.getStartNum() == null) {
                    return CommonResponse.error((String)"\u5b50\u8868\u3010\u7f16\u7801\u89c4\u5219\u5b50\u5143\u7d20\u3011\u5e8f\u5217\u53f7\u5fc5\u987b\u8bbe\u7f6e\u6d41\u6c34\u8d77\u59cb\u53f7\uff01");
                }
                startNum = billCodeRuleAttrVO.getStartNum();
            }
        } else {
            return CommonResponse.error((String)"\u5b50\u8868\u3010\u7f16\u7801\u89c4\u5219\u5b50\u5143\u7d20\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BillcodeRuleEntity entity = (BillcodeRuleEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), BillcodeRuleEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setId(IdWorker.getId());
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        QueryWrapper SnQuery1 = new QueryWrapper();
        SnQuery1.eq((Object)"rule_id", (Object)entity.getId());
        SnQuery1.eq((Object)"is_init", (Object)"1");
        BillcodeRuleSnEntity snServiceOne = (BillcodeRuleSnEntity)((Object)this.billcodeRuleSnService.getOne((Wrapper)SnQuery1, false));
        if (snServiceOne != null) {
            return CommonResponse.error((String)"\u8be5\u53d6\u53f7\u89c4\u5219\u5df2\u88ab\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        BillcodeRuleVO vo = (BillcodeRuleVO)((Object)BeanMapper.map((Object)((Object)entity), BillcodeRuleVO.class));
        QueryWrapper SnQuery2 = new QueryWrapper();
        SnQuery2.eq((Object)"rule_id", (Object)entity.getId());
        SnQuery2.eq((Object)"is_init", (Object)"0");
        BillcodeRuleSnEntity snInitOne = (BillcodeRuleSnEntity)((Object)this.billcodeRuleSnService.getOne((Wrapper)SnQuery2, false));
        if (snInitOne == null) {
            snInitOne = new BillcodeRuleSnEntity();
            snInitOne.setRuleId(entity.getId());
            snInitOne.setIsInit("0");
            snInitOne.setStartSn(startNum);
        } else {
            snInitOne.setStartSn(startNum);
        }
        this.billcodeRuleSnService.saveOrUpdate((Object)snInitOne);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BillcodeRuleVO> queryDetail(Long id) {
        BillcodeRuleEntity entity = (BillcodeRuleEntity)((Object)this.service.selectById(id));
        BillcodeRuleVO vo = (BillcodeRuleVO)((Object)BeanMapper.map((Object)((Object)entity), BillcodeRuleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillcodeRuleVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BillcodeRuleVO billcodeRuleVO : vos) {
            }
        }
        List idList = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper SNQuery1 = new QueryWrapper();
        SNQuery1.eq((Object)"is_init", (Object)"1");
        SNQuery1.in((Object)"rule_id", idList);
        int count = this.billcodeRuleSnService.count((Wrapper)SNQuery1);
        if (count > 0) {
            return CommonResponse.error((String)"\u53d6\u53f7\u89c4\u5219\u5df2\u88ab\u5355\u636e\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        this.service.removeByIds(idList, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BillcodeRuleVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BillcodeRuleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BillcodeRule-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBillcodeRuleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BillcodeRuleVO>> refBillcodeRuleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BillcodeRuleVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

