/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.ProjectDisclosureEntity;
import com.ejianc.ztpc.service.IProjectDisclosureService;
import com.ejianc.ztpc.vo.ProjectDisclosureImportVO;
import com.ejianc.ztpc.vo.ProjectDisclosureVO;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectDisclosure"})
public class ProjectDisclosureController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZTPCCT_PROJECTDISCLOSURE";
    private static final String INTERNAL_CODE = "ZTPCCT_INTERNAL_CODE";
    @Autowired
    private IProjectDisclosureService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectDisclosureVO> saveOrUpdate(@RequestBody ProjectDisclosureVO saveOrUpdateVO) {
        ProjectDisclosureEntity entity = (ProjectDisclosureEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ProjectDisclosureEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            BillCodeParam internalCodeParam = BillCodeParam.build((String)INTERNAL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse internalCode = this.billCodeApi.generateBillCode(internalCodeParam);
            if (internalCode.isSuccess()) {
                entity.setInternalCode((String)internalCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        QueryParam param = new QueryParam();
        param.getParams().put("dr", new Parameter("eq", (Object)"0"));
        param.getParams().put("consSchemeId", new Parameter("eq", (Object)entity.getConsSchemeId()));
        param.getParams().put("id", new Parameter("ne", (Object)entity.getId()));
        List oldEntityList = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)oldEntityList) && oldEntityList.size() != 0) {
            return CommonResponse.error((String)"\u8be5\u65bd\u5de5\u65b9\u6848\u5df2\u4ea4\u5e95\uff01");
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectDisclosureVO vo = (ProjectDisclosureVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectDisclosureVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectDisclosureVO> queryDetail(Long id) {
        ProjectDisclosureEntity entity = (ProjectDisclosureEntity)((Object)this.service.selectById(id));
        ProjectDisclosureVO vo = (ProjectDisclosureVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectDisclosureVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectDisclosureVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectDisclosureVO projectDisclosureVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectDisclosureVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("consSchemeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parent_org_id", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectDisclosureVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectDisclosure-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectDisclosureData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectDisclosureVO>> refProjectDisclosureData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectDisclosureVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/downloadProjectDisclosureTemplate"})
    @ResponseBody
    public void downloadConSchemePlanTemplate(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"project-disclosure-import.xlsx", (String)"\u9879\u76ee\u4ea4\u5e95\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelProjectDisclosureImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelProjectDisclosureImport(HttpServletRequest request) {
        return this.service.excelProjectDisclosureImport(request);
    }

    @RequestMapping(value={"/saveImportExcelProjectDisclosure"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Void> saveImportExcelProjectDisclosure(@RequestBody List<ProjectDisclosureImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList list = Lists.newArrayList();
        importVos.forEach(importVO -> {
            ProjectDisclosureEntity entity = (ProjectDisclosureEntity)((Object)((Object)BeanMapper.map((Object)importVO, ProjectDisclosureEntity.class)));
            entity.setId(IdWorker.getId());
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)importVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setCode((String)billCode.getData());
            list.add(entity);
        });
        this.service.saveBatch(list, list.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

