package com.ejianc.ztpc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ztpc.billcode.bean.BillCodeApiVO;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleSNVO;
import com.ejianc.business.ztpc.billcode.bean.RuleTypeEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.*;
import com.ejianc.ztpc.enumUtils.ConOrgDesignStateEnum;
import com.ejianc.ztpc.enumUtils.SchemeStateEnum;
import com.ejianc.ztpc.mapper.OpinionInfoMapper;
import com.ejianc.ztpc.service.*;
import com.ejianc.ztpc.vo.*;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 施工方案表
 *
 * @author generator
 */
@Controller
@RequestMapping("constructionScheme")
public class ConstructionSchemeController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IConstructionSchemeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IConSchemePlanService conSchemePlanService;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private IGreatDangerProjectService greatDangerProjectService;
    @Autowired
    private OpinionInfoMapper opinionInfoMapper;
    @Autowired
    private IBillcodeCategoryService billcodeCategoryService;
    @Autowired
    private IBillcodeRuleSnService billcodeRuleSnService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConstructionSchemeVO> saveOrUpdate(@RequestBody ConstructionSchemeVO saveOrUpdateVO) {
        /*
         * 判断该施工方案编制计划是否使用
         */
        ConSchemePlanEntity conOrgDesignPlanEntity = conSchemePlanService.getOne(
                new QueryWrapper<ConSchemePlanEntity>()
                        .lambda()
                        .eq(ConSchemePlanEntity::getDr, 0)
                        .eq(ConSchemePlanEntity::getId, saveOrUpdateVO.getConsSchemeId())
                        .eq(ConSchemePlanEntity::getExecuteState, ConOrgDesignStateEnum.THREE.getCode())
                        .last("LIMIT 1")
        );
        if (Objects.nonNull(conOrgDesignPlanEntity)) {
            return CommonResponse.error("该施工方案编制计划已使用！");
        }
        // 施工时段
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getConsTimeFrameList())) {
            saveOrUpdateVO.setConsTimeFrame(saveOrUpdateVO.getConsTimeFrameList().get(0) + "~" + saveOrUpdateVO.getConsTimeFrameList().get(1));
        }
        /*
         * 编制完成时间
         */
        Date redactFinishDate = new Date();
        saveOrUpdateVO.setRedactFinishDate(redactFinishDate);
        ConstructionSchemeEntity entity = BeanMapper.map(saveOrUpdateVO, ConstructionSchemeEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        boolean sign = false;

        //取出意见栏手动判断新增修改
        List<OpinionInfoEntity> opinionInfoList = entity.getOpinionInfoList();
        entity.setOpinionInfoList(null);
        //是否修改主表 没有修改主表则不对表进行操作
        if (saveOrUpdateVO.isWhetherUpdate()){
            if (entity.getId() != null && entity.getId() != 0){
                sign = service.updateById(entity);
            }else {
                BillcodeApiVO billcodeApi = getBillcodeApi(saveOrUpdateVO);
                CommonResponse<BillcodeApiVO> billcodeApiVOCommonResponse = null;
                if (billcodeApi != null){
                    try {
                        billcodeApiVOCommonResponse = billcodeRuleSnService.generateBillcode(billcodeApi);
                        if (billcodeApiVOCommonResponse.isSuccess()){
                            List<BillcodeRuleSnVO> snList = billcodeApiVOCommonResponse.getData().getSnList();
                            for (BillcodeRuleSnVO codeSnVO : snList) {
                                entity.setOutsideCode(codeSnVO.getGenerateBillCode());
                            }
                        }
                    }catch (Exception e){
                        logger.info(e.getMessage());
                    }
                }
                if (billcodeApiVOCommonResponse != null && (billcodeApiVOCommonResponse.getCode() == 999  || billcodeApiVOCommonResponse.isSuccess())) {
                    sign = service.save(entity);
                    if (sign && billcodeApiVOCommonResponse.isSuccess()) {
                        //业务单据保持成功后，提交取号
                        BillcodeApiVO responseData = billcodeApiVOCommonResponse.getData();
                        billcodeRuleSnService.commitBillcode(responseData);
                    }
                }else {
                    if (billcodeApiVOCommonResponse == null) {
                        return CommonResponse.error("取号失败");
                    }else {
                        return CommonResponse.error("取号失败:"+billcodeApiVOCommonResponse.getMsg());
                    }
                }
            }
        }
        //只允许新增或修改当前用户自己提出的意见
        Long userid = InvocationInfoProxy.getUserid();
        for (OpinionInfoEntity opinionInfo : opinionInfoList) {
            Long proposeUserId = opinionInfo.getProposeUserId();
            opinionInfo.setPid(entity.getId());
            if (userid != null && userid.equals(proposeUserId)){
                if (opinionInfo.getId() != null && opinionInfo.getId() != 0){
                    if(opinionInfo.getDr() != null && opinionInfo.getDr() == 1) {
                        opinionInfoMapper.deleteById(opinionInfo.getId());
                    }else {
                        opinionInfoMapper.updateById(opinionInfo);
                    }
                }else {
                    opinionInfoMapper.insert(opinionInfo);
                }
            }
        }

        List<OpinionInfoEntity> collect = opinionInfoList.stream().filter(item -> item.getDr() == 0L).collect(Collectors.toList());
        collect.stream().map(a->{
            a.setRowState(null);
            return a;
        }).collect(Collectors.toList());
        opinionInfoList = collect;

        if (sign) {
            conSchemePlanService.update(
                    new UpdateWrapper<ConSchemePlanEntity>()
                            .lambda()
                            .set(ConSchemePlanEntity::getRedactFinishDate, redactFinishDate)
                            .eq(ConSchemePlanEntity::getDr, 0)
                            .eq(ConSchemePlanEntity::getId, entity.getConsSchemeId())
            );
        }
        if (opinionInfoList.size() == 0){
            service.update(new UpdateWrapper<ConstructionSchemeEntity>()
                    .lambda()
                    .set(ConstructionSchemeEntity::getOpinionFlag,0)
                    .eq(ConstructionSchemeEntity::getId,entity.getId())
            );
        }else {
            service.update(new UpdateWrapper<ConstructionSchemeEntity>()
                    .lambda()
                    .set(ConstructionSchemeEntity::getOpinionFlag,1)
                    .eq(ConstructionSchemeEntity::getId,entity.getId())
            );
        }
        //复原回显
        entity.setOpinionInfoList(opinionInfoList);
        ConstructionSchemeVO vo = BeanMapper.map(entity, ConstructionSchemeVO.class);
        // 施工时段
        if (StringUtils.isNotBlank(vo.getConsTimeFrame())) {
            vo.setConsTimeFrameList(Arrays.asList(vo.getConsTimeFrame().split("~")));
        }
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    public BillcodeApiVO getBillcodeApi(ConstructionSchemeVO vo){
        BillcodeApiVO billcodeApiVO = new BillcodeApiVO();
        billcodeApiVO.setProjectId(vo.getProjectId());
        billcodeApiVO.setProjectCode(vo.getProjectCode());
        billcodeApiVO.setProjectName(vo.getProjectName());
        BillcodeCategoryEntity ctConstructionScheme = billcodeCategoryService.getOne(
                new QueryWrapper<BillcodeCategoryEntity>().lambda()
                        .eq(BillcodeCategoryEntity::getDr, 0)
                        .eq(BillcodeCategoryEntity::getEnableStatus, 1)
                        .eq(BillcodeCategoryEntity::getCode, "ct_construction_scheme")
        );
        if (ctConstructionScheme == null){
            return null;
        }
        billcodeApiVO.setCategoryId(ctConstructionScheme.getId());

        List<BillcodeRuleSnVO> snVOList  = new ArrayList<>();
        billcodeApiVO.setSnList(snVOList);
        BillcodeRuleSnVO billcodeRuleSnVO = new BillcodeRuleSnVO();
        snVOList.add(billcodeRuleSnVO);
        billcodeRuleSnVO.setSourcePid(vo.getId());
        billcodeRuleSnVO.setSourceCode(vo.getCode());
        billcodeRuleSnVO.setSourceType("BT230801000000001");
        billcodeRuleSnVO.setSourceTypeName("施工方案");
        try {
            if (vo.getMgrp() != null){
                JSONArray mgrpReferValue = ReferObjectUtil.getReferEntityValue(vo.getMgrp() + "", "data-dictionary");
                JSONObject mgrpRef = (JSONObject) mgrpReferValue.get(0);
                billcodeRuleSnVO.setRule01(mgrpRef.getString("code"));//机组
            }
            if (vo.getLocationCode() != null) {
                JSONArray locationReferValue = ReferObjectUtil.getReferEntityValue(vo.getLocationCode() + "", "data-dictionary-category");
                JSONObject locationRef = (JSONObject) locationReferValue.get(0);
                billcodeRuleSnVO.setRule02(locationRef.getString("code"));//区域定位码
            }
        }catch (Exception e){
            logger.info(e.getMessage());
            throw new BusinessException("referCode转换错误");
        }
        return billcodeApiVO;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConstructionSchemeVO> queryDetail(Long id) {
        ConstructionSchemeEntity entity = service.selectById(id);
        ConstructionSchemeVO vo = BeanMapper.map(entity, ConstructionSchemeVO.class);
        // 施工时段
        if (StringUtils.isNotBlank(vo.getConsTimeFrame())) {
            vo.setConsTimeFrameList(Arrays.asList(vo.getConsTimeFrame().split("~")));
        }
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConstructionSchemeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ConstructionSchemeVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ConstructionSchemeVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConstructionSchemeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("consSchemeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        Parameter orgId = param.getParams().get("orgId");
        long parentOrgId = 0;
        if (orgId != null){
            parentOrgId = Long.parseLong(orgId.getValue().toString());
            param.getParams().remove("orgId");
        }else {
            parentOrgId = InvocationInfoProxy.getOrgId();
        }
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(parentOrgId), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<ConstructionSchemeEntity> page = service.queryPage(param, false);
        IPage<ConstructionSchemeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConstructionSchemeVO.class));
        pageData.getRecords().forEach(a -> {
            try {
                // 施工时段
                if (StringUtils.isNotBlank(a.getConsTimeFrame())) {
                    String startDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(
                            DateUtils.parseDate(a.getConsTimeFrame().split("~")[0], "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
                    );
                    String endDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(
                            DateUtils.parseDate(a.getConsTimeFrame().split("~")[1], "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
                    );
                    a.setConsTimeFrameList(Arrays.asList(a.getConsTimeFrame().split("~")));
                    a.setConsTimeFrame(startDate + "~" + endDate);
                }
            } catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("施工方案编辑计划清单 转换施工时段 失败！");
                }
            }
        });
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ConstructionSchemeEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ConstructionScheme-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refConstructionSchemeData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConstructionSchemeVO>> refConstructionSchemeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                 String condition,
                                                                                 String searchObject,
                                                                                 String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (Objects.nonNull(_con.get("projectId"))) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
        }
        // 文件状态“Y”
        param.getParams().put("fileState", new Parameter(QueryParam.EQ, "Y"));

        IPage<ConstructionSchemeEntity> page = service.queryPage(param, false);
        IPage<ConstructionSchemeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConstructionSchemeVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 升版
     *
     * @param vo 待升版的数据
     * @return 返回结果
     */
    @PostMapping("/upgrade")
    @ResponseBody
    public CommonResponse<Void> upgrade(@RequestBody ConstructionSchemeVO vo) {
        ConstructionSchemeEntity entity = BeanMapper.map(vo, ConstructionSchemeEntity.class);
        entity.setId(null);
        entity.setCreateUserCode(null);
        entity.setCreateTime(null);
        entity.setFileState("N");
        entity.setExecuteState(null);
        entity.setExecuteStateName(null);
        entity.setBillState(null);
        entity.setRedactFinishDate(new Date());
        entity.setOpinionInfoList(null);
        boolean sign = service.saveOrUpdate(entity, false);
        conSchemePlanService.update(
                new UpdateWrapper<ConSchemePlanEntity>()
                        .lambda()
                        .set(ConSchemePlanEntity::getExecuteState, ConOrgDesignStateEnum.ONE.getCode())
                        .set(ConSchemePlanEntity::getExecuteStateName, ConOrgDesignStateEnum.ONE.getName())
                        .eq(ConSchemePlanEntity::getDr, 0)
                        .eq(ConSchemePlanEntity::getId, entity.getConsSchemeId())
        );
        if (sign) {
            /*
             * 复制升版前的施工方案中的“正文附件”到升版后的施工方案中的“正文附件”中
             */
            iAttachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(vo.getId()), "BT230801000000001", "textAttachment",
                    String.valueOf(entity.getId()), "BT230801000000001", "textAttachment");
        }
        return CommonResponse.success();
    }

    /**
     * 上传专家附件
     *
     * @param vo 待上传的数据
     * @return 返回结果
     */
    @PostMapping("/upExpertArgumentFile")
    @ResponseBody
    public CommonResponse<Void> upExpertArgumentFile(@RequestBody ConstructionSchemeVO vo) {
        ConstructionSchemeEntity entity = service.selectById(vo.getId());
        GreatDangerProjectEntity greatDangerProject = greatDangerProjectService.getOne(
                new QueryWrapper<GreatDangerProjectEntity>()
                        .lambda()
                        .eq(GreatDangerProjectEntity::getDr, 0)
                        .eq(GreatDangerProjectEntity::getConsSchemeId, vo.getId())
                        .last("LIMIT 1")
        );
        greatDangerProject.setExpertAtteDate(new Date());
        // 修改状态为"待实施"
        greatDangerProject.setState(SchemeStateEnum.ONE.getCode());
        greatDangerProject.setStateName(SchemeStateEnum.ONE.getName());
        // 更新
        greatDangerProjectService.saveOrUpdate(greatDangerProject, false);
        if (Objects.nonNull(greatDangerProject)) {
            // 删除危大工程的“专项方案专家论证报告附件”
            iAttachmentApi.deleteFileByParam(greatDangerProject.getId(), "BT230921000000001", "expertArgumentFile");
            /*
             * 复制施工方案中的“专项方案专家论证报告附件”到危大工程的“专项方案专家论证报告附件”中
             */
            iAttachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), "BT230801000000001", "expertArgumentFile",
                    String.valueOf(greatDangerProject.getId()), "BT230921000000001", "expertArgumentFile");
        }
        return CommonResponse.success();
    }

    /**
     * 卷册信息导入模板下载
     *
     * @param request  请求头对象
     * @param response 返回体对象
     */
    @RequestMapping(value = "/downloadConstructionSchemeTemplate")
    @ResponseBody
    public void downloadConstructionSchemeTemplate(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "construction-scheme-import.xlsx", "施工方案导入模板");
    }

    /**
     * 导入-校验数据
     *
     * @param request 请求头对象
     * @return 返回对象
     */
    @RequestMapping(value = "/excelConstructionSchemeImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelConstructionSchemeImport(HttpServletRequest request) {
        return service.excelConstructionSchemeImport(request);
    }

    /**
     * 导入-保存
     *
     * @param importVos 待保存的数据
     * @return
     */
    @RequestMapping(value = "/saveImportExcelConstructionScheme", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Void> saveImportExcelConstructionScheme(@RequestBody List<ConstructionSchemeImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<ConstructionSchemeEntity> list = Lists.newArrayList();

        importVos.forEach(importVO -> {
            /*
             * 施工时段 补充日期格式
             */
            String startDate = importVO.getConsTimeFrameList().get(0) + "T16:00:00.000Z";
            String endDate = importVO.getConsTimeFrameList().get(1) + "T16:00:00.000Z";
            importVO.setConsTimeFrame(startDate + "~" + endDate);
            ConstructionSchemeEntity entity = BeanMapper.map(importVO, ConstructionSchemeEntity.class);
            entity.setId(IdWorker.getId());

            list.add(entity);
        });
        // 保存
        service.saveBatch(list, list.size());
        return CommonResponse.success("保存成功！");
    }
}
