package com.ejianc.ztpc.service.impl;

import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.ztpc.mapper.OpinionInfoMapper;
import com.ejianc.ztpc.bean.OpinionInfoEntity;
import com.ejianc.ztpc.service.IOpinionInfoService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 意见栏
 * 
 * @author generator
 * 
 */
@Service("opinionInfoService")
public class OpinionInfoServiceImpl extends BaseServiceImpl<OpinionInfoMapper, OpinionInfoEntity> implements IOpinionInfoService{

    @Override
    public Map<String, Object> toWordMap(ConstructionSchemeEntity entity, List<Long> ids) {
        Map<String, Object> map = new HashMap<>();
        map.put("projectName", entity.getProjectName());
        map.put("consSchemeName", entity.getConsSchemeName());
        List<Map<String,Object>> listSubs=new ArrayList<>();
        if(entity.getOpinionInfoList()!=null){
            if(entity.getOpinionInfoList().size()!=0) {
                for (int i = 0; i < entity.getOpinionInfoList().size(); i++) {
                    if (ids.contains(entity.getOpinionInfoList().get(i).getId())) {
                        Map<String, Object> map1 = new HashMap();
                        OpinionInfoEntity info = entity.getOpinionInfoList().get(i);
                        map1.put("relativeChapter", info.getRelativeChapter());
                        map1.put("originalContent", info.getOriginalContent());
                        map1.put("editOpinion", info.getEditOpinion());
                        map1.put("reminderContentId", info.getReminderContentId()==null?null:info.getReminderContentId()==1?"必改项":"建议项");
                        map1.put("whetherAccept", info.getWhetherAccept() != null ? "是" : "否");
                        map1.put("proposeUserName", info.getProposeUserName());
                        map1.put("certificationConclusionId", info.getCertificationConclusionId());
                        map1.put("index", i + 1);
                        listSubs.add(map1);
                    }
                }
            }
        }
        map.put("list",listSubs);

        for (String s : map.keySet()) {
            map.putIfAbsent(s, "");
        }

        return map;
    }
}
