package com.ejianc.ztpc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.bean.GreatDangerProjectEntity;
import com.ejianc.ztpc.bean.ProjectDisclosureEntity;
import com.ejianc.ztpc.enumUtils.SchemeStateEnum;
import com.ejianc.ztpc.service.IConstructionSchemeService;
import com.ejianc.ztpc.service.IGreatDangerProjectService;
import com.ejianc.ztpc.service.IProjectDisclosureService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Objects;

@Service("projectDisclosure") 
public class ProjectDisclosureBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IProjectDisclosureService projectDisclosureService;
	@Autowired
	private IGreatDangerProjectService greatDangerProjectService;
	@Autowired
	private IConstructionSchemeService constructionSchemeService;

	@Autowired
	private IAttachmentApi iAttachmentApi;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		if (logger.isInfoEnabled()) {
			logger.info("afterSubmitProcessor，开始回写状态，billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
		}
		ProjectDisclosureEntity entity = projectDisclosureService.selectById(billId);
		//查询施工方案信息
		ConstructionSchemeEntity constructionScheme = constructionSchemeService.getOne(
				new QueryWrapper<ConstructionSchemeEntity>()
						.lambda()
						.eq(ConstructionSchemeEntity::getDr, 0)
						.eq(ConstructionSchemeEntity::getId, entity.getConsSchemeId())
						.last("LIMIT 1")
		);
		if (constructionScheme != null && constructionScheme.getConsSchemeType() == 1703677772116791297L){
			return CommonResponse.success();
		}
		// 查询危大工程信息
		GreatDangerProjectEntity greatDangerProject = greatDangerProjectService.getOne(
				new QueryWrapper<GreatDangerProjectEntity>()
						.lambda()
						.eq(GreatDangerProjectEntity::getDr, 0)
						.eq(GreatDangerProjectEntity::getConsSchemeId, entity.getConsSchemeId())
						.last("LIMIT 1")
		);
		if (Objects.isNull(greatDangerProject) || !SchemeStateEnum.ONE.getCode().equals(greatDangerProject.getState())) {
			return CommonResponse.error("提交失败,施工方案未上传专家附件!");
		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("afterApprovalProcessor，开始回写状态，billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		ProjectDisclosureEntity entity = projectDisclosureService.selectById(billId);
		// 查询危大工程信息
		GreatDangerProjectEntity greatDangerProject = greatDangerProjectService.getOne(
				new QueryWrapper<GreatDangerProjectEntity>()
						.lambda()
						.eq(GreatDangerProjectEntity::getDr, 0)
						.eq(GreatDangerProjectEntity::getConsSchemeId, entity.getConsSchemeId())
						.last("LIMIT 1")
		);
		greatDangerProject.setDisclosureDate(entity.getDisclosureDate());
		// 修改状态为"实施中"
		greatDangerProject.setState(SchemeStateEnum.TWO.getCode());
		greatDangerProject.setStateName(SchemeStateEnum.TWO.getName());
		// 更新
		greatDangerProjectService.saveOrUpdate(greatDangerProject, false);
		/*
		 * 复制项目交底中的“交底记录附件”到危大工程的“项目交底附件”中
		 */
		iAttachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), "BT230725000000005", "disclosureRecordFile",
				String.valueOf(greatDangerProject.getId()), "BT230921000000001", "projectDisclosureFile");
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
