/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.ztpc.bean.BillcodeRuleAttrEntity;
import com.ejianc.ztpc.bean.BillcodeRuleEntity;
import com.ejianc.ztpc.bean.BillcodeRuleSnEntity;
import com.ejianc.ztpc.mapper.BillcodeRuleSnMapper;
import com.ejianc.ztpc.service.IBillcodeRuleAttrService;
import com.ejianc.ztpc.service.IBillcodeRuleService;
import com.ejianc.ztpc.service.IBillcodeRuleSnService;
import com.ejianc.ztpc.util.ToolUtil;
import com.ejianc.ztpc.vo.BillcodeApiVO;
import com.ejianc.ztpc.vo.BillcodeRuleSnVO;
import com.ejianc.ztpc.vo.BillcodeRuleVO;
import com.ejianc.ztpc.vo.enumvo.RuleElemType;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="billcodeRuleSnService")
public class BillcodeRuleSnServiceImpl
extends BaseServiceImpl<BillcodeRuleSnMapper, BillcodeRuleSnEntity>
implements IBillcodeRuleSnService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillcodeRuleService ruleService;
    @Autowired
    private IBillcodeRuleAttrService attrService;
    @Autowired
    private IDefdocApi iDefdocApi;

    @Override
    public CommonResponse<BillcodeApiVO> generateBillcode(BillcodeApiVO apiVO) throws IntrospectionException {
        String stringInfo = JSONObject.toJSONString((Object)apiVO);
        this.logger.info("\u53d6\u53f7\u53c2\u6570---->" + stringInfo);
        QueryWrapper ruleQuery = new QueryWrapper();
        ruleQuery.eq((Object)"project_id", (Object)apiVO.getProjectId());
        ruleQuery.eq((Object)"category_id", (Object)apiVO.getCategoryId());
        BillcodeRuleEntity billCodeRuleEntity = (BillcodeRuleEntity)((Object)this.ruleService.getOne((Wrapper)ruleQuery, false));
        if (billCodeRuleEntity == null) {
            return CommonResponse.error((int)999, (String)"\u672a\u5339\u914d\u5230\u53d6\u53f7\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5!");
        }
        List<BillcodeRuleSnVO> snList = apiVO.getSnList();
        if (snList == null || snList.size() == 0) {
            return CommonResponse.error((String)"snList\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
        }
        ArrayList<BillcodeRuleSnVO> snRetList = new ArrayList<BillcodeRuleSnVO>();
        for (BillcodeRuleSnVO snVO : snList) {
            BillcodeRuleSnVO retSnVO = new BillcodeRuleSnVO();
            QueryWrapper snDuplicateWrapper = new QueryWrapper();
            snDuplicateWrapper.eq((Object)"rule_id", (Object)billCodeRuleEntity.getId());
            snDuplicateWrapper.eq((Object)"source_pid", (Object)snVO.getSourcePid());
            this.buildDuplicateWrapper((QueryWrapper<BillcodeRuleSnEntity>)snDuplicateWrapper, snVO);
            BillcodeRuleSnEntity snDuplicateEntity = (BillcodeRuleSnEntity)((Object)this.getOne((Wrapper)snDuplicateWrapper, false));
            if (snDuplicateEntity != null) {
                this.logger.info(snVO.getSourceCode() + "----" + snDuplicateEntity.getGenerateBillCode() + "\u5df2\u5b58\u5728\uff0c\u65e0\u9700\u91cd\u590d\u53d6\u53f7---->");
                retSnVO = (BillcodeRuleSnVO)((Object)BeanMapper.map((Object)((Object)snDuplicateEntity), BillcodeRuleSnVO.class));
                snRetList.add(retSnVO);
                continue;
            }
            QueryParam attQuery = new QueryParam();
            attQuery.getParams().put("rule_id", new Parameter("eq", (Object)billCodeRuleEntity.getId()));
            LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
            orderMap.put("id", "asc");
            attQuery.setOrderMap(orderMap);
            List ruleAttrEntities = this.attrService.queryList(attQuery, false);
            String separator = billCodeRuleEntity.getSeparatorStr() == null ? "" : billCodeRuleEntity.getSeparatorStr();
            StringBuffer sb = new StringBuffer();
            for (BillcodeRuleAttrEntity attrEntity : ruleAttrEntities) {
                if (RuleElemType.\u5e38\u91cf.getCode().equals(attrEntity.getRuleElemType())) {
                    sb.append(attrEntity.getElemValue()).append(separator);
                    continue;
                }
                if (RuleElemType.\u81ea\u5b9a\u4e49\u6d41\u6c34\u4f9d\u636e.getCode().equals(attrEntity.getRuleElemType())) {
                    String ruleElemCode = attrEntity.getRuleElemCode();
                    try {
                        CommonResponse billRuleDefdoc;
                        Object fieldValue = BillcodeRuleSnServiceImpl.getFieldValue(snVO, ruleElemCode);
                        if (fieldValue == null && (billRuleDefdoc = this.iDefdocApi.getDefDocByDefCode("ct_bill_rule")).isSuccess() && CollectionUtil.isNotEmpty((Collection)((Collection)billRuleDefdoc.getData()))) {
                            String defdocName = ((List)billRuleDefdoc.getData()).stream().filter(a -> attrEntity.getRuleElem().equals(a.getId())).map(DefdocDetailVO::getName).findFirst().orElse(null);
                            if (StringUtils.isNotEmpty((String)defdocName)) {
                                return CommonResponse.error((String)("\u5b57\u6bb5\u3010" + defdocName + "\u3011\u4e3a\u7a7a"));
                            }
                            return CommonResponse.error((String)("\u5b57\u6bb5\u3010" + attrEntity.getRuleElemCode() + "\u3011\u672a\u627e\u5230"));
                        }
                        sb.append(fieldValue.toString()).append(separator);
                        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(ruleElemCode, ((Object)((Object)retSnVO)).getClass());
                        Method method = propertyDescriptor.getWriteMethod();
                        method.invoke((Object)retSnVO, fieldValue.toString());
                        continue;
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                        return CommonResponse.error((String)("\u5b57\u6bb5\u3010 " + ruleElemCode + "\u3011\u672a\u8bbe\u7f6eget\u3001set\u65b9\u6cd5\uff01!"));
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                        return CommonResponse.error((String)("\u5b57\u6bb5\u3010 " + ruleElemCode + "\u3011\u672a\u4f20\u5165\u5bf9\u5e94\u7684\u503c\uff01!"));
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                        return CommonResponse.error((String)("\u5b57\u6bb5\u3010 " + ruleElemCode + "\u3011\u672a\u8bbe\u7f6eget\u3001set\u65b9\u6cd5\uff01!"));
                    }
                }
                if (!RuleElemType.\u6d41\u6c34\u53f7.getCode().equals(attrEntity.getRuleElemType())) continue;
                QueryWrapper snWrapper1 = new QueryWrapper();
                List snEntities = null;
                snWrapper1.select(new String[]{"start_sn,id"});
                snWrapper1.eq((Object)"rule_id", (Object)billCodeRuleEntity.getId());
                snWrapper1.eq((Object)"is_init", (Object)"1");
                this.buildDuplicateWrapper((QueryWrapper<BillcodeRuleSnEntity>)snWrapper1, retSnVO);
                snEntities = this.list((Wrapper)snWrapper1);
                if (snEntities == null || snEntities.size() == 0) {
                    QueryWrapper snWrapper2 = new QueryWrapper();
                    snWrapper2.select(new String[]{"start_sn,id"});
                    snWrapper2.eq((Object)"rule_id", (Object)billCodeRuleEntity.getId());
                    snWrapper2.eq((Object)"is_init", (Object)"0");
                    snWrapper2.orderByAsc((Object)"id");
                    snEntities = this.list((Wrapper)snWrapper2);
                }
                List<Integer> startSnList = snEntities.stream().map(BillcodeRuleSnEntity::getStartSn).collect(Collectors.toList());
                int initialNumber = attrEntity.getStartNum() == null ? 0 : attrEntity.getStartNum();
                Object[] objArr = BillcodeRuleSnServiceImpl.generateSerialNumber(initialNumber, attrEntity.getElemLength(), startSnList);
                sb.append(objArr[1].toString()).append(separator);
                retSnVO.setStartSn(Integer.parseInt(objArr[0].toString()));
                retSnVO.setCurrSn(objArr[1].toString());
            }
            if (StringUtils.isNotEmpty((String)separator)) {
                String generateBillcode = sb.substring(0, sb.length() - separator.length());
                retSnVO.setGenerateBillCode(generateBillcode);
            } else {
                retSnVO.setGenerateBillCode(sb.toString());
            }
            retSnVO.setProjectId(apiVO.getProjectId());
            retSnVO.setProjectCode(apiVO.getProjectCode());
            retSnVO.setProjectName(apiVO.getProjectName());
            retSnVO.setCategoryId(apiVO.getCategoryId());
            retSnVO.setIsInit("1");
            retSnVO.setRuleId(billCodeRuleEntity.getId());
            retSnVO.setSourcePid(snVO.getSourcePid());
            retSnVO.setSourceCode(snVO.getSourceCode());
            retSnVO.setSourceType(snVO.getSourceType());
            retSnVO.setSourceTypeName(snVO.getSourceTypeName());
            snRetList.add(retSnVO);
            String retSnVOInfo = JSONObject.toJSONString((Object)((Object)retSnVO));
            this.logger.info("\u53d6\u53f7\u8fd4\u56de\u4fe1\u606f---->" + retSnVOInfo);
        }
        apiVO.setSnList(snRetList);
        return CommonResponse.success((String)"\u751f\u6210\u7f16\u7801\u6210\u529f", (Object)apiVO);
    }

    @Override
    public void buildDuplicateWrapper(QueryWrapper<BillcodeRuleSnEntity> snDuplicateWrapper, BillcodeRuleSnVO snVO) {
        if (StringUtils.isNotEmpty((String)snVO.getRule01())) {
            snDuplicateWrapper.eq((Object)"rule01", (Object)snVO.getRule01());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule02())) {
            snDuplicateWrapper.eq((Object)"rule02", (Object)snVO.getRule02());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule03())) {
            snDuplicateWrapper.eq((Object)"rule03", (Object)snVO.getRule03());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule04())) {
            snDuplicateWrapper.eq((Object)"rule04", (Object)snVO.getRule04());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule05())) {
            snDuplicateWrapper.eq((Object)"rule05", (Object)snVO.getRule05());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule07())) {
            snDuplicateWrapper.eq((Object)"rule07", (Object)snVO.getRule07());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule08())) {
            snDuplicateWrapper.eq((Object)"rule08", (Object)snVO.getRule08());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule09())) {
            snDuplicateWrapper.eq((Object)"rule09", (Object)snVO.getRule09());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule10())) {
            snDuplicateWrapper.eq((Object)"rule10", (Object)snVO.getRule10());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule11())) {
            snDuplicateWrapper.eq((Object)"rule11", (Object)snVO.getRule11());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule12())) {
            snDuplicateWrapper.eq((Object)"rule12", (Object)snVO.getRule12());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule13())) {
            snDuplicateWrapper.eq((Object)"rule13", (Object)snVO.getRule13());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule14())) {
            snDuplicateWrapper.eq((Object)"rule14", (Object)snVO.getRule14());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule15())) {
            snDuplicateWrapper.eq((Object)"rule15", (Object)snVO.getRule15());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule16())) {
            snDuplicateWrapper.eq((Object)"rule16", (Object)snVO.getRule16());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule17())) {
            snDuplicateWrapper.eq((Object)"rule17", (Object)snVO.getRule17());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule18())) {
            snDuplicateWrapper.eq((Object)"rule18", (Object)snVO.getRule18());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule19())) {
            snDuplicateWrapper.eq((Object)"rule19", (Object)snVO.getRule19());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule20())) {
            snDuplicateWrapper.eq((Object)"rule20", (Object)snVO.getRule20());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule21())) {
            snDuplicateWrapper.eq((Object)"rule21", (Object)snVO.getRule21());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule22())) {
            snDuplicateWrapper.eq((Object)"rule22", (Object)snVO.getRule22());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule23())) {
            snDuplicateWrapper.eq((Object)"rule23", (Object)snVO.getRule23());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule24())) {
            snDuplicateWrapper.eq((Object)"rule24", (Object)snVO.getRule24());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule25())) {
            snDuplicateWrapper.eq((Object)"rule25", (Object)snVO.getRule25());
        }
        if (StringUtils.isNotEmpty((String)snVO.getRule26())) {
            snDuplicateWrapper.eq((Object)"rule26", (Object)snVO.getRule26());
        }
    }

    @Override
    public CommonResponse commitBillcode(BillcodeApiVO apiVO) {
        String strInfo = JSONObject.toJSONString((Object)apiVO);
        this.logger.info("\u63d0\u53f7\u53c2\u6570---->" + strInfo);
        List<BillcodeRuleSnVO> snList = apiVO.getSnList();
        if (snList == null || snList.size() == 0) {
            return CommonResponse.error((String)"snList\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
        }
        ArrayList<BillcodeRuleSnEntity> snEntityList = new ArrayList<BillcodeRuleSnEntity>();
        for (BillcodeRuleSnVO snVO : snList) {
            QueryWrapper snQueryWrapper = new QueryWrapper();
            snQueryWrapper.eq((Object)"source_pid", (Object)snVO.getSourcePid());
            snQueryWrapper.eq((Object)"generate_bill_code", (Object)snVO.getGenerateBillCode());
            int count = this.count((Wrapper)snQueryWrapper);
            if (count > 0) continue;
            HashMap<String, Object> sourceMap = new HashMap<String, Object>();
            ArrayList<Long> idList = new ArrayList<Long>();
            idList.add(snVO.getSourcePid());
            sourceMap.put("ids", idList);
            this.releaseBillcode(sourceMap);
            BillcodeRuleSnEntity snEntity = (BillcodeRuleSnEntity)((Object)BeanMapper.map((Object)((Object)snVO), BillcodeRuleSnEntity.class));
            snEntityList.add(snEntity);
        }
        if (ToolUtil.isNotEmpty(snEntityList)) {
            this.saveOrUpdateBatch(snEntityList, snEntityList.size(), false);
        }
        return CommonResponse.success((String)"\u5904\u7406\u6210\u529f\uff01");
    }

    @Override
    public CommonResponse releaseBillcode(Map<String, Object> sourceIds) {
        this.logger.info("\u8fd8\u53f7\u53c2\u6570---->" + sourceIds.toString());
        if (sourceIds.get("ids") == null) {
            return CommonResponse.error((String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList sourcePidList = (ArrayList)sourceIds.get("ids");
        QueryWrapper deleteWrapper = new QueryWrapper();
        deleteWrapper.in((Object)"source_pid", (Collection)sourcePidList);
        this.remove((Wrapper)deleteWrapper, false);
        return CommonResponse.success((String)"\u8fd8\u53f7\u6210\u529f");
    }

    public static Object[] generateSerialNumber(int initialNumber, int digitCount, List<Integer> startSnList) {
        int nextSerialNumber = BillcodeRuleSnServiceImpl.getNextSerialNumber(initialNumber);
        while (startSnList.contains(nextSerialNumber)) {
            nextSerialNumber = BillcodeRuleSnServiceImpl.getNextSerialNumber(nextSerialNumber);
        }
        String format = "%0" + digitCount + "d";
        String serialNumber = String.format(format, nextSerialNumber);
        Object[] objArr = new Object[]{nextSerialNumber, serialNumber};
        return objArr;
    }

    private static int getNextSerialNumber(int currentSerialNumber) {
        return currentSerialNumber + 1;
    }

    public static <T, V> V getFieldValue(T object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Class<?> clazz = object.getClass();
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return (V)field.get(object);
    }

    public CommonResponse<BillcodeRuleVO> getBillcodeRule(Long projectId, Long categoryId) {
        if (projectId == null || categoryId == null) {
            return CommonResponse.error((String)"\u83b7\u53d6\u5355\u636e\u7f16\u7801\u89c4\u5219 \u5931\u8d25\uff01\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper ruleQuery = new QueryWrapper();
        ruleQuery.eq((Object)"project_id", (Object)projectId);
        ruleQuery.eq((Object)"category_id", (Object)categoryId);
        BillcodeRuleEntity billCodeRuleEntity = (BillcodeRuleEntity)((Object)this.ruleService.getOne((Wrapper)ruleQuery, false));
        if (billCodeRuleEntity == null) {
            return CommonResponse.error((String)"\u672a\u5339\u914d\u5230\u53d6\u53f7\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5!");
        }
        QueryParam attQuery = new QueryParam();
        attQuery.getParams().put("rule_id", new Parameter("eq", (Object)billCodeRuleEntity.getId()));
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>();
        orderMap.put("id", "asc");
        attQuery.setOrderMap(orderMap);
        List ruleAttrEntities = this.attrService.queryList(attQuery, false);
        billCodeRuleEntity.setBillcodeRuleAttrList(ruleAttrEntities);
        BillcodeRuleVO billCodeRuleVO = (BillcodeRuleVO)((Object)BeanMapper.map((Object)((Object)billCodeRuleEntity), BillcodeRuleVO.class));
        return CommonResponse.success((Object)((Object)billCodeRuleVO));
    }
}

