/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.controller;

import cn.afterturn.easypoi.entity.ImageEntity;
import cn.afterturn.easypoi.word.WordExportUtil;
import cn.afterturn.easypoi.word.entity.MyXWPFDocument;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.ztpc.bean.OpinionInfoEntity;
import com.ejianc.ztpc.bean.ProjectImplementPlanEntity;
import com.ejianc.ztpc.mapper.UserSignatureMapper;
import com.ejianc.ztpc.service.IOpinionInfoService;
import com.ejianc.ztpc.service.IProjectImplementPlanService;
import com.ejianc.ztpc.service.ISignatureUserService;
import com.ejianc.ztpc.util.DocOpinionExportUtil;
import com.ejianc.ztpc.vo.ApproverVO;
import com.ejianc.ztpc.vo.ExportApproverVO;
import com.ejianc.ztpc.vo.ProjectImplementPlanVO;
import com.ejianc.ztpc.vo.SignatureDataVO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"projectImplementPlan"})
public class ProjectImplementPlanController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ZTPCCT_PROJECTIMPPLAN";
    @Autowired
    private IProjectImplementPlanService service;
    @Autowired
    private IOpinionInfoService opinionInfoService;
    private DocOpinionExportUtil opinionExportUtil = DocOpinionExportUtil.getDocOpinionExportUtil();
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private UserSignatureMapper userSignatureMapper;
    @Autowired
    private ISignatureUserService signatureUserService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectImplementPlanVO> saveOrUpdate(@RequestBody ProjectImplementPlanVO saveOrUpdateVO) {
        ProjectImplementPlanEntity entity = (ProjectImplementPlanEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ProjectImplementPlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ProjectImplementPlanVO vo = (ProjectImplementPlanVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectImplementPlanVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectImplementPlanVO> queryDetail(Long id) {
        ProjectImplementPlanEntity entity = (ProjectImplementPlanEntity)((Object)this.service.selectById(id));
        ProjectImplementPlanVO vo = (ProjectImplementPlanVO)((Object)BeanMapper.map((Object)((Object)entity), ProjectImplementPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectImplementPlanVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ProjectImplementPlanVO projectImplementPlanVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectImplementPlanVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        Parameter orgId = (Parameter)param.getParams().get("orgId");
        long parentOrgId = 0L;
        if (orgId != null) {
            parentOrgId = Long.parseLong(orgId.getValue().toString());
            param.getParams().remove("orgId");
        } else {
            parentOrgId = InvocationInfoProxy.getOrgId();
        }
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(parentOrgId)), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectImplementPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ProjectImplementPlan-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refProjectImplementPlanData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ProjectImplementPlanVO>> refProjectImplementPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ProjectImplementPlanVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExportOpinion"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportOpinion(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.opinionInfoService.queryList(param);
        ProjectImplementPlanEntity entity = null;
        Object wordMap = null;
        if (list == null || list.size() == 0) {
            return;
        }
        entity = (ProjectImplementPlanEntity)((Object)this.service.selectById(((OpinionInfoEntity)((Object)list.get(0))).getPid()));
        String id = "";
        if (param.getParams().get("id") != null) {
            id = ((Parameter)param.getParams().get("id")).getValue().toString();
        }
        if (id == null || id == "") {
            return;
        }
        String[] idStrings = id.substring(1, id.length() - 1).split(",");
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String str : idStrings) {
            try {
                ids.add(Long.parseLong(str.trim()));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        this.opinionExportUtil.exportDoc(entity, response, ids, "/excel/projectImplementPlan-opinion-export.docx", this.bpmApi, "fileName", entity.getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequestMapping(value={"/excelExportSignature"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportSignature(@RequestBody ExportApproverVO approver, @RequestParam Integer type, HttpServletResponse response) {
        boolean contains;
        int height = 40;
        int width = 80;
        ProjectImplementPlanEntity entity = (ProjectImplementPlanEntity)((Object)this.service.selectById(approver.getId()));
        Map wordMap = (Map)BeanMapper.map((Object)((Object)entity), Map.class);
        String resource = "";
        if (type == 1) {
            resource = "/excel/project-implement-plan-signature.docx";
        } else if (type == 2) {
            contains = approver.getApproverList().stream().anyMatch(value -> "\u529e\u516c\u5ba4\u5ba1\u6279".equals(value.getActivityName()));
            if (!contains) throw new BusinessException("\u5370\u7ae0\u672a\u7ecf\u529e\u516c\u5ba4\u5ba1\u6279");
            resource = "/excel/project-implement-plan-signature-stamp.docx";
        } else if (type == 3) {
            resource = "/excel/project-implement-plan-signature-unit.docx";
        } else if (type == 4) {
            contains = approver.getApproverList().stream().anyMatch(value -> "\u529e\u516c\u5ba4\u5ba1\u6279".equals(value.getActivityName()));
            if (!contains) throw new BusinessException("\u5370\u7ae0\u672a\u7ecf\u529e\u516c\u5ba4\u5ba1\u6279");
            resource = "/excel/project-implement-plan-signature-unit-stamp.docx";
        }
        for (ApproverVO approverVO : approver.getApproverList()) {
            ImageEntity image;
            SignatureDataVO dataByUserCode;
            UserVO user;
            CommonResponse userByUserId;
            Long approveUserId = approverVO.getApproveUserId();
            String approveUserName = approverVO.getApproveUserName();
            String approveUserDeptName = approverVO.getApproveUserDeptName();
            String activityName = approverVO.getActivityName();
            if ("\u9879\u76ee\u7ba1\u7406\u90e8".equals(activityName)) {
                if (!"\u718a\u5fc3\u97ec".equals(approveUserName) || !(userByUserId = this.userApi.findUserByUserId(approveUserId)).isSuccess() || userByUserId.getData() == null) continue;
                user = (UserVO)userByUserId.getData();
                dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
                image = new ImageEntity();
                image.setHeight(height);
                image.setWidth(width);
                if (dataByUserCode != null) {
                    image.setData(dataByUserCode.getImage());
                }
                image.setType(ImageEntity.Data);
                wordMap.put("xmglb", image);
                continue;
            }
            if ("\u515a\u7fa4\u5de5\u4f5c\u90e8".equals(activityName)) {
                userByUserId = this.userApi.findUserByUserId(approveUserId);
                if (!userByUserId.isSuccess() || userByUserId.getData() == null) continue;
                user = (UserVO)userByUserId.getData();
                dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
                image = new ImageEntity();
                image.setHeight(height);
                image.setWidth(width);
                if (dataByUserCode != null) {
                    image.setData(dataByUserCode.getImage());
                }
                image.setType(ImageEntity.Data);
                wordMap.put("dqgzb", image);
                continue;
            }
            if ("\u8d22\u52a1\u4ea7\u6743\u90e8".equals(activityName)) {
                userByUserId = this.userApi.findUserByUserId(approveUserId);
                if (!userByUserId.isSuccess() || userByUserId.getData() == null) continue;
                user = (UserVO)userByUserId.getData();
                dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
                image = new ImageEntity();
                image.setHeight(height);
                image.setWidth(width);
                if (dataByUserCode != null) {
                    image.setData(dataByUserCode.getImage());
                }
                image.setType(ImageEntity.Data);
                wordMap.put("cwcqb", image);
                continue;
            }
            if ("EPC\u603b\u627f\u5305\u4e2d\u5fc3".equals(activityName)) {
                userByUserId = this.userApi.findUserByUserId(approveUserId);
                if (!userByUserId.isSuccess() || userByUserId.getData() == null) continue;
                user = (UserVO)userByUserId.getData();
                dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
                image = new ImageEntity();
                image.setHeight(height);
                image.setWidth(width);
                if (dataByUserCode != null) {
                    image.setData(dataByUserCode.getImage());
                }
                image.setType(ImageEntity.Data);
                wordMap.put("epc", image);
                continue;
            }
            if ("\u91c7\u8d2d\u7ba1\u7406\u90e8".equals(activityName)) {
                userByUserId = this.userApi.findUserByUserId(approveUserId);
                if (!userByUserId.isSuccess() || userByUserId.getData() == null) continue;
                user = (UserVO)userByUserId.getData();
                dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
                image = new ImageEntity();
                image.setHeight(height);
                image.setWidth(width);
                if (dataByUserCode != null) {
                    image.setData(dataByUserCode.getImage());
                }
                image.setType(ImageEntity.Data);
                wordMap.put("cgglb", image);
                continue;
            }
            if ("\u6cd5\u52a1\u5ba1\u8ba1\u90e8".equals(activityName)) {
                userByUserId = this.userApi.findUserByUserId(approveUserId);
                if (!userByUserId.isSuccess() || userByUserId.getData() == null) continue;
                user = (UserVO)userByUserId.getData();
                dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
                image = new ImageEntity();
                image.setHeight(height);
                image.setWidth(width);
                if (dataByUserCode != null) {
                    image.setData(dataByUserCode.getImage());
                }
                image.setType(ImageEntity.Data);
                wordMap.put("fwsjb", image);
                continue;
            }
            if ("\u5b89\u5168\u76d1\u5bdf\u90e8".equals(activityName)) {
                userByUserId = this.userApi.findUserByUserId(approveUserId);
                if (!userByUserId.isSuccess() || userByUserId.getData() == null) continue;
                user = (UserVO)userByUserId.getData();
                dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
                image = new ImageEntity();
                image.setHeight(height);
                image.setWidth(width);
                if (dataByUserCode != null) {
                    image.setData(dataByUserCode.getImage());
                }
                image.setType(ImageEntity.Data);
                wordMap.put("aqjcb", image);
                continue;
            }
            if ("QA/QC\u90e8".equals(activityName)) {
                userByUserId = this.userApi.findUserByUserId(approveUserId);
                if (!userByUserId.isSuccess() || userByUserId.getData() == null) continue;
                user = (UserVO)userByUserId.getData();
                dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
                image = new ImageEntity();
                image.setHeight(height);
                image.setWidth(width);
                if (dataByUserCode != null) {
                    image.setData(dataByUserCode.getImage());
                }
                image.setType(ImageEntity.Data);
                wordMap.put("qaqc", image);
                continue;
            }
            if ("QHSE\u90e8".equals(activityName)) {
                if (wordMap.containsKey("qaqc") || !(userByUserId = this.userApi.findUserByUserId(approveUserId)).isSuccess() || userByUserId.getData() == null) continue;
                user = (UserVO)userByUserId.getData();
                dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
                image = new ImageEntity();
                image.setHeight(height);
                image.setWidth(width);
                if (dataByUserCode != null) {
                    image.setData(dataByUserCode.getImage());
                }
                image.setType(ImageEntity.Data);
                wordMap.put("qaqc", image);
                continue;
            }
            if ("\u5408\u540c\u7ba1\u7406\u90e8".equals(activityName)) {
                userByUserId = this.userApi.findUserByUserId(approveUserId);
                if (!userByUserId.isSuccess() || userByUserId.getData() == null) continue;
                user = (UserVO)userByUserId.getData();
                dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
                image = new ImageEntity();
                image.setHeight(height);
                image.setWidth(width);
                if (dataByUserCode != null) {
                    image.setData(dataByUserCode.getImage());
                }
                image.setType(ImageEntity.Data);
                wordMap.put("htglb", image);
                continue;
            }
            if ("\u4eba\u529b\u8d44\u6e90\u90e8".equals(activityName)) {
                userByUserId = this.userApi.findUserByUserId(approveUserId);
                if (!userByUserId.isSuccess() || userByUserId.getData() == null) continue;
                user = (UserVO)userByUserId.getData();
                dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
                image = new ImageEntity();
                image.setHeight(height);
                image.setWidth(width);
                if (dataByUserCode != null) {
                    image.setData(dataByUserCode.getImage());
                }
                image.setType(ImageEntity.Data);
                wordMap.put("rlzyb", image);
                continue;
            }
            if ("\u529e\u516c\u5ba4".equals(activityName)) {
                userByUserId = this.userApi.findUserByUserId(approveUserId);
                if (!userByUserId.isSuccess() || userByUserId.getData() == null) continue;
                user = (UserVO)userByUserId.getData();
                dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
                image = new ImageEntity();
                image.setHeight(height);
                image.setWidth(width);
                if (dataByUserCode != null) {
                    image.setData(dataByUserCode.getImage());
                }
                image.setType(ImageEntity.Data);
                wordMap.put("bgs", image);
                continue;
            }
            if (!"\u5206\u7ba1\u9886\u5bfc".equals(activityName) || !(userByUserId = this.userApi.findUserByUserId(approveUserId)).isSuccess() || userByUserId.getData() == null) continue;
            user = (UserVO)userByUserId.getData();
            dataByUserCode = this.userSignatureMapper.getDataByUserCode(user.getUserCode());
            image = new ImageEntity();
            image.setHeight(height);
            image.setWidth(width);
            if (dataByUserCode != null) {
                image.setData(dataByUserCode.getImage());
            }
            image.setType(ImageEntity.Data);
            wordMap.put("leader", image);
        }
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream(resource);){
            MyXWPFDocument document = new MyXWPFDocument(resourceAsStream);
            WordExportUtil.exportWord07((XWPFDocument)document, (Map)wordMap);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                document.write((OutputStream)out);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] fileData = out.toByteArray();
            response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            String fileName = "\u5c01\u9762.docx";
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(fileData);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = bais.read(buffer)) != -1) {
                    response.getOutputStream().write(buffer, 0, bytesRead);
                }
                response.flushBuffer();
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

