package com.ejianc.idmdata.orgcenter.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class SynDataBuilder {
    private static long PAGE_SIZE = 3000;//接口每页查询数量

    /**
     * 拼装查询的json数据
     * @param currentPage   当前页
     * @param type  all：查询全部，add：查询增量数据
     * @param code  主数据CODE精准查询,用于组织、部门、人员同步
     * @param desc1 主数据DESC1精准查询，用于兼职记录同步
     * @return
     */
    public static String getReqJson(String currentPage,String type,String code,String desc1){
        JSONObject splitPage = new JSONObject();
        splitPage.put("COUNTPERPAGE",PAGE_SIZE);
        splitPage.put("CURRENTPAGE",currentPage);

        JSONObject dataInfo = new JSONObject();
        dataInfo.put("CODE",code);
        dataInfo.put("DESC1",desc1);
        if("add".equals(type)){
            String reqDate = getReqDate();
            dataInfo.put("LASTMODIFYRECORDTIME",reqDate);
        }

        JSONArray dataInfoArr = new JSONArray();
        dataInfoArr.add(dataInfo);

        JSONObject dataInfos = new JSONObject();
        dataInfos.put("DATAINFO",dataInfoArr);

        JSONObject data = new JSONObject();
        data.put("DATAINFOS",dataInfos);
        data.put("SPLITPAGE",splitPage);

        JSONObject esb = new JSONObject();
        esb.put("DATA",data);

        JSONObject topJson = new JSONObject();
        topJson.put("ESB",esb);

        return topJson.toJSONString();
    }

    private static String getReqDate(){
        Calendar cal = Calendar.getInstance();
        cal.add(Calendar.DATE,-1);
        String yesterday = new SimpleDateFormat( "yyyy-MM-dd").format(cal.getTime());

        String today = new SimpleDateFormat( "yyyy-MM-dd").format(new Date());

        return yesterday + "~" + today;
    }
}
