package com.ejianc.idmdata.orgcenter.service.impl;

import com.ejianc.idmdata.orgcenter.mapper.ExternalMapper;
import com.ejianc.idmdata.orgcenter.service.IExternalService;
import com.ejianc.idmdata.orgcenter.vo.ActRuTaskVO;
import com.ejianc.idmdata.orgcenter.vo.AttachmentVO;
import com.ejianc.idmdata.orgcenter.vo.ButtonVO;
import com.ejianc.idmdata.orgcenter.vo.IdeModuleVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service("externalService")
public class ExternalServiceImpl implements IExternalService {

    @Autowired
    private ExternalMapper externalMapper;


    @Override
    public List<ButtonVO> getButton(Map<String, Object> params){
        return externalMapper.selectButton(params);
    }

    @Override
    public int getButtonCount() {
        return externalMapper.selectButtonCount();
    }

    @Override
    public List<AttachmentVO> getFileId(Map<String, Object> params) {
        return externalMapper.selectBySourceId(params);
    }

    @Override
    public List<ActRuTaskVO> getByBizKey(String businessKey) {
        return externalMapper.selectByBizKey(businessKey);
    }

    @Override
    public List<IdeModuleVO> getMyPageInfo(String appId, String code) {
        return externalMapper.selectMyPageInfo(appId, code);
    }

    @Override
    public List<Long> getOrgIdByOrgCode(String orgCode) {
        return externalMapper.selectOrgIdByOrgCode(orgCode);
    }
}
