package com.ejianc.idmdata.orgcenter.controller;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;

import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;

import com.ejianc.idmdata.orgcenter.service.IIdmOrgService;

/**
 * 组织
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("idmOrg")
public class IdmOrgController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IIdmOrgService orgService;

    /**
     * @Description shelfGoods 定时同步组织信息
     */
    @RequestMapping(value = "/synIdmOrg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> synIdmOrg(HttpServletRequest request) {
        String type = request.getParameter("type");
        if(StringUtils.isEmpty(type)){
            return CommonResponse.error("请求param中缺少参数type");
        }
        String queryCode = request.getParameter("queryCode");
        String queryDate = request.getParameter("queryDate");
        logger.info("com.ejianc.idmdata.orgcenter.controller.IdmOrgController.synIdmOrg开始同步组织信息" );
        CommonResponse response= orgService.synIdmOrg(type,queryCode,queryDate);
        return response;
    }

    /**
     * @Description shelfGoods 定时同步部门信息
     */
    @RequestMapping(value = "/synIdmDept", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> synIdmDept(HttpServletRequest request) {
        String type = request.getParameter("type");
        if(StringUtils.isEmpty(type)){
            return CommonResponse.error("请求param中缺少参数type");
        }
        String queryCode = request.getParameter("queryCode");
        String queryDate = request.getParameter("queryDate");
        logger.info("com.ejianc.idmdata.orgcenter.controller.IdmOrgController.synIdmDept开始同步部门信息" );
        CommonResponse response= orgService.synIdmDept(type,queryCode,queryDate);
        return response;
    }

    /**
     * @Description shelfGoods 定时同步人员
     */
    @RequestMapping(value = "/synIdmEmp", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> synIdmEmp(HttpServletRequest request) {
        String type = request.getParameter("type");
        if(StringUtils.isEmpty(type)){
            return CommonResponse.error("请求param中缺少参数type");
        }
        String queryCode = request.getParameter("queryCode");
        String queryDate = request.getParameter("queryDate");
        logger.info("com.ejianc.idmdata.orgcenter.controller.IdmOrgController.synIdmEmp开始同步人员信息" );
        CommonResponse response= orgService.synIdmEmp(type,queryCode,queryDate);
        return response;
    }

}
