package com.ejianc.idmdata.orgcenter.mapper;

import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.idmdata.orgcenter.vo.ActRuTaskVO;
import com.ejianc.idmdata.orgcenter.vo.AttachmentVO;
import com.ejianc.idmdata.orgcenter.vo.ButtonVO;
import com.ejianc.idmdata.orgcenter.vo.IdeModuleVO;
import com.ejianc.ztpcdata.vo.EmployeeVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 部门
 *
 * @author generator
 */
@Mapper
public interface ExternalMapper {
    List<ButtonVO> selectButton(@Param("params") Map<String, Object> params);

    int selectButtonCount();

    List<AttachmentVO> selectBySourceId(@Param("params") Map<String, Object> params);

    List<ActRuTaskVO> selectByBizKey(@Param("businessKey") String businessKey);

    List<IdeModuleVO> selectMyPageInfo(@Param("appId") String appId, @Param("code") String code);

    List<Long> selectOrgIdByOrgCode(@Param("orgCode") String orgCode);

    List<Map<String, Object>> queryMapProjLocal();
    List<Map<String, Object>> queryMapAllDept();

    List<Map<String, Object>> queryAllDeptCondition(@Param("orgId")String orgId);
    List<Map<String, Object>> queryMapAllEmployee();

    List<Map<String, Object>> getAttachmentBySourceIdAndSourceType(@Param("sourceId") Long sourceId, @Param("sourceType") String sourceType);

    List<OrgVO> getOrgList(@Param("orgType")Integer orgType,@Param("projectState") Integer projectState,@Param("parentOrgId") Long parentOrgId);

    List<EmployeeVO> getEmployeeByName(@Param("names") List<String> names);

    List<SupplierVO> querySupplierByName(@Param("name")String name);
    List<Map<String, Object>> querySupplierByIds(@Param("ids")String ids);
}
