package com.ejianc.idmdata.orgcenter.controller;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.idmdata.orgcenter.service.IIdmJobService;
import com.ejianc.idmdata.orgcenter.service.IIdmOrgService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;

/**
 * 任职记录
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("idmJob")
public class IdmJobController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IIdmJobService jobService;

    /**
     * @Description shelfGoods 定时同步人员
     */
    @RequestMapping(value = "/synIdmJob", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> synIdmJob(HttpServletRequest request) {
        String type = request.getParameter("type");
        if(StringUtils.isEmpty(type)){
            return CommonResponse.error("请求param中缺少参数type");
        }
        String DESC1 = request.getParameter("DESC1");
        String queryDate = request.getParameter("queryDate");
        logger.info("com.ejianc.idmdata.orgcenter.controller.IdmJobController.synIdmJob开始同步任职记录" );
        CommonResponse response= jobService.synIdmJob(type,DESC1,queryDate);
        return response;
    }

}
