package com.ejianc.business.dc.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeDrwgrpinfoEntity;
import com.ejianc.business.dc.bean.DcDrawrecycleDrwgrpinfoEntity;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeDrwgrpinfoService;
import com.ejianc.business.dc.vo.DcDrawInfoVO;
import com.ejianc.business.dc.vo.DcDrawdistributeDrwgrpinfoVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.vo.DcDrwgrpInfoVO;

/**
 * 卷册信息
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("dcDrwgrpInfo")
public class DcDrwgrpInfoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IDcDrwgrpInfoService service;
    @Autowired
    private IDcDrawInfoService dcDrawInfoService;
    @Autowired
    private IDcDrawdistributeDrwgrpinfoService dcDrawdistributeDrwgrpinfoService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoVO> saveOrUpdate(@RequestBody DcDrwgrpInfoVO saveOrUpdateVO) {
        String operateType;
    	DcDrwgrpInfoEntity entity = BeanMapper.map(saveOrUpdateVO, DcDrwgrpInfoEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }
            operateType = "add";
            entity.setDrwgrpSts("0");
            entity.setIssueSts("0");
        }else {
            operateType = "edit";
        }
        //更新子表信息
        if ("edit".equals(operateType)) {
            dcDrawInfoService.remove(new QueryWrapper<DcDrawInfoEntity>().lambda()
                    .eq(DcDrawInfoEntity::getDrwgrpId, entity.getId()));
        }
        List<DcDrawInfoVO> dcDrawInfoEntityList = saveOrUpdateVO.getDcDrawInfoEntityList();
        List<DcDrawInfoEntity> entityList = BeanMapper.mapList(dcDrawInfoEntityList, DcDrawInfoEntity.class);
        if (entityList.size() > 0) {
            for (DcDrawInfoEntity dcDrawInfoEntity : entityList) {
                dcDrawInfoEntity.setDrwgrpId(entity.getId());
                dcDrawInfoEntity.setDrwgrpCode(entity.getDrwgrpCode());
                dcDrawInfoEntity.setDrwgrpVsn(entity.getDrwgrpVsn());
                dcDrawInfoEntity.setOrgId(entity.getOrgId());
                dcDrawInfoEntity.setOrgCode(entity.getOrgCode());
                dcDrawInfoEntity.setOrgName(entity.getOrgName());
                dcDrawInfoEntity.setParentOrgId(entity.getParentOrgId());
                dcDrawInfoEntity.setParentOrgCode(entity.getParentOrgCode());
                dcDrawInfoEntity.setParentOrgName(entity.getParentOrgName());
            }
//            dcDrawInfoService.saveOrUpdateBatch(entityList, entityList.size(), false);
        }
        entity.setDcDrawInfoEntityList(entityList);
        service.saveOrUpdate(entity, false);
        DcDrwgrpInfoVO vo = BeanMapper.map(entity, DcDrwgrpInfoVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
    * 升版
     * @param fList
    * @return DataResponse
    **/
    @PostMapping("/upgrade")
    public CommonResponse<DcDrwgrpInfoVO> upgrade(@RequestBody List<DcDrwgrpInfoVO> fList) {
        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntityList = new ArrayList<>();
        fList.stream().forEach(f -> {
            DcDrwgrpInfoEntity entity = BeanMapper.map(f, DcDrwgrpInfoEntity.class);
            List<DcDrawInfoVO> dcDrawInfoEntityList = f.getDcDrawInfoEntityList();
            List<DcDrawInfoEntity> dcDrawInfoEntities = BeanMapper.mapList(dcDrawInfoEntityList, DcDrawInfoEntity.class);
            entity.setDcDrawInfoEntityList(dcDrawInfoEntities);
            dcDrwgrpInfoEntityList.add(entity);
        });
        service.upgrade(dcDrwgrpInfoEntityList);
        return CommonResponse.success("升版单据成功！");
    }

    /**
     * 图纸回收
     * @param fList
     * @return DataResponse
     **/
    @PostMapping("/annul")
    public CommonResponse<DcDrwgrpInfoVO> annul(@RequestBody List<DcDrwgrpInfoVO> fList) {
        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntityList = new ArrayList<>();
        fList.stream().forEach(f -> {
            DcDrwgrpInfoEntity entity = BeanMapper.map(f, DcDrwgrpInfoEntity.class);
            List<DcDrawInfoVO> dcDrawInfoEntityList = f.getDcDrawInfoEntityList();
            List<DcDrawInfoEntity> dcDrawInfoEntities = BeanMapper.mapList(dcDrawInfoEntityList, DcDrawInfoEntity.class);
            entity.setDcDrawInfoEntityList(dcDrawInfoEntities);
            dcDrwgrpInfoEntityList.add(entity);
        });
        service.annul(dcDrwgrpInfoEntityList);
        return CommonResponse.success("作废单据成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DcDrwgrpInfoVO> queryDetail(Long id) {
    	DcDrwgrpInfoEntity entity = service.selectById(id);
    	DcDrwgrpInfoVO vo = BeanMapper.map(entity, DcDrwgrpInfoVO.class);
    	//图纸信息
        List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda()
                .eq(DcDrawInfoEntity::getDrwgrpId, vo.getId()));
        List<DcDrawInfoVO> dcDrawInfoVOS = BeanMapper.mapList(dcDrawInfoEntityList, DcDrawInfoVO.class);
        vo.setDcDrawInfoEntityList(dcDrawInfoVOS);
        //签发信息
        List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoEntityList = dcDrawdistributeDrwgrpinfoService.list(new QueryWrapper<DcDrawdistributeDrwgrpinfoEntity>().lambda()
                .eq(DcDrawdistributeDrwgrpinfoEntity::getDrwgrpCode, vo.getDrwgrpCode())
                .eq(DcDrawdistributeDrwgrpinfoEntity::getDrwgrpVsn, vo.getDrwgrpVsn()));
        List<DcDrawdistributeDrwgrpinfoVO> dcDrawdistributeDrwgrpinfoVOList = BeanMapper.mapList(dcDrawdistributeDrwgrpinfoEntityList, DcDrawdistributeDrwgrpinfoVO.class);
        vo.setDcDrawdistributeDrwgrpinfoEntityList(dcDrawdistributeDrwgrpinfoVOList);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcDrwgrpInfoVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DcDrwgrpInfoVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> idList = vos.stream().map(DcDrwgrpInfoVO::getId).collect(Collectors.toList());
        service.removeByIds(idList,true);
        List<DcDrawInfoEntity> list = dcDrawInfoService.list(new QueryWrapper<DcDrawInfoEntity>().lambda().in(DcDrawInfoEntity::getDrwgrpId, idList));
        if (list.size() > 0) {
            dcDrawInfoService.removeByIds(list.stream().map(DcDrawInfoEntity::getId).collect(Collectors.toList()));
        }
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DcDrwgrpInfoVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DcDrwgrpInfoEntity> page = service.queryPage(param,false);
        IPage<DcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcDrwgrpInfoVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DcDrwgrpInfoEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<DcDrwgrpInfoVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, DcDrwgrpInfoVO.class);
            voList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcDrwgrpInfo-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refDcDrwgrpInfoData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DcDrwgrpInfoVO>> refDcDrwgrpInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DcDrwgrpInfoEntity> page = service.queryPage(param,false);
        IPage<DcDrwgrpInfoVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcDrwgrpInfoVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
