package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.dc.bean.DcDrawdistributeDrwgrpinfoEntity;
import com.ejianc.business.dc.bean.DcDrawrecycleInfoEntity;
import com.ejianc.business.dc.service.IDcDrawdistributeDrwgrpinfoService;
import com.ejianc.business.dc.service.IDcDrawrecycleInfoService;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("dcDrawrecycleInfo")
public class DcDrawrecycleInfoBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IDcDrawrecycleInfoService service;
	@Autowired
	private IDcDrawdistributeDrwgrpinfoService dcDrawdistributeDrwgrpinfoService;

	private static final String BILL_CODE = "DC_DRAWRECYCLE_CODE";

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		UserContext userContextCache = sessionManager.getUserContext();
		DcDrawrecycleInfoEntity one = service.getOne(new QueryWrapper<DcDrawrecycleInfoEntity>().lambda()
				.eq(DcDrawrecycleInfoEntity::getId, billId));
		if (one == null) {
			throw new BusinessException("未查询到id为【" + billId + "】的数据！");
		}
		BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), JSONObject.parseObject(JSONObject.toJSONString(one)));
		CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
		if (billCode.isSuccess()) {
			DcDrawrecycleInfoEntity entity = new DcDrawrecycleInfoEntity();
			entity.setId(billId);
			entity.setRecycleCode(billCode.getData());
			entity.setRecycleDate(new Date());
			entity.setRecycleUserCode(userContextCache.getUserCode());
			entity.setRecycleUserName(userContextCache.getUserName());
			service.updateById(entity);
			dcDrawdistributeDrwgrpinfoService.update(new UpdateWrapper<DcDrawdistributeDrwgrpinfoEntity>().lambda()
					.set(DcDrawdistributeDrwgrpinfoEntity::getRecycleSts, "Y")
					.eq(DcDrawdistributeDrwgrpinfoEntity::getDrwgrpCode, one.getDrwgrpCode())
					.eq(DcDrawdistributeDrwgrpinfoEntity::getDrwgrpVsn, one.getDrwgrpVsn()));
		} else {
			throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
