package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.dc.bean.*;
import com.ejianc.business.dc.bean.convert.CtDrawdistributeDrwgrpinfo2CtDrawrecycleDrwgrpinfo;
import com.ejianc.business.dc.bean.convert.CtDrawdistributeInfoDto2CtDrwgrpInfo;
import com.ejianc.business.dc.controller.DcDrawdistributeInfoController;
import com.ejianc.business.dc.controller.DcDrawrecycleDrwgrpinfoController;
import com.ejianc.business.dc.controller.DcDrawrecycleInfoController;
import com.ejianc.business.dc.controller.DcDrwgrpInfoController;
import com.ejianc.business.dc.mapper.DcDrawdistributeDrwgrpinfoMapper;
import com.ejianc.business.dc.vo.*;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.dc.mapper.DcDrwgrpInfoMapper;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 卷册信息
 *
 * @author generator
 */
@Service("dcDrwgrpInfoService")
public class DcDrwgrpInfoServiceImpl extends BaseServiceImpl<DcDrwgrpInfoMapper, DcDrwgrpInfoEntity> implements IDcDrwgrpInfoService, ICommonBusinessService {

    @Autowired
    private DcDrawdistributeDrwgrpinfoMapper dcDrawdistributeDrwgrpinfoMapper;
    @Autowired
    private CtDrawdistributeDrwgrpinfo2CtDrawrecycleDrwgrpinfo ctDrawdistributeDrwgrpinfo2CtDrawrecycleDrwgrpinfo;
    @Autowired
    private DcDrawrecycleInfoController dcDrawrecycleInfoController;
    @Autowired
    private DcDrwgrpInfoController dcDrwgrpInfoController;
    @Autowired
    private DcDrawdistributeInfoController dcDrawdistributeInfoController;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private CtDrawdistributeInfoDto2CtDrwgrpInfo ctDrawdistributeInfoDto2CtDrwgrpInfo;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("图纸库数据提交回调，开始回写状态,billId:"+billId);
        DcDrwgrpInfoEntity dcDrwgrpInfoEntity = this.baseMapper.selectById(billId);
        if(null != dcDrwgrpInfoEntity) {

        }
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        logger.info("图纸库数据终审后回调，开始回写状态,billId:"+billId);
        DcDrwgrpInfoEntity dcDrwgrpInfoEntity = this.baseMapper.selectById(billId);
        if(null != dcDrwgrpInfoEntity) {
            List<DcDrawdistributeDrwgrpinfoEntity> ctDrawdistributeDrwgrpinfoList = dcDrwgrpInfoEntity.getDcDrawdistributeDrwgrpinfoEntityList();
            //bean转换
            //遍历签发信息    生成每一个图纸签发卷册信息表
            if(ObjectUtils.allNotNull(ctDrawdistributeDrwgrpinfoList)){
                DcDrawdistributeInfoEntity dcDrawdistributeInfoEntity = ctDrawdistributeInfoDto2CtDrwgrpInfo.ctDrwgrpInfo2CtDrawdistributeInfoDto(dcDrwgrpInfoEntity);
                dcDrawdistributeInfoEntity.setIssueUserCode(sessionManager.getUserContext().getUserCode());
                dcDrawdistributeInfoEntity.setIssueUserName(sessionManager.getUserContext().getUserName());
                dcDrawdistributeInfoEntity.setIssueDate(new Date());
                dcDrawdistributeInfoEntity.setCreateTime(new Date());
                dcDrawdistributeInfoEntity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
                dcDrawdistributeInfoEntity.setCreateUserCode(sessionManager.getUserContext().getUserCode());

                DcDrawdistributeInfoVO vo = BeanMapper.map(dcDrawdistributeInfoEntity, DcDrawdistributeInfoVO.class);
                List<DcDrawdistributeDrwgrpinfoVO> dcDrawdistributeDrwgrpinfoVOList = BeanMapper.mapList(ctDrawdistributeDrwgrpinfoList, DcDrawdistributeDrwgrpinfoVO.class);
                vo.setDcDrawdistributeDrwgrpinfoEntityList(dcDrawdistributeDrwgrpinfoVOList);
                dcDrawdistributeInfoController.saveOrUpdate(vo);

            }else {
                throw new BusinessException("没有添加签发信息不允许申请签发");
            }

            UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
            updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, dcDrwgrpInfoEntity.getId())
                    .set(DcDrwgrpInfoEntity::getIssueSts, "1")
                    .set(DcDrwgrpInfoEntity::getIssueUserCode, sessionManager.getUserContext().getUserCode())
                    .set(DcDrwgrpInfoEntity::getIssueUserName, sessionManager.getUserContext().getUserName());
            int update = this.baseMapper.update(null, updateWrapper);
            if (update != 1) {
                throw new BusinessException("更新数据失败!");
            }
        }
        return null;
    }

    /**
     * 升版
     *
     * @param entities
     * @return boolean
     **/
    @Override
    public boolean upgrade(List<DcDrwgrpInfoEntity> entities) {
        //获取卷册数据   如果有签发信息  则生成回收单
        entities.stream().forEach(f -> {
            String drwgrpVsn = f.getDrwgrpVsn();
            String oldDrwgrpVsn = f.getOldDrwgrpVsn();
            String issueUserid = f.getIssueUserCode();
            String issueUsername = f.getIssueUserName();
            String orgCode = f.getOrgCode();
            Long orgId = f.getOrgId();
            String orgName = f.getOrgName();
            String projectCode = f.getProjectCode();
            String projectName = f.getProjectName();
            Long projectId = f.getProjectId();
            Long parentOrgId = f.getParentOrgId();
            String parentOrgName = f.getParentOrgName();
            String parentOrgCode = f.getParentOrgCode();
            Long oldId = f.getId();

            //旧版作废,如果有未回收的签发数据，生成一条回收主表信息
            DcDrawdistributeDrwgrpinfoEntity oldDcDrawdistributeDrwgrpinfoEntity = new DcDrawdistributeDrwgrpinfoEntity();
            oldDcDrawdistributeDrwgrpinfoEntity.setDrwgrpCode(f.getOldDrwgrpCode());
            oldDcDrawdistributeDrwgrpinfoEntity.setDrwgrpVsn(oldDrwgrpVsn);
            List<DcDrawdistributeDrwgrpinfoEntity> ctDrawdistributeDrwgrpinfoDos = this.dcDrawdistributeDrwgrpinfoMapper.selectList(new QueryWrapper<>(oldDcDrawdistributeDrwgrpinfoEntity));
            List<DcDrawrecycleDrwgrpinfoEntity> ctDrawrecycleDrwgrpinfoDtoList = new ArrayList<>();
            if (ObjectUtils.allNotNull(ctDrawdistributeDrwgrpinfoDos)) {
                //做个标记 如果Num数字大于一则表示有回收单生成 需要生成一个总的回收单编号
                for (DcDrawdistributeDrwgrpinfoEntity ctDrawdistributeDrwgrpinfoDo : ctDrawdistributeDrwgrpinfoDos) {
                    //如果没回收 则生成一条回收单   子表数据为RecycleSts为N的数据
                    if (ctDrawdistributeDrwgrpinfoDo.getRecycleSts().equals("N")) {
                        DcDrawrecycleDrwgrpinfoEntity dcDrawrecycleDrwgrpinfoEntity = ctDrawdistributeDrwgrpinfo2CtDrawrecycleDrwgrpinfo.ctDrawdistributeDrwgrpinfoDto2CtDrawrecycleDrwgrpinfoDto(ctDrawdistributeDrwgrpinfoDo);
                        ctDrawrecycleDrwgrpinfoDtoList.add(dcDrawrecycleDrwgrpinfoEntity);
                    }
                }
                if (ctDrawrecycleDrwgrpinfoDtoList.size() > 0) {
                    DcDrawrecycleInfoEntity ctDrawrecycleInfoDto = new DcDrawrecycleInfoEntity();
                    ctDrawrecycleInfoDto.setIssueUserCode(issueUserid);
                    ctDrawrecycleInfoDto.setIssueUserName(issueUsername);
                    ctDrawrecycleInfoDto.setOrgCode(orgCode);
                    ctDrawrecycleInfoDto.setOrgId(orgId);
                    ctDrawrecycleInfoDto.setOrgName(orgName);
                    ctDrawrecycleInfoDto.setParentOrgId(parentOrgId);
                    ctDrawrecycleInfoDto.setParentOrgCode(parentOrgCode);
                    ctDrawrecycleInfoDto.setParentOrgName(parentOrgName);
                    ctDrawrecycleInfoDto.setDrwgrpCode(f.getDrwgrpCode());
                    ctDrawrecycleInfoDto.setDrwgrpName(f.getDrwgrpName());
                    ctDrawrecycleInfoDto.setDrwgrpVsn(oldDrwgrpVsn);
                    ctDrawrecycleInfoDto.setDcDrawrecycleDrwgrpinfoList(ctDrawrecycleDrwgrpinfoDtoList);
                    DcDrawrecycleInfoVO dcDrawrecycleInfoVO = BeanMapper.map(ctDrawrecycleInfoDto, DcDrawrecycleInfoVO.class);
                    dcDrawrecycleInfoController.saveOrUpdate(dcDrawrecycleInfoVO);
                }
            }

            //新版数据添加
            f.setCreateDeptId(sessionManager.getUserContext().getDeptId());
            f.setCreateUserCode(sessionManager.getUserContext().getUserCode());
            f.setDrwgrpVsn(drwgrpVsn);
            f.setIssueSts("0");
            f.setIssueUserCode(null);
            f.setIssueUserName(null);
            f.setDrwgrpSts("Y");
            f.setId(IdWorker.getId());
            DcDrwgrpInfoVO vo = BeanMapper.map(f, DcDrwgrpInfoVO.class);
            dcDrwgrpInfoController.saveOrUpdate(vo);
            //更新旧版本
            UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
            updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, oldId)
                    .set(DcDrwgrpInfoEntity::getDrwgrpSts, "N");
            int update = this.baseMapper.update(null, updateWrapper);
            if (update != 1) {
                throw new BusinessException("更新旧版数据失败!");
            }
        });
        return true;
    }

    /**
     * 图纸回收
     *
     * @param entities
     * @return boolean
     **/
    @Override
    public boolean annul(List<DcDrwgrpInfoEntity> entities) {
        //图纸库生成回收单
        entities.stream().forEach(f -> {

            List<DcDrawdistributeDrwgrpinfoEntity> ctDrawdistributeDrwgrpinfoList = f.getDcDrawdistributeDrwgrpinfoEntityList();
            List<DcDrawrecycleDrwgrpinfoEntity> ctDrawrecycleDrwgrpinfoDtoList = new ArrayList<>();
            for (DcDrawdistributeDrwgrpinfoEntity ctDrawdistributeDrwgrpinfoDto : ctDrawdistributeDrwgrpinfoList) {
                DcDrawrecycleDrwgrpinfoEntity dcDrawrecycleDrwgrpinfoEntity = ctDrawdistributeDrwgrpinfo2CtDrawrecycleDrwgrpinfo.ctDrawdistributeDrwgrpinfoDto2CtDrawrecycleDrwgrpinfoDto(ctDrawdistributeDrwgrpinfoDto);
                ctDrawrecycleDrwgrpinfoDtoList.add(dcDrawrecycleDrwgrpinfoEntity);
            }
            if (ObjectUtils.allNotNull(ctDrawdistributeDrwgrpinfoList)) {
                DcDrawrecycleInfoEntity ctDrawrecycleInfoDto = new DcDrawrecycleInfoEntity();
                ctDrawrecycleInfoDto.setIssueUserCode(f.getIssueUserCode());
                ctDrawrecycleInfoDto.setIssueUserName(f.getIssueUserName());
                ctDrawrecycleInfoDto.setOrgCode(f.getOrgCode());
                ctDrawrecycleInfoDto.setOrgId(f.getOrgId());
                ctDrawrecycleInfoDto.setOrgName(f.getOrgName());
                ctDrawrecycleInfoDto.setParentOrgId(f.getParentOrgId());
                ctDrawrecycleInfoDto.setParentOrgCode(f.getProjectCode());
                ctDrawrecycleInfoDto.setParentOrgName(f.getParentOrgName());
                ctDrawrecycleInfoDto.setDrwgrpCode(f.getDrwgrpCode());
                ctDrawrecycleInfoDto.setDrwgrpName(f.getDrwgrpName());
                ctDrawrecycleInfoDto.setDrwgrpVsn(f.getDrwgrpVsn());
                ctDrawrecycleInfoDto.setDcDrawrecycleDrwgrpinfoList(ctDrawrecycleDrwgrpinfoDtoList);
                DcDrawrecycleInfoVO vo = BeanMapper.map(ctDrawrecycleInfoDto, DcDrawrecycleInfoVO.class);
                dcDrawrecycleInfoController.saveOrUpdate(vo);
            }
//            f.setRecycleSts("1");
//            f.setDrwgrpSts("N");
            UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
            updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, f.getId())
                    .set(DcDrwgrpInfoEntity::getDrwgrpSts, "N");
            int update = this.baseMapper.update(null, updateWrapper);
            if (update != 1) {
                throw new BusinessException("更新数据失败!");
            }
        });
        return true;
    }
}
