package com.ejianc.business.dc.controller;

import java.io.Serializable;

import com.ejianc.business.basem.utils.ValidateUtil;
import com.ejianc.business.dc.vo.DcDrawdistributeInfoVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.vo.DcFiledistributeCenterVO;

/**
 * 文件分发中心
 *
 * @author generator
 */
@Controller
@RequestMapping("dcFiledistributeCenter")
public class DcFiledistributeCenterController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "DC_SEND_FILE_CODE";//此处需要根据实际修改

    @Autowired
    private IDcFiledistributeCenterService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcFiledistributeCenterVO> saveOrUpdate(@RequestBody DcFiledistributeCenterVO saveOrUpdateVO) {
        DcFiledistributeCenterEntity entity = BeanMapper.map(saveOrUpdateVO, DcFiledistributeCenterEntity.class);
        entity.setBillState(0);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setFileCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setFileInternalCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        DcFiledistributeCenterVO vo = BeanMapper.map(entity, DcFiledistributeCenterVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @description:签发回填
     * @author: chengminggao
     * @date: 2023/5/10 17:10
     * @param: [saveOrUpdateVO]
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.dc.vo.DcFiledistributeCenterVO>
     **/
    @RequestMapping(value = "/fillIssue", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcFiledistributeCenterVO> fillIssue(@RequestBody DcFiledistributeCenterVO saveOrUpdateVO) {
        saveOrUpdateVO.getDcFileissueRecordList().stream().forEach(e ->{
            e.setFileCode(saveOrUpdateVO.getFileCode());
            e.setFileName(saveOrUpdateVO.getFileName());
            e.setFileVsn(saveOrUpdateVO.getFileVsn());
            e.setFileInternalCode(saveOrUpdateVO.getFileInternalCode());
        });
        DcFiledistributeCenterEntity entity = BeanMapper.map(saveOrUpdateVO, DcFiledistributeCenterEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setFileCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setFileInternalCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        service.saveOrUpdate(entity, false);
        DcFiledistributeCenterVO vo = BeanMapper.map(entity, DcFiledistributeCenterVO.class);
        return CommonResponse.success("保存或修改单据成功！");
    }


    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DcFiledistributeCenterVO> queryDetail(Long id) {
        DcFiledistributeCenterEntity entity = service.selectById(id);
        DcFiledistributeCenterVO vo = BeanMapper.map(entity, DcFiledistributeCenterVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcFiledistributeCenterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DcFiledistributeCenterVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DcFiledistributeCenterVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DcFiledistributeCenterVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DcFiledistributeCenterEntity> page = service.queryPage(param, false);
        IPage<DcFiledistributeCenterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcFiledistributeCenterVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DcFiledistributeCenterEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcFiledistributeCenter-export.xlsx", beans, response);
    }



    @RequestMapping(value = "/refDcFiledistributeCenterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DcFiledistributeCenterVO>> refDcFiledistributeCenterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                         String condition,
                                                                                         String searchObject,
                                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DcFiledistributeCenterEntity> page = service.queryPage(param, false);
        IPage<DcFiledistributeCenterVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcFiledistributeCenterVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @description:合同模版查找文件属性 返回格式------->前台要求
     * @author: chengminggao
     * @date: 2023/5/11 9:35
     * @param: [pid]
     * @return: com.ejianc.framework.core.response.CommonResponse
     **/
    @RequestMapping(value = "/selectAttributeByPid", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, List<Map>>> selectAttributeByPid(@RequestParam String pid) {
        List<Map> categoryNameList = service.selectAttributeByPid(pid);

        if (ValidateUtil.isEmpty(categoryNameList)) {
            new BusinessException("没有文件属性数据，请联系管理员");
        }
        Map data = new HashMap<>();
        data.put("data", categoryNameList);
        return CommonResponse.success("查询数据成功！", data);
    }

    /**
     * @description:在线编辑模版id查询 返回格式------->前台要求
     * @author: chengminggao
     * @date: 2023/5/12 9:13
     * @param: [pid]
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.Map < java.lang.String, java.util.List < java.util.Map>>>
     **/
    @RequestMapping(value = "/selectTemplateByCategoryId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Map<String, List<Map>>> selectTemplateByCategoryId(@RequestParam String id) {
        List<Map> templateList = service.selectTemplateByCategoryId(id);

        if (ValidateUtil.isEmpty(templateList)) {
            new BusinessException("没有文件属性数据，请联系管理员");
        }
        Map data = new HashMap<>();
        data.put("data", templateList);
        return CommonResponse.success("查询数据成功！", data);
    }


    @RequestMapping(value = "/deleteCache", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcDrawdistributeInfoVO> deleteCache(@RequestBody Map<String,Object> params) {
        String referCode = (String) params.get("referCode");
        String key = (String) params.get("key");
        RedisTemplate<String, Object> redisTemplate = ContextUtil.getBean("redisTemplate", RedisTemplate.class);
        String cacheKey = referCode + ":" + key;
        redisTemplate.delete(cacheKey);
        return CommonResponse.success("清理缓存成功！");
    }

    @RequestMapping(value = "/selectAttribute", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List> selectAttribute(){
        List<Map> maps = service.selectAttribute();
        return CommonResponse.success("查询成功",maps);
    }

}
