package com.ejianc.business.dc.enumUtils;


import com.ejianc.framework.core.response.BillStateEnum;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 卷册状态
 *
 * @author: swb
 * @date: 2023/05/11
 **/
public enum DrwgrpStsEnum {
    Y("Y", "有效"),
    N("N", "无效");

    private final String code;
    private final String name;
    private static Map<String, DrwgrpStsEnum> enumMap = new HashMap();

    private DrwgrpStsEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static DrwgrpStsEnum getEnumByCode(String code) {
        return (DrwgrpStsEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(DrwgrpStsEnum.class).stream().collect(Collectors.toMap(DrwgrpStsEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
