package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.dc.bean.DcDrawdistributeDrwgrpinfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeInfoEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.controller.DcDrawdistributeInfoController;
import com.ejianc.business.dc.mapper.DcDrawdistributeDrwgrpinfoMapper;
import com.ejianc.business.dc.mapper.DcDrawdistributeInfoMapper;
import com.ejianc.business.dc.mapper.DcDrwgrpInfoMapper;
import com.ejianc.business.dc.vo.DcDrawdistributeInfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Service("dcDrawdistributeInfo") 
public class DcDrawdistributeInfoBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	ActRuTaskService actRuTaskService;
	@Autowired
	private DcDrawdistributeInfoMapper dcDrawdistributeInfoMapper;
	@Autowired
	private DcDrawdistributeDrwgrpinfoMapper dcDrawdistributeDrwgrpinfoMapper;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private DcDrwgrpInfoMapper dcDrwgrpInfoMapper;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeInApprovalBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DcDrawdistributeInfoEntity dcDrawdistributeInfoEntity = this.dcDrawdistributeInfoMapper.selectById(billId);
		if(null != dcDrawdistributeInfoEntity){
			if("pass_a".equals(nodeType)){//签发时，更新图纸图签发人等信息和签发表的签发信息
				//查询对应图册信息
				DcDrwgrpInfoEntity dcDrwgrpInfoEntity = dcDrwgrpInfoMapper.selectById(dcDrawdistributeInfoEntity.getDrwgrpId());
				//判断是否有签发信息,如果存在签发信息，判断总的签发份数是否大于库存数；如果不存在签发信息不允许签发
				QueryWrapper<DcDrawdistributeDrwgrpinfoEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.lambda().eq(DcDrawdistributeDrwgrpinfoEntity::getPid, dcDrawdistributeInfoEntity.getId());
				List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoEntityList = dcDrawdistributeDrwgrpinfoMapper.selectList(queryWrapper);
				BigDecimal sum_paper_num = new BigDecimal(0);
				if (dcDrawdistributeDrwgrpinfoEntityList.size() > 0) {
					if (null != dcDrwgrpInfoEntity) {
						//判断总签发数是否大于库存量
						sum_paper_num = new BigDecimal(dcDrawdistributeDrwgrpinfoEntityList.stream()
								.filter(e -> "Y".equals(e.getPaperFlag()))
								.mapToInt(e -> e.getNum()).sum());
						if (new BigDecimal(dcDrwgrpInfoEntity.getSurplusNum()).compareTo(sum_paper_num) < 0) {
							return CommonResponse.error("图册号【" + dcDrawdistributeInfoEntity.getDistUserCode() + "】签发总份数大于该图册库存总量【" + dcDrwgrpInfoEntity.getSurplusNum() + "】!");
						}
					} else {
						return CommonResponse.error("查询图纸库库存量数据有误!");
					}
				} else {
					return CommonResponse.error("没有添加签发信息不允许签发!");
				}

				//更新图纸库签发信息和库存量
				UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
				updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, dcDrawdistributeInfoEntity.getDrwgrpId())
						.set(DcDrwgrpInfoEntity::getIssueSts, "1")
						.set(DcDrwgrpInfoEntity::getSurplusNum, new BigDecimal(dcDrwgrpInfoEntity.getSurplusNum()).subtract(sum_paper_num))
						.set(DcDrwgrpInfoEntity::getIssueUserCode, sessionManager.getUserContext().getUserCode())
						.set(DcDrwgrpInfoEntity::getIssueUserName, sessionManager.getUserContext().getUserName());
				int update = this.dcDrwgrpInfoMapper.update(null, updateWrapper);
				if (update != 1) {
					return CommonResponse.error("更新数据失败!");
				}

				//更新签发信息表签发信息
				UpdateWrapper<DcDrawdistributeInfoEntity> dcDrawdistributeInfoEntityUpdateWrapper = new UpdateWrapper<>();
				dcDrawdistributeInfoEntityUpdateWrapper.lambda().eq(DcDrawdistributeInfoEntity::getId, dcDrawdistributeInfoEntity.getId())
						.set(DcDrawdistributeInfoEntity::getIssueDate, new Date())
						.set(DcDrawdistributeInfoEntity::getIssueUserCode, sessionManager.getUserContext().getUserCode())
						.set(DcDrawdistributeInfoEntity::getIssueUserName, sessionManager.getUserContext().getUserName());
				int update_disb = this.dcDrawdistributeInfoMapper.update(null, dcDrawdistributeInfoEntityUpdateWrapper);
				if (update_disb != 1) {
					return CommonResponse.error("更新数据失败!");
				}
			}else if("pass_b".equals(nodeType)){//分发时，更新签发表的分发信息
				String distCode = null;
				if (ObjectUtils.allNotNull(dcDrawdistributeInfoEntity.getDistCode())) {
					distCode = dcDrawdistributeInfoEntity.getDistCode();
				}else {
					DcDrawdistributeInfoVO entity = BeanMapper.map(dcDrawdistributeInfoEntity, DcDrawdistributeInfoVO.class);
					BillCodeParam billCodeParam = BillCodeParam.build(DcDrawdistributeInfoController.BILL_CODE, InvocationInfoProxy.getTenantid(),entity);
					CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
					if(billCode.isSuccess()) {
						distCode = billCode.getData();//此处需要根据实际修改 删除本行或者下一行
					}else{
						return CommonResponse.error("网络异常， 编码生成失败， 请稍后再试");
					}
				}

				//更新签发信息表分发信息
				UpdateWrapper<DcDrawdistributeInfoEntity> dcDrawdistributeInfoEntityUpdateWrapper = new UpdateWrapper<>();
				dcDrawdistributeInfoEntityUpdateWrapper.lambda().eq(DcDrawdistributeInfoEntity::getId, dcDrawdistributeInfoEntity.getId())
						.set(DcDrawdistributeInfoEntity::getDistDate, new Date())
						.set(DcDrawdistributeInfoEntity::getDistCode, distCode)
						.set(DcDrawdistributeInfoEntity::getDistUserCode, sessionManager.getUserContext().getUserCode())
						.set(DcDrawdistributeInfoEntity::getDistUserName, sessionManager.getUserContext().getUserName());
				int update = this.dcDrawdistributeInfoMapper.update(null, dcDrawdistributeInfoEntityUpdateWrapper);
				if (update != 1) {
					return CommonResponse.error("更新数据失败!");
				}
			}
		}else {
			return CommonResponse.error("操作失败!");
		}
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DcDrawdistributeInfoEntity dcDrawdistributeInfoEntity = this.dcDrawdistributeInfoMapper.selectById(billId);
		if(null != dcDrawdistributeInfoEntity){
			if("pass_a".equals(nodeType)){//签发时，更新图纸图签发人等信息和签发表的签发信息
				//查询对应图册信息
				DcDrwgrpInfoEntity dcDrwgrpInfoEntity = dcDrwgrpInfoMapper.selectById(dcDrawdistributeInfoEntity.getDrwgrpId());
				//判断是否有签发信息,如果存在签发信息，判断总的签发份数是否大于库存数；如果不存在签发信息不允许签发
				QueryWrapper<DcDrawdistributeDrwgrpinfoEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.lambda().eq(DcDrawdistributeDrwgrpinfoEntity::getPid, dcDrawdistributeInfoEntity.getId());
				List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoEntityList = dcDrawdistributeDrwgrpinfoMapper.selectList(queryWrapper);
				BigDecimal sum_paper_num = new BigDecimal(0);
				if (dcDrawdistributeDrwgrpinfoEntityList.size() > 0) {
					if (null != dcDrwgrpInfoEntity) {
						//判断总签发数是否大于库存量
						sum_paper_num = new BigDecimal(dcDrawdistributeDrwgrpinfoEntityList.stream()
								.filter(e -> "Y".equals(e.getPaperFlag()))
								.mapToInt(e -> e.getNum()).sum());
						if (new BigDecimal(dcDrwgrpInfoEntity.getSurplusNum()).compareTo(sum_paper_num) < 0) {
							return CommonResponse.error("图册号【" + dcDrawdistributeInfoEntity.getDistUserCode() + "】签发总份数大于该图册库存总量【" + dcDrwgrpInfoEntity.getSurplusNum() + "】!");
						}
					} else {
						return CommonResponse.error("查询图纸库库存量数据有误!");
					}
				} else {
					return CommonResponse.error("没有添加签发信息不允许签发!");
				}

				//更新图纸库签发信息和库存量
				UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
				updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, dcDrawdistributeInfoEntity.getDrwgrpId())
						.set(DcDrwgrpInfoEntity::getIssueSts, "1")
						.set(DcDrwgrpInfoEntity::getSurplusNum, new BigDecimal(dcDrwgrpInfoEntity.getSurplusNum()).subtract(sum_paper_num))
						.set(DcDrwgrpInfoEntity::getIssueUserCode, sessionManager.getUserContext().getUserCode())
						.set(DcDrwgrpInfoEntity::getIssueUserName, sessionManager.getUserContext().getUserName());
				int update = this.dcDrwgrpInfoMapper.update(null, updateWrapper);
				if (update != 1) {
					return CommonResponse.error("更新数据失败!");
				}

				//更新签发信息表签发信息
				UpdateWrapper<DcDrawdistributeInfoEntity> dcDrawdistributeInfoEntityUpdateWrapper = new UpdateWrapper<>();
				dcDrawdistributeInfoEntityUpdateWrapper.lambda().eq(DcDrawdistributeInfoEntity::getId, dcDrawdistributeInfoEntity.getId())
						.set(DcDrawdistributeInfoEntity::getIssueDate, new Date())
						.set(DcDrawdistributeInfoEntity::getIssueUserCode, sessionManager.getUserContext().getUserCode())
						.set(DcDrawdistributeInfoEntity::getIssueUserName, sessionManager.getUserContext().getUserName());
				int update_disb = this.dcDrawdistributeInfoMapper.update(null, dcDrawdistributeInfoEntityUpdateWrapper);
				if (update_disb != 1) {
					return CommonResponse.error("更新数据失败!");
				}
			}else if("pass_b".equals(nodeType)){//分发时，更新签发表的分发信息
				String distCode = null;
				if (ObjectUtils.allNotNull(dcDrawdistributeInfoEntity.getDistCode())) {
					distCode = dcDrawdistributeInfoEntity.getDistCode();
				}else {
					DcDrawdistributeInfoVO entity = BeanMapper.map(dcDrawdistributeInfoEntity, DcDrawdistributeInfoVO.class);
					BillCodeParam billCodeParam = BillCodeParam.build(DcDrawdistributeInfoController.BILL_CODE, InvocationInfoProxy.getTenantid(),entity);
					CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
					if(billCode.isSuccess()) {
						distCode = billCode.getData();//此处需要根据实际修改 删除本行或者下一行
					}else{
						return CommonResponse.error("网络异常， 编码生成失败， 请稍后再试");
					}
				}

				//更新签发信息表分发信息
				UpdateWrapper<DcDrawdistributeInfoEntity> dcDrawdistributeInfoEntityUpdateWrapper = new UpdateWrapper<>();
				dcDrawdistributeInfoEntityUpdateWrapper.lambda().eq(DcDrawdistributeInfoEntity::getId, dcDrawdistributeInfoEntity.getId())
						.set(DcDrawdistributeInfoEntity::getDistDate, new Date())
						.set(DcDrawdistributeInfoEntity::getDistCode, distCode)
						.set(DcDrawdistributeInfoEntity::getDistUserCode, sessionManager.getUserContext().getUserCode())
						.set(DcDrawdistributeInfoEntity::getDistUserName, sessionManager.getUserContext().getUserName());
				int update = this.dcDrawdistributeInfoMapper.update(null, dcDrawdistributeInfoEntityUpdateWrapper);
				if (update != 1) {
					return CommonResponse.error("更新数据失败!");
				}
			}
		}else {
			return CommonResponse.error("操作失败!");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
