package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.*;
import com.ejianc.business.dc.bean.convert.CtDrawdistributeDrwgrpinfo2CtDrawrecycleDrwgrpinfo;
import com.ejianc.business.dc.bean.convert.CtDrawdistributeInfoDto2CtDrwgrpInfo;
import com.ejianc.business.dc.controller.DcDrawdistributeInfoController;
import com.ejianc.business.dc.controller.DcDrawrecycleDrwgrpinfoController;
import com.ejianc.business.dc.controller.DcDrawrecycleInfoController;
import com.ejianc.business.dc.controller.DcDrwgrpInfoController;
import com.ejianc.business.dc.mapper.DcDrawdistributeDrwgrpinfoMapper;
import com.ejianc.business.dc.mapper.DcDrawdistributeInfoMapper;
import com.ejianc.business.dc.vo.*;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.ObjectUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.dc.mapper.DcDrwgrpInfoMapper;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 卷册信息
 *
 * @author generator
 */
@Service("dcDrwgrpInfoService")
public class DcDrwgrpInfoServiceImpl extends BaseServiceImpl<DcDrwgrpInfoMapper, DcDrwgrpInfoEntity> implements IDcDrwgrpInfoService {

    @Autowired
    private DcDrawdistributeDrwgrpinfoMapper dcDrawdistributeDrwgrpinfoMapper;
    @Autowired
    private CtDrawdistributeDrwgrpinfo2CtDrawrecycleDrwgrpinfo ctDrawdistributeDrwgrpinfo2CtDrawrecycleDrwgrpinfo;
    @Autowired
    private DcDrawrecycleInfoController dcDrawrecycleInfoController;
    @Autowired
    private DcDrwgrpInfoController dcDrwgrpInfoController;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private DcDrawdistributeInfoMapper dcDrawdistributeInfoMapper;


    /**
     * 升版
     *
     * @param entities
     * @return boolean
     **/
    @Override
    public boolean upgrade(List<DcDrwgrpInfoEntity> entities) {
        //获取卷册数据   如果有签发信息  则生成回收单
        entities.stream().forEach(f -> {
            String drwgrpVsn = f.getDrwgrpVsn();
            String orgCode = f.getOrgCode();
            Long orgId = f.getOrgId();
            String orgName = f.getOrgName();
            Long parentOrgId = f.getParentOrgId();
            String parentOrgName = f.getParentOrgName();
            String parentOrgCode = f.getParentOrgCode();
            Long oldId = f.getId();

            //查询旧的图册信息
            DcDrwgrpInfoEntity dcDrwgrpInfoEntity = this.baseMapper.selectById(oldId);

            //旧版作废,如果有未回收的签发数据，生成一条回收主表信息
            QueryWrapper<DcDrawdistributeDrwgrpinfoEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda().eq(DcDrawdistributeDrwgrpinfoEntity::getDrwgrpId, dcDrwgrpInfoEntity.getId());
            List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoEntityList = this.dcDrawdistributeDrwgrpinfoMapper.selectList(queryWrapper);
            List<DcDrawrecycleDrwgrpinfoEntity> ctDrawrecycleDrwgrpinfoDtoList = new ArrayList<>();
            if (dcDrawdistributeDrwgrpinfoEntityList.size() > 0) {
                //做个标记 如果Num数字大于一则表示有回收单生成 需要生成一个总的回收单编号
                for (DcDrawdistributeDrwgrpinfoEntity dcDrawdistributeDrwgrpinfoEntity : dcDrawdistributeDrwgrpinfoEntityList) {
                    //如果没回收 则生成一条回收单   子表数据为RecycleSts为N的数据
                    if (dcDrawdistributeDrwgrpinfoEntity.getRecycleSts().equals("N")) {
                        DcDrawrecycleDrwgrpinfoEntity dcDrawrecycleDrwgrpinfoEntity = ctDrawdistributeDrwgrpinfo2CtDrawrecycleDrwgrpinfo.ctDrawdistributeDrwgrpinfoDto2CtDrawrecycleDrwgrpinfoDto(dcDrawdistributeDrwgrpinfoEntity);
                        ctDrawrecycleDrwgrpinfoDtoList.add(dcDrawrecycleDrwgrpinfoEntity);
                    }
                }
                if (ctDrawrecycleDrwgrpinfoDtoList.size() > 0) {
                    DcDrawrecycleInfoEntity ctDrawrecycleInfoDto = new DcDrawrecycleInfoEntity();
                    ctDrawrecycleInfoDto.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                    ctDrawrecycleInfoDto.setDrwgrpCode(dcDrwgrpInfoEntity.getDrwgrpCode());
                    ctDrawrecycleInfoDto.setDrwgrpName(dcDrwgrpInfoEntity.getDrwgrpName());
                    ctDrawrecycleInfoDto.setDrwgrpVsn(dcDrwgrpInfoEntity.getDrwgrpVsn());
                    ctDrawrecycleInfoDto.setDrwgrpType(dcDrwgrpInfoEntity.getDrwgrpType());
                    ctDrawrecycleInfoDto.setSourceUnitid(dcDrwgrpInfoEntity.getSourceUnitid());
                    ctDrawrecycleInfoDto.setSourceUnitname(dcDrwgrpInfoEntity.getSourceUnitname());
                    ctDrawrecycleInfoDto.setMgrp(dcDrwgrpInfoEntity.getMgrp());
                    ctDrawrecycleInfoDto.setSpecialty(dcDrwgrpInfoEntity.getSpecialty());
                    ctDrawrecycleInfoDto.setSys(dcDrwgrpInfoEntity.getSys());
                    ctDrawrecycleInfoDto.setDrawArriveDate(dcDrwgrpInfoEntity.getDrawArriveDate());
                    ctDrawrecycleInfoDto.setIssueUserCode(dcDrwgrpInfoEntity.getIssueUserCode());
                    ctDrawrecycleInfoDto.setIssueUserName(dcDrwgrpInfoEntity.getIssueUserName());
                    ctDrawrecycleInfoDto.setOrgCode(orgCode);
                    ctDrawrecycleInfoDto.setOrgId(orgId);
                    ctDrawrecycleInfoDto.setOrgName(orgName);
                    ctDrawrecycleInfoDto.setParentOrgId(parentOrgId);
                    ctDrawrecycleInfoDto.setParentOrgCode(parentOrgCode);
                    ctDrawrecycleInfoDto.setParentOrgName(parentOrgName);
                    ctDrawrecycleInfoDto.setProjectCode(dcDrwgrpInfoEntity.getProjectCode());
                    ctDrawrecycleInfoDto.setProjectId(dcDrwgrpInfoEntity.getProjectId());
                    ctDrawrecycleInfoDto.setProjectName(dcDrwgrpInfoEntity.getProjectName());

                    ctDrawrecycleInfoDto.setDcDrawrecycleDrwgrpinfoList(ctDrawrecycleDrwgrpinfoDtoList);
                    DcDrawrecycleInfoVO dcDrawrecycleInfoVO = BeanMapper.map(ctDrawrecycleInfoDto, DcDrawrecycleInfoVO.class);
                    dcDrawrecycleInfoController.saveOrUpdate(dcDrawrecycleInfoVO);
                }
            }

            //新版数据添加
            f.setCreateDeptId(sessionManager.getUserContext().getDeptId());
            f.setCreateUserCode(sessionManager.getUserContext().getUserCode());
            f.setDrwgrpVsn(drwgrpVsn);
            f.setIssueSts("0");
            f.setIssueUserCode(null);
            f.setIssueUserName(null);
            f.setDrwgrpSts("N");
            f.setId(null);
            DcDrwgrpInfoVO vo = BeanMapper.map(f, DcDrwgrpInfoVO.class);
            vo.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());

            //校验同一个项目下卷册名称，卷册编号，卷册版本不能重复
            QueryWrapper<DcDrwgrpInfoEntity> dcDrwgrpInfoEntityQueryWrapper = new QueryWrapper();
            dcDrwgrpInfoEntityQueryWrapper.lambda().eq(ToolUtil.isNotEmpty(f.getProjectId()), DcDrwgrpInfoEntity::getProjectId, f.getProjectId())
                    .eq(DcDrwgrpInfoEntity::getDr, 0)
                    .eq(DcDrwgrpInfoEntity::getDrwgrpCode, f.getDrwgrpCode())
                    .eq(DcDrwgrpInfoEntity::getDrwgrpName, f.getDrwgrpName())
                    .eq(DcDrwgrpInfoEntity::getDrwgrpVsn, f.getDrwgrpVsn());
            List<DcDrwgrpInfoEntity> list = baseMapper.selectList(dcDrwgrpInfoEntityQueryWrapper);
            if (list.size() > 0) {
                throw new BusinessException("该卷册已添加");
            }
            dcDrwgrpInfoController.saveOrUpdate(vo);
            //更新旧版本
//            UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
//            updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, oldId)
//                    .set(DcDrwgrpInfoEntity::getDrwgrpSts, "N");
//            int update = this.baseMapper.update(null, updateWrapper);
//            if (update != 1) {
//                throw new BusinessException("更新旧版数据失败!");
//            }
        });
        return true;
    }

    /**
     * 图纸回收
     *
     * @param entities
     * @return boolean
     **/
    @Override
    public boolean annul(List<DcDrwgrpInfoEntity> entities) {
        //图纸库生成回收单
        entities.stream().forEach(f -> {
            List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoEntityList = dcDrawdistributeDrwgrpinfoMapper.selectList(new QueryWrapper<DcDrawdistributeDrwgrpinfoEntity>().lambda()
                    .eq(DcDrawdistributeDrwgrpinfoEntity::getDrwgrpId, f.getId()));
            List<DcDrawrecycleDrwgrpinfoEntity> dcDrawrecycleDrwgrpinfoEntityList = new ArrayList<>();
            for (DcDrawdistributeDrwgrpinfoEntity dcDrawdistributeDrwgrpinfoEntity : dcDrawdistributeDrwgrpinfoEntityList) {
                DcDrawrecycleDrwgrpinfoEntity dcDrawrecycleDrwgrpinfoEntity = ctDrawdistributeDrwgrpinfo2CtDrawrecycleDrwgrpinfo.ctDrawdistributeDrwgrpinfoDto2CtDrawrecycleDrwgrpinfoDto(dcDrawdistributeDrwgrpinfoEntity);
                dcDrawrecycleDrwgrpinfoEntityList.add(dcDrawrecycleDrwgrpinfoEntity);
            }
            if (dcDrawrecycleDrwgrpinfoEntityList.size() > 0) {
                DcDrawrecycleInfoEntity ctDrawrecycleInfoDto = new DcDrawrecycleInfoEntity();
                ctDrawrecycleInfoDto.setOrgCode(f.getOrgCode());
                ctDrawrecycleInfoDto.setOrgId(f.getOrgId());
                ctDrawrecycleInfoDto.setOrgName(f.getOrgName());
                ctDrawrecycleInfoDto.setParentOrgId(f.getParentOrgId());
                ctDrawrecycleInfoDto.setParentOrgCode(f.getProjectCode());
                ctDrawrecycleInfoDto.setParentOrgName(f.getParentOrgName());
                ctDrawrecycleInfoDto.setProjectCode(f.getProjectCode());
                ctDrawrecycleInfoDto.setProjectId(f.getProjectId());
                ctDrawrecycleInfoDto.setProjectName(f.getProjectName());
                ctDrawrecycleInfoDto.setDrwgrpCode(f.getDrwgrpCode());
                ctDrawrecycleInfoDto.setDrwgrpName(f.getDrwgrpName());
                ctDrawrecycleInfoDto.setDrwgrpVsn(f.getDrwgrpVsn());
                ctDrawrecycleInfoDto.setDrwgrpType(f.getDrwgrpType());
                ctDrawrecycleInfoDto.setSourceUnitid(f.getSourceUnitid());
                ctDrawrecycleInfoDto.setSourceUnitname(f.getSourceUnitname());
                ctDrawrecycleInfoDto.setMgrp(f.getMgrp());
                ctDrawrecycleInfoDto.setSpecialty(f.getSpecialty());
                ctDrawrecycleInfoDto.setSys(f.getSys());
                ctDrawrecycleInfoDto.setDrawArriveDate(f.getDrawArriveDate());
                ctDrawrecycleInfoDto.setIssueUserCode(f.getIssueUserCode());
                ctDrawrecycleInfoDto.setIssueUserName(f.getIssueUserName());
                ctDrawrecycleInfoDto.setRecycleSts("N");
                ctDrawrecycleInfoDto.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                ctDrawrecycleInfoDto.setDcDrawrecycleDrwgrpinfoList(dcDrawrecycleDrwgrpinfoEntityList);
                DcDrawrecycleInfoVO vo = BeanMapper.map(ctDrawrecycleInfoDto, DcDrawrecycleInfoVO.class);
                dcDrawrecycleInfoController.saveOrUpdate(vo);
            }
            UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
            updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, f.getId())
                    .set(DcDrwgrpInfoEntity::getDrwgrpSts, "N");
            int update = this.baseMapper.update(null, updateWrapper);
            if (update != 1) {
                throw new BusinessException("更新数据失败!");
            }
        });
        return true;
    }
}
