package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.basem.utils.ValidateUtil;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.service.IDcSendFileService;
import com.ejianc.framework.core.exception.BusinessException;
import jodd.util.StringUtil;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

@Service("dcFiledistributeCenter")
public class DcFiledistributeCenterBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	ActRuTaskService actRuTaskService;
	@Autowired
	IDcFiledistributeCenterService iDcFiledistributeCenterService;
	@Autowired
	IDcSendFileService iDcSendFileService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DcFiledistributeCenterEntity f = iDcFiledistributeCenterService.selectById(billId);
		if (ValidateUtil.isNotEmpty(f)&&ValidateUtil.isNotEmpty(f.getSourceTable())){
			iDcSendFileService.update(new UpdateWrapper<DcSendFileEntity>().lambda()
					.eq(DcSendFileEntity::getId,f.getSourceId())
					.set(DcSendFileEntity::getReplyDate,f.getReplyDate())
					.set(DcSendFileEntity::getReplyAttachment,f.getReplyAttachment())
					.set(DcSendFileEntity::getReplyOpinion,f.getReplyOpinion()));
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DcFiledistributeCenterEntity f = iDcFiledistributeCenterService.selectById(billId);
		if (ValidateUtil.isNotEmpty(f)&&ValidateUtil.isNotEmpty(f.getSourceTable())){
			iDcSendFileService.update(new UpdateWrapper<DcSendFileEntity>().lambda()
					.eq(DcSendFileEntity::getId,f.getSourceId())
					.set(DcSendFileEntity::getReplyDate,f.getReplyDate())
					.set(DcSendFileEntity::getReplyAttachment,f.getReplyAttachment())
					.set(DcSendFileEntity::getReplyOpinion,f.getReplyOpinion()));
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DcFiledistributeCenterEntity f = iDcFiledistributeCenterService.selectById(billId);
		if (ValidateUtil.isNotEmpty(f)&&ValidateUtil.isNotEmpty(f.getSourceTable())){
			iDcSendFileService.update(new UpdateWrapper<DcSendFileEntity>().lambda()
					.eq(DcSendFileEntity::getId,f.getSourceId())
					.set(DcSendFileEntity::getReplyDate,f.getReplyDate())
					.set(DcSendFileEntity::getReplyAttachment,f.getReplyAttachment())
					.set(DcSendFileEntity::getReplyOpinion,f.getReplyOpinion()));
		}
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DcFiledistributeCenterEntity f = iDcFiledistributeCenterService.selectById(billId);
		if (ValidateUtil.isNotEmpty(f)&&ValidateUtil.isNotEmpty(f.getSourceTable())){
			iDcSendFileService.update(new UpdateWrapper<DcSendFileEntity>().lambda()
					.eq(DcSendFileEntity::getId,f.getSourceId())
					.set(DcSendFileEntity::getReplyDate,f.getReplyDate())
					.set(DcSendFileEntity::getReplyAttachment,f.getReplyAttachment())
					.set(DcSendFileEntity::getReplyOpinion,f.getReplyOpinion()));
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		/**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		 if(!resp.isSuccess()){
		 return CommonResponse.error("无法撤回！"+resp.getMsg());
		 }*/
		return CommonResponse.success();
	}


}
