package com.ejianc.business.dc.service.impl;

import com.ejianc.business.basem.service.IAttachmentService;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.basem.utils.ValidateUtil;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.service.IDcFiledistributeMenuService;
import com.ejianc.business.dc.service.IDcSendFileService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.support.idworker.util.IdWorker;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Map;

@Service("dcSendFile") 
public class DcSendFileBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private SessionManager sessionManager;

	@Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IDcSendFileService iDcSendFileService;

	@Autowired
	private IDcFiledistributeCenterService iDcFiledistributeCenterService;
	@Autowired
	ActRuTaskService actRuTaskService;
	@Autowired
	IAttachmentService iAttachmentService;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeSubmitProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterSubmitProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeHasBpmBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterHasBpmBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeInApprovalBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	};

	@Override
	public  CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterInApprovalBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode+"    taskId:"+taskId+"    isEnd:"+isEnd+"    sign:"+sign+"    other:"+other);
		return CommonResponse.success();
	};
	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	}



	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeAbstainingProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DcSendFileEntity dcSendFileEntity = iDcSendFileService.selectById(billId);
		if (ValidateUtil.isNotEmpty(dcSendFileEntity) ) {
			UserContext userContextCache =sessionManager.getUserContext();
			DcFiledistributeCenterEntity dcFiledistributeCenterEntity = new DcFiledistributeCenterEntity();
			dcFiledistributeCenterEntity.setId(IdWorker.getId());
			dcFiledistributeCenterEntity.setBidsection(dcSendFileEntity.getBidsection());
			dcFiledistributeCenterEntity.setContractId(dcSendFileEntity.getContractId());
			dcFiledistributeCenterEntity.setBillState(0);
			dcFiledistributeCenterEntity.setAttribute(dcSendFileEntity.getAttribute());
			dcFiledistributeCenterEntity.setFiletype(dcSendFileEntity.getFiletype());
			dcFiledistributeCenterEntity.setContractCode(dcSendFileEntity.getContractCode());
			dcFiledistributeCenterEntity.setContractName(dcSendFileEntity.getContractName());
			dcFiledistributeCenterEntity.setFileAttachment(dcSendFileEntity.getFileAttachment());
			dcFiledistributeCenterEntity.setFileCode(dcSendFileEntity.getFileCode());
			dcFiledistributeCenterEntity.setCopyOrgCode(dcSendFileEntity.getCopyOrgCode());
			dcFiledistributeCenterEntity.setCostFlag(dcSendFileEntity.getCostFlag());
			dcFiledistributeCenterEntity.setSubmitType(dcSendFileEntity.getSubmitType());
			dcFiledistributeCenterEntity.setCreateTime(new Date());
			dcFiledistributeCenterEntity.setCreateDeptId(userContextCache.getDeptId());
			dcFiledistributeCenterEntity.setCreateUserCode(userContextCache.getUserCode());
			dcFiledistributeCenterEntity.setSyncEsFlag(dcSendFileEntity.getSyncEsFlag());
			dcFiledistributeCenterEntity.setFileInternalCode(dcSendFileEntity.getFileInternalCode());
			dcFiledistributeCenterEntity.setFileSts(dcSendFileEntity.getFileSts());
			dcFiledistributeCenterEntity.setFileName(dcSendFileEntity.getFileName());
			dcFiledistributeCenterEntity.setFileVsn(dcSendFileEntity.getFileVsn());
			dcFiledistributeCenterEntity.setMgrp(dcSendFileEntity.getMgrp());
			dcFiledistributeCenterEntity.setMaterialType(dcSendFileEntity.getMaterialType());
			dcFiledistributeCenterEntity.setProjectCode(dcSendFileEntity.getProjectCode());
			dcFiledistributeCenterEntity.setOrgCode(dcSendFileEntity.getOrgCode());
			dcFiledistributeCenterEntity.setOrgId(dcSendFileEntity.getOrgId());
			dcFiledistributeCenterEntity.setSpecialty(dcSendFileEntity.getSpecialty());
			dcFiledistributeCenterEntity.setSys(dcSendFileEntity.getSys());
			dcFiledistributeCenterEntity.setSubItem(dcSendFileEntity.getSubItem());
			dcFiledistributeCenterEntity.setUnitProjCode(dcSendFileEntity.getUnitProjCode());
			dcFiledistributeCenterEntity.setUnitProjName(dcSendFileEntity.getUnitProjName());
			dcFiledistributeCenterEntity.setOtherAttachment(dcSendFileEntity.getOtherAttachment());
			dcFiledistributeCenterEntity.setProjectName(dcSendFileEntity.getProjectName());
			dcFiledistributeCenterEntity.setProjectId(dcSendFileEntity.getProjectId());
			dcFiledistributeCenterEntity.setOrgName(dcSendFileEntity.getOrgName());
			dcFiledistributeCenterEntity.setParentOrgCode(dcSendFileEntity.getParentOrgCode());
			dcFiledistributeCenterEntity.setParentOrgId(dcSendFileEntity.getParentOrgId());
			dcFiledistributeCenterEntity.setParentOrgName(dcSendFileEntity.getParentOrgName());
			dcFiledistributeCenterEntity.setSubmitOrgId(dcSendFileEntity.getSubmitOrgId());
			dcFiledistributeCenterEntity.setSubmitOrgCode(dcSendFileEntity.getSubmitOrgCode());
			dcFiledistributeCenterEntity.setSubmitOrgName(dcSendFileEntity.getSubmitOrgName());
			dcFiledistributeCenterEntity.setCopyOrgId(dcSendFileEntity.getCopyOrgId());
			dcFiledistributeCenterEntity.setCopyOrgCode(dcSendFileEntity.getCopyOrgCode());
			dcFiledistributeCenterEntity.setCopyOrgName(dcSendFileEntity.getCopyOrgName());
			dcFiledistributeCenterEntity.setFileDate(dcSendFileEntity.getSendDate());
			dcFiledistributeCenterEntity.setNeedReplyFlag(dcSendFileEntity.getNeedReplyFlag());
			dcFiledistributeCenterEntity.setNeedReplyDate(dcSendFileEntity.getNeedReplyDate());
			dcFiledistributeCenterEntity.setSecretFlag(dcSendFileEntity.getSecretFlag());
			dcFiledistributeCenterEntity.setOtherAttachment(dcSendFileEntity.getOtherAttachment());
			dcFiledistributeCenterEntity.setSourceTable("dc_send_file");
			dcFiledistributeCenterEntity.setSourceId(dcSendFileEntity.getId());
			iDcFiledistributeCenterService.save(dcFiledistributeCenterEntity);
			if (dcFiledistributeCenterEntity.getSubmitType().equals("A")){
				iAttachmentService.attachmentFile(billId,"BT230411000000004",dcFiledistributeCenterEntity.getId(),"BT230411000000005");
			}else if (dcFiledistributeCenterEntity.getSubmitType().equals("B")){
				iAttachmentService.attachmentFile(billId,"BT230411000000004",dcFiledistributeCenterEntity.getId(),"BT230420000000001");
			}
			else if (dcFiledistributeCenterEntity.getSubmitType().equals("C")){
				iAttachmentService.attachmentFile(billId,"BT230411000000004",dcFiledistributeCenterEntity.getId(),"BT230411000000006");
			}
		}else {
			return CommonResponse.error("未查询到对象，无法同步到分发中心");
		}
		return CommonResponse.success();
	}



	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterAbstainingProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	}

}
