package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dc.bean.*;
import com.ejianc.business.dc.enumUtils.RecycleEnum;
import com.ejianc.business.dc.enumUtils.YesOrNoEnum;
import com.ejianc.business.dc.service.IDcDrawdistributeDrawinfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeInfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeRecordService;
import com.ejianc.business.dc.service.IDcDrawrecycleInfoService;
import com.ejianc.business.dc.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 卷册签发记录/我的图纸
 *
 * @author generator
 */
@Controller
@RequestMapping("dcDrawdistributeRecord")
public class DcDrawdistributeRecordController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IDcDrawdistributeRecordService service;
    @Autowired
    private IDcDrawdistributeDrawinfoService dcDrawdistributeDrawinfoService;
    @Autowired
    private IDcDrawdistributeInfoService dcDrawdistributeInfoService;
    @Autowired
    private IDcDrawrecycleInfoService dcDrawrecycleInfoService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DcDrawdistributeRecordVO> saveOrUpdate(@RequestBody DcDrawdistributeRecordVO saveOrUpdateVO) {
        DcDrawdistributeRecordEntity entity = BeanMapper.map(saveOrUpdateVO, DcDrawdistributeRecordEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            entity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
        }
        service.saveOrUpdate(entity, false);
        DcDrawdistributeRecordVO vo = BeanMapper.map(entity, DcDrawdistributeRecordVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DcDrawdistributeRecordVO> queryDetail(Long id) {
        DcDrawdistributeRecordEntity entity = service.selectById(id);
        DcDrawdistributeRecordVO vo = BeanMapper.map(entity, DcDrawdistributeRecordVO.class);
        List<DcDrawdistributeDrawinfoEntity> entityList = dcDrawdistributeDrawinfoService.list(new QueryWrapper<DcDrawdistributeDrawinfoEntity>().lambda()
                .eq(DcDrawdistributeDrawinfoEntity::getDrwgrpId, entity.getDrwgrpId())
                .eq(DcDrawdistributeDrawinfoEntity::getDr, 0));
        vo.setDcDrawdistributeDrawinfoList(BeanMapper.mapList(entityList, DcDrawdistributeDrawinfoVO.class));
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @RequestMapping(value = "/back", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> back(@RequestBody List<DcDrawdistributeRecordVO> vos) {
        vos.forEach(vo -> {
            service.update(new UpdateWrapper<DcDrawdistributeRecordEntity>().lambda()
                    .eq(DcDrawdistributeRecordEntity::getId, vo.getId())
                    .set(DcDrawdistributeRecordEntity::getRecycleSts, RecycleEnum.Y.getCode()));
            DcDrawrecycleInfoEntity entity = BeanMapper.map(vo, DcDrawrecycleInfoEntity.class);
            entity.setId(null);
            entity.setBillState(0);
            List<DcDrawrecycleDrwgrpinfoEntity> list = new ArrayList<>();
            DcDrawrecycleDrwgrpinfoEntity dcDrawrecycleDrwgrpinfoVO = BeanMapper.map(vo, DcDrawrecycleDrwgrpinfoEntity.class);
            dcDrawrecycleDrwgrpinfoVO.setId(null);
            dcDrawrecycleDrwgrpinfoVO.setDrawdistributeDrwgrpinfoId(vo.getId());
            list.add(dcDrawrecycleDrwgrpinfoVO);
            entity.setDcDrawrecycleDrwgrpinfoList(list);
            List<DcDrawdistributeDrawinfoEntity> dcDrawdistributeDrawinfoEntityList = dcDrawdistributeDrawinfoService.list(new QueryWrapper<DcDrawdistributeDrawinfoEntity>().lambda()
                    .select(DcDrawdistributeDrawinfoEntity.class, dcDrawdistributeDrawinfoEntity -> !dcDrawdistributeDrawinfoEntity.getColumn().equals("id"))
                    .eq(DcDrawdistributeDrawinfoEntity::getDrwgrpId, vo.getDrwgrpId())
                    .eq(DcDrawdistributeDrawinfoEntity::getDr, 0));
            entity.setDcDrawrecycleDrawinfoList(BeanMapper.mapList(dcDrawdistributeDrawinfoEntityList, DcDrawrecycleDrawinfoEntity.class));
            entity.setRecycleSts("N");
            entity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
            dcDrawrecycleInfoService.saveOrUpdate(entity);
        });
        return CommonResponse.success("图纸归还成功！");
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DcDrawdistributeRecordVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (DcDrawdistributeRecordVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DcDrawdistributeRecordVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DcDrawdistributeRecordVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("drwgrpCode");
        fuzzyFields.add("drwgrpName");
        fuzzyFields.add("receiveDeptName");
        fuzzyFields.add("receiveUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if (OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if (!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                return CommonResponse.error("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        param.getParams().put("projectName", new Parameter(QueryParam.ASC, InvocationInfoProxy.getTenantid()));
        param.getParams().put("drwgrpCode", new Parameter(QueryParam.ASC, InvocationInfoProxy.getTenantid()));
        param.getParams().put("drwgrpVsn", new Parameter(QueryParam.ASC, InvocationInfoProxy.getTenantid()));
        IPage<DcDrawdistributeRecordEntity> page = service.queryPage(param, false);
        IPage<DcDrawdistributeRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcDrawdistributeRecordVO.class));
        pageData.getRecords().forEach(e -> {
            e.setPaperFlagCn(StringUtils.isBlank(e.getPaperFlag()) ? "" : YesOrNoEnum.getEnumByCode(e.getPaperFlag()).getName());
            e.setRecycleStsCn(StringUtils.isBlank(e.getRecycleSts()) ? "" : RecycleEnum.getEnumByCode(e.getRecycleSts()).getName());
        });
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DcDrawdistributeRecordEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DcDrawdistributeRecord-export.xlsx", beans, response);
    }

    /**
     * @param param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refDcDrawdistributeRecordData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DcDrawdistributeRecordVO>> refDcDrawdistributeRecordData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                         String condition,
                                                                                         String searchObject,
                                                                                         String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DcDrawdistributeRecordEntity> page = service.queryPage(param, false);
        IPage<DcDrawdistributeRecordVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DcDrawdistributeRecordVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
