package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.service.IExcelItemService;
import com.ejianc.business.dc.service.impl.DcDrwgrpInfoServiceImpl;
import com.ejianc.business.dc.vo.DcDrwgrpInfoImportVO;
import com.ejianc.business.pro.ref.api.IRefApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.DeptVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 劳务分包档案
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("/excelImportService")
public class ExcelDemoController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "LSI_CODE";
    @Autowired
    private IExcelItemService service;

    @Autowired
    private DcDrwgrpInfoServiceImpl dcDrwgrpInfoService;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IRefApi iRefApi;

//    @Autowired
//    private IShareSubjectOrgApi subjectOrgApi;

    /**
     * 卷册信息导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadDcDrwgrpInfo")
    @ResponseBody
    public void downloadDcDrwgrpInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "drwgrp-import.xlsx", "卷册信息导入模板");
    }

    /**
     * 图纸信息导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadDcDrawInfo")
    @ResponseBody
    public void downloadDcDrawInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "draw-import.xlsx", "图纸信息导入模板");
    }


    /**
     * TODO 校验
     * @Author mrsir_wxp
     * @Date 2020/6/29 专业分包详情导入excel校验
     * @Description excelProsubImport
     * @Param [request, response]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "/excelDcDrwgrpInfoImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelDcDrwgrpInfoImport(HttpServletRequest request) {

        CommonResponse<JSONObject> response= service.excelDcDrwgrpInfoImport(request);
        return  response;

    }

    /**
     * TODO 校验
     * @Author mrsir_wxp
     * @Date 2020/6/29 专业分包详情导入excel校验
     * @Description excelProsubImport
     * @Param [request, response]
     * @Return com.ejianc.framework.core.response.CommonResponse<com.alibaba.fastjson.JSONObject>
     */
    @RequestMapping(value = "/excelDcDrawInfoImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelDcDrawInfoImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response= service.excelDcDrawInfoImport(request);
        return  response;
    }


    /**
     * TODO  保存
     * @param importVos
     * @return
     */
    @RequestMapping(value = "/saveImportExcelDcDrwgrpInfoItem", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveImportExcelDcDrwgrpInfoItem(@RequestBody List<DcDrwgrpInfoImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        List<DcDrwgrpInfoEntity> list = new ArrayList<>();

        importVos.forEach(importVO -> {
            DcDrwgrpInfoEntity entity = BeanMapper.map(importVO, DcDrwgrpInfoEntity.class);
            entity.setOrgId(sessionManager.getUserContext().getOrgId());
            entity.setOrgName(sessionManager.getUserContext().getOrgName());
            list.add(entity);
        });
        dcDrwgrpInfoService.saveBatch(list,list.size());
        return CommonResponse.success("保存成功！");
    }



//
//
//    /**
//     * TODO  保存
//     * @param importVos
//     * @return
//     */
//    @RequestMapping(value = "/saveImportExcelDcDrawInfoItem", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<String> saveImportExcelDcDrawInfoItem(@RequestBody List<LabsubItemImportVO> importVos) {
//        if (ListUtil.isEmpty(importVos)) {
//            return CommonResponse.error("导入的数据为空！");
//        }
//        List<LabsubItemEntity> list = new ArrayList<>();
//
//        importVos.forEach(importVO -> {
//            LabsubItemEntity entity = BeanMapper.map(importVO, LabsubItemEntity.class);
//            entity.setOrgId(sessionManager.getUserContext().getOrgId());
//            entity.setOrgName(sessionManager.getUserContext().getOrgName());
//            entity.setEnabled(0);
//            list.add(entity);
//        });
//        service.saveBatch(list,list.size());
//        return CommonResponse.success("保存成功！");
//    }
}
