package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.dc.bean.DcDrawapplyInfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeRecordEntity;
import com.ejianc.business.dc.enumUtils.RecycleEnum;
import com.ejianc.business.dc.service.IDcDrawapplyInfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeRecordService;
import com.ejianc.business.dc.vo.DcDrawapplyInfoVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

@Service("dcDrawapplyInfo")
public class DcDrawapplyInfoBpmServiceImpl implements ICommonBusinessService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    ActRuTaskService actRuTaskService;
    @Autowired
    private IDcDrawapplyInfoService dcDrawapplyInfoService;
    @Autowired
    private IDcDrawdistributeRecordService dcDrawdistributeRecordService;

    private static final String BILL_CODE = "DC_DRAWAPPLY_DIST_CODE";

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        DcDrawapplyInfoEntity entity = dcDrawapplyInfoService.getById(billId);
        if (entity != null) {
            if ("pass_a".equals(nodeType)) {
                dcDrawapplyInfoService.update(new UpdateWrapper<DcDrawapplyInfoEntity>().lambda()
                        .eq(DcDrawapplyInfoEntity::getId, billId)
                        .set(DcDrawapplyInfoEntity::getIssueDate, new Date())
                        .set(DcDrawapplyInfoEntity::getIssueUserCode, sessionManager.getUserContext().getUserCode())
                        .set(DcDrawapplyInfoEntity::getIssueUserName, sessionManager.getUserContext().getUserName()));
            }
        }
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        DcDrawapplyInfoEntity entity = dcDrawapplyInfoService.getById(billId);
        if (entity != null) {
            if ("pass_b".equals(nodeType)) {
                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(entity, DcDrawapplyInfoVO.class));
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    dcDrawapplyInfoService.update(new UpdateWrapper<DcDrawapplyInfoEntity>().lambda()
                            .eq(DcDrawapplyInfoEntity::getId, billId)
                            .set(DcDrawapplyInfoEntity::getDistCode, billCode.getData())
                            .set(DcDrawapplyInfoEntity::getDistDate, new Date())
                            .set(DcDrawapplyInfoEntity::getDistUserCode, sessionManager.getUserContext().getUserCode())
                            .set(DcDrawapplyInfoEntity::getDistUserName, sessionManager.getUserContext().getUserName()));
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }
                DcDrawdistributeRecordEntity dcDrawdistributeRecordEntity = dcDrawdistributeRecordService.getOne(new QueryWrapper<DcDrawdistributeRecordEntity>().lambda()
                        .eq(DcDrawdistributeRecordEntity::getDrwgrpId, entity.getDrwgrpId())
                        .eq(DcDrawdistributeRecordEntity::getReceiveDeptName, entity.getCreateDeptName())
                        .eq(DcDrawdistributeRecordEntity::getReceiveUserCode, entity.getCreateUserCode())
                        .eq(DcDrawdistributeRecordEntity::getPaperFlag, entity.getPaperFlag())
                        .eq(DcDrawdistributeRecordEntity::getRecycleSts, RecycleEnum.N.getCode())
                        .eq(DcDrawdistributeRecordEntity::getDr, 0));
                if (dcDrawdistributeRecordEntity == null) {
                    dcDrawdistributeRecordEntity = BeanMapper.map(entity, DcDrawdistributeRecordEntity.class);
                    dcDrawdistributeRecordEntity.setId(null);
                    dcDrawdistributeRecordEntity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
                    dcDrawdistributeRecordEntity.setReceiveDeptName(entity.getCreateDeptName());
                    dcDrawdistributeRecordEntity.setReceiveUserCode(entity.getCreateUserCode());
                    dcDrawdistributeRecordEntity.setReceiveUserName(entity.getCreateUserName());
                    dcDrawdistributeRecordEntity.setRecycleSts(RecycleEnum.N.getCode());
                    dcDrawdistributeRecordEntity.setIssueDate(entity.getIssueDate());
                    dcDrawdistributeRecordEntity.setIssueUserCode(entity.getIssueUserCode());
                    dcDrawdistributeRecordEntity.setIssueUserName(entity.getIssueUserName());
                    dcDrawdistributeRecordEntity.setSourceUnitid(entity.getSourceUnitid());
                    dcDrawdistributeRecordEntity.setSourceUnitname(entity.getSourceUnitname());
                    dcDrawdistributeRecordEntity.setSys(entity.getSys());
                    dcDrawdistributeRecordEntity.setDrawArriveDate(entity.getDrawArriveDate());
                    dcDrawdistributeRecordService.saveOrUpdate(dcDrawdistributeRecordEntity);
                } else {
                    dcDrawdistributeRecordService.update(new UpdateWrapper<DcDrawdistributeRecordEntity>().lambda()
                            .eq(DcDrawdistributeRecordEntity::getId, dcDrawdistributeRecordEntity.getId())
                            .set(DcDrawdistributeRecordEntity::getNum, dcDrawdistributeRecordEntity.getNum() + entity.getNum()));
                }
            }
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

}
