package com.ejianc.business.dc.service.impl;

import com.ejianc.business.basem.service.IAttachmentService;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.basem.utils.ValidateUtil;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;
import com.ejianc.business.dc.service.IDcFiledistributeMenuService;
import com.ejianc.business.dc.service.IDcSendFileService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.support.idworker.util.IdWorker;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.Map;

@Service("dcSendFile") 
public class DcSendFileBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private SessionManager sessionManager;

	@Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IDcSendFileService iDcSendFileService;

	@Autowired
	private IDcFiledistributeCenterService iDcFiledistributeCenterService;
	@Autowired
	ActRuTaskService actRuTaskService;
	@Autowired
	IAttachmentService iAttachmentService;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeSubmitProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterSubmitProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeHasBpmBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterHasBpmBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeInApprovalBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	};

	@Override
	public  CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String,Object> other){
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterInApprovalBack，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode+"    taskId:"+taskId+"    isEnd:"+isEnd+"    sign:"+sign+"    other:"+other);
		return CommonResponse.success();
	};
	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	}



	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeAbstainingProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DcSendFileEntity dcSendFileEntity = iDcSendFileService.selectById(billId);
		logger.info(">>>>>DEBUG-STEP-1<<<<<，判断 ValidateUtil.isNotEmpty(dcSendFileEntity) :"+ValidateUtil.isNotEmpty(dcSendFileEntity));
		if (ValidateUtil.isNotEmpty(dcSendFileEntity) ) {
			logger.info(">>>>>DEBUG-STEP-2<<<<<，进入业务处理，ValidateUtil.isNotEmpty(dcSendFileEntity) :TRUE ");
			UserContext userContextCache =sessionManager.getUserContext();
			DcFiledistributeCenterEntity dcFiledistributeCenterEntity = new DcFiledistributeCenterEntity();
			dcFiledistributeCenterEntity.setId(IdWorker.getId());
			dcFiledistributeCenterEntity.setBidsection(dcSendFileEntity.getBidsection());
			dcFiledistributeCenterEntity.setContractId(dcSendFileEntity.getContractId());
			dcFiledistributeCenterEntity.setBillState(0);
			dcFiledistributeCenterEntity.setAttribute(dcSendFileEntity.getAttribute());
			dcFiledistributeCenterEntity.setFiletype(dcSendFileEntity.getFiletype());
			dcFiledistributeCenterEntity.setContractCode(dcSendFileEntity.getContractCode());
			dcFiledistributeCenterEntity.setContractName(dcSendFileEntity.getContractName());
			dcFiledistributeCenterEntity.setFileCode(dcSendFileEntity.getFileCode());
			dcFiledistributeCenterEntity.setCopyOrgCode(dcSendFileEntity.getCopyOrgCode());
			dcFiledistributeCenterEntity.setCostFlag(dcSendFileEntity.getCostFlag());
			dcFiledistributeCenterEntity.setSubmitType(dcSendFileEntity.getSubmitType());
			dcFiledistributeCenterEntity.setCreateTime(new Date());
			dcFiledistributeCenterEntity.setCreateDeptId(userContextCache.getDeptId());
			dcFiledistributeCenterEntity.setCreateUserCode(userContextCache.getUserCode());
			dcFiledistributeCenterEntity.setSyncEsFlag(dcSendFileEntity.getSyncEsFlag());
			dcFiledistributeCenterEntity.setFileInternalCode(dcSendFileEntity.getFileInternalCode());
			dcFiledistributeCenterEntity.setFileSts(dcSendFileEntity.getFileSts());
			dcFiledistributeCenterEntity.setFileName(dcSendFileEntity.getFileName());
			dcFiledistributeCenterEntity.setFileVsn(dcSendFileEntity.getFileVsn());
			dcFiledistributeCenterEntity.setMgrp(dcSendFileEntity.getMgrp());
			dcFiledistributeCenterEntity.setMaterialType(dcSendFileEntity.getMaterialType());
			dcFiledistributeCenterEntity.setProjectCode(dcSendFileEntity.getProjectCode());
			dcFiledistributeCenterEntity.setOrgCode(dcSendFileEntity.getOrgCode());
			dcFiledistributeCenterEntity.setOrgId(dcSendFileEntity.getOrgId());
			dcFiledistributeCenterEntity.setSpecialty(dcSendFileEntity.getSpecialty());
			dcFiledistributeCenterEntity.setSys(dcSendFileEntity.getSys());
			dcFiledistributeCenterEntity.setSubItem(dcSendFileEntity.getSubItem());
			dcFiledistributeCenterEntity.setUnitProjCode(dcSendFileEntity.getUnitProjCode());
			dcFiledistributeCenterEntity.setUnitProjName(dcSendFileEntity.getUnitProjName());
			dcFiledistributeCenterEntity.setProjectName(dcSendFileEntity.getProjectName());
			dcFiledistributeCenterEntity.setProjectId(dcSendFileEntity.getProjectId());
			dcFiledistributeCenterEntity.setOrgName(dcSendFileEntity.getOrgName());
			dcFiledistributeCenterEntity.setParentOrgCode(dcSendFileEntity.getParentOrgCode());
			dcFiledistributeCenterEntity.setParentOrgId(dcSendFileEntity.getParentOrgId());
			dcFiledistributeCenterEntity.setParentOrgName(dcSendFileEntity.getParentOrgName());
			dcFiledistributeCenterEntity.setSubmitOrgId(dcSendFileEntity.getSubmitOrgId());
			dcFiledistributeCenterEntity.setSubmitOrgCode(dcSendFileEntity.getSubmitOrgCode());
			dcFiledistributeCenterEntity.setSubmitOrgName(dcSendFileEntity.getSubmitOrgName());
			dcFiledistributeCenterEntity.setCopyOrgId(dcSendFileEntity.getCopyOrgId());
			dcFiledistributeCenterEntity.setCopyOrgCode(dcSendFileEntity.getCopyOrgCode());
			dcFiledistributeCenterEntity.setCopyOrgName(dcSendFileEntity.getCopyOrgName());
			dcFiledistributeCenterEntity.setFileDate(dcSendFileEntity.getSendDate());
			dcFiledistributeCenterEntity.setNeedReplyFlag(dcSendFileEntity.getNeedReplyFlag());
			dcFiledistributeCenterEntity.setNeedReplyDate(dcSendFileEntity.getNeedReplyDate());
			dcFiledistributeCenterEntity.setSecretFlag(dcSendFileEntity.getSecretFlag());
			dcFiledistributeCenterEntity.setSourceTable("dc_send_file");
			dcFiledistributeCenterEntity.setSourceId(dcSendFileEntity.getId());
			dcFiledistributeCenterEntity.setReceiveFileCode(dcSendFileEntity.getReceiveFileCode());
			dcFiledistributeCenterEntity.setCenterId(dcFiledistributeCenterEntity.getCenterId());
			iDcFiledistributeCenterService.save(dcFiledistributeCenterEntity);
			logger.info(">>>>>DEBUG-STEP-3<<<<<，进入业务处理，dcSendFileEntity.getSubmitType() :"+dcSendFileEntity.getSubmitType());
			//报审
			if (dcSendFileEntity.getSubmitType() == 1648882235727679489L){
				logger.info(">>>>>DEBUG-STEP-4<<<<<，进入业务处理，报审:billId："+billId+"，BT230411000000004，dcFiledistributeCenterEntity.getId():"+dcFiledistributeCenterEntity.getId()+"，BT230411000000005");
				iAttachmentService.attachmentFileWithFileType("other_attachment",billId,"BT230411000000004","other_attachment",dcFiledistributeCenterEntity.getId(),"BT230411000000005");
				iAttachmentService.attachmentFileWithFileType("file_attachment",billId,"BT230411000000004","file_attachment",dcFiledistributeCenterEntity.getId(),"BT230411000000005");
			}
			//报备
			else if (dcSendFileEntity.getSubmitType()== 1648882275221245954L){
				logger.info(">>>>>DEBUG-STEP-5<<<<<，进入业务处理，报备:billId："+billId+"，BT230411000000004，dcFiledistributeCenterEntity.getId():"+dcFiledistributeCenterEntity.getId()+"，BT230420000000001");
				iAttachmentService.attachmentFileWithFileType("other_attachment",billId,"BT230411000000004","other_attachment",dcFiledistributeCenterEntity.getId(),"BT230420000000001");
				iAttachmentService.attachmentFileWithFileType("file_attachment",billId,"BT230411000000004","file_attachment",dcFiledistributeCenterEntity.getId(),"BT230420000000001");
			}
			//内部发布
			else if (dcSendFileEntity.getSubmitType()==1648882309526458369L){
				logger.info(">>>>>DEBUG-STEP-6<<<<<，进入业务处理，内部发布:billId："+billId+"，BT230411000000004，dcFiledistributeCenterEntity.getId():"+dcFiledistributeCenterEntity.getId()+"，BT230411000000006");
				iAttachmentService.attachmentFileWithFileType("other_attachment",billId,"BT230411000000004","other_attachment",dcFiledistributeCenterEntity.getId(),"BT230411000000006");
				iAttachmentService.attachmentFileWithFileType("file_attachment",billId,"BT230411000000004","file_attachment",dcFiledistributeCenterEntity.getId(),"BT230411000000006");
			}
		}else {
			return CommonResponse.error("未查询到对象，无法同步到分发中心");
		}
		return CommonResponse.success();
	}



	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterAbstainingProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	}

}
