package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.dc.mapper.DcSendFileMapper;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.service.IDcSendFileService;

/**
 * 发文管理
 * 
 * @author generator
 * 
 */
@Service("dcSendFileService")
public class DcSendFileServiceImpl extends BaseServiceImpl<DcSendFileMapper, DcSendFileEntity> implements IDcSendFileService{
    /**
     * @description:将旧版本文件状态置为无效
     * @author: chengminggao
     * @date: 2023/6/1 10:32
     * @param: [entity]
     * @return: boolean
     **/
    @Override
    public boolean upgradeFileSts(DcSendFileEntity entity) {
        return this.update(new UpdateWrapper<DcSendFileEntity>().lambda()
                .eq(DcSendFileEntity::getFileCode,entity.getFileCode())
                .eq(DcSendFileEntity::getProjectId,entity.getProjectId())
                .set(DcSendFileEntity::getFileSts,"N")
        );
    }
}
