package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.basem.utils.ToolUtil;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.service.IExcelItemService;
import com.ejianc.business.dc.util.DetailIndexExcelReader;
import com.ejianc.business.dc.util.EJCDateUtil;
import com.ejianc.business.dc.vo.DcDrawInfoImportVO;
import com.ejianc.business.dc.vo.DcDrawInfoVO;
import com.ejianc.business.dc.vo.DcDrwgrpInfoImportVO;
import com.ejianc.business.dc.vo.DcSendFileVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import com.ejianc.business.pro.ref.api.IRefApi;


import javax.servlet.http.HttpServletRequest;
import java.util.*;

import static com.ejianc.business.dc.util.ToolUtil.isInteger;

/**
 * 劳务分包档案
 *
 * @author generator
 */
@Service("labsubItemService")
public class ExcelItemServiceImpl implements IExcelItemService {

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IRefApi iRefApi;

    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;

    @Autowired
    private IDcDrawInfoService dcDrawInfoService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Override
    public CommonResponse<JSONObject> excelDcDrwgrpInfoImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<DcDrwgrpInfoImportVO> successList = new ArrayList<>();
        List<DcDrwgrpInfoImportVO> errorList = new ArrayList<>();
        List<DcDrwgrpInfoImportVO> success500TmpList = new ArrayList<>();
        CommonResponse<Map<Object, Map>> projDatamapCommonResponse = iRefApi.queryListByAttributeTbKey("ejc_promarket_project_pool_set", "name");
        StringBuilder comStr = new StringBuilder();
        Map<Object, Map> projDataMap = new HashMap<>();
        if (projDatamapCommonResponse.isSuccess()) {
            projDataMap = projDatamapCommonResponse.getData();
            logger.trace("项目参照查询成功"+JSONObject.toJSONString(projDataMap));
        } else {
            throw new BusinessException("项目参照查询失败!");
        }
        Map<String, DcDrwgrpInfoImportVO> selfCheckDcDrwgrp = new HashMap<>();
        Map<String, Integer> selfCheck = new HashMap<>();


        CommonResponse<Map<Object, Map>> sourceUnitnameDataMapResponse = iRefApi.queryListByAttributeTbKey("dc_source_unitname", "name");
        Map<Object, Map> sourceUnitnameDataMap = new HashMap<>();
        if (sourceUnitnameDataMapResponse.isSuccess()) {
            sourceUnitnameDataMap = sourceUnitnameDataMapResponse.getData();
            logger.trace("图纸来源查询成功"+JSONObject.toJSONString(sourceUnitnameDataMap));
        } else {
            throw new BusinessException("图纸来源参照查询失败!");
        }


        CommonResponse<Map<Object, Map>> dcDrwgrpTypeResponse = iRefApi.queryMapDictByAttributeTbKey("dc_drwgrp_type", "name");

        Map<Object, Map> dcDrwgrpTypeDataMap = new HashMap<>();
        if (dcDrwgrpTypeResponse.isSuccess()) {
            dcDrwgrpTypeDataMap = dcDrwgrpTypeResponse.getData();
            logger.trace("图纸类别自定义档案查询成功"+JSONObject.toJSONString(dcDrwgrpTypeDataMap));
        } else {
            throw new BusinessException("图纸类别自定义档案查询失败!");
        }


        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }

        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);


            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }


            {

                if (result != null && result.size() > 0) {
                    if (result.size() > 10000) {
                        return CommonResponse.error("卷册信息超过10000条，请分批上传！");
                    }
                    // 开始校验
                    for (int i = 0; i < result.size(); i++) {
                        Boolean flag = true;
                        List<String> datas = result.get(i);
                        DcDrwgrpInfoImportVO dcDrwgrpInfoVO = new DcDrwgrpInfoImportVO();
                        StringBuilder errorMessage = new StringBuilder("");
                        dcDrwgrpInfoVO.setId(IdWorker.getId());
                        // *项目名称
                        // TODO 项目参照
                        String projectName = datas.get(0);
                        if (ToolUtil.isNotEmpty(projectName)){
                            Map<String, Object> projectNameMap = (Map<String, Object>) projDataMap.get(projectName);
                            if (ToolUtil.isNotEmpty(projectNameMap)){
                                dcDrwgrpInfoVO.setProjectName((String) projectNameMap.get("name"));
                                dcDrwgrpInfoVO.setProjectCode((String) projectNameMap.get("code"));
                                Object id = projectNameMap.get("id");
                                if (id instanceof String) {
                                    dcDrwgrpInfoVO.setProjectId(Long.parseLong((String) id));
                                }else {
                                    dcDrwgrpInfoVO.setProjectId((Long) id);
                                }
                            } else {
                                errorMessage.append("[项目名称]"+projectName+":错误参照无法获取;");
                                flag = false;
                            }
                        }


                        // *卷册编号
                        String drwgrpCode = datas.get(1);
                        if (ToolUtil.isEmpty(drwgrpCode)) {
                            errorMessage.append("[卷册编号]为空;");
                            flag = false;
                        }
                        dcDrwgrpInfoVO.setDrwgrpCode(datas.get(1));
                        // *卷册名称
                        String drwgrpName = datas.get(2);
                        if (ToolUtil.isEmpty(drwgrpName)) {
                            errorMessage.append("[卷册名称]为空;");
                            flag = false;
                        }
                        dcDrwgrpInfoVO.setDrwgrpName(drwgrpName);
                        // *卷册版本
                        String drwgrpVsn = datas.get(3);
                        if (ToolUtil.isEmpty(drwgrpVsn)) {
                            errorMessage.append("[卷册版本]为空;");
                            flag = false;
                        }
                        dcDrwgrpInfoVO.setDrwgrpVsn(datas.get(3));
                        // 图纸类别
                        // TODO 自定义档案 等数据字典 改完后
                        String drwgrpTypeName = datas.get(4);
                        if (ToolUtil.isNotEmpty(drwgrpTypeName)){
                            Map<String, Object> drwgrpTypeNameMap = (Map<String, Object>) dcDrwgrpTypeDataMap.get(drwgrpTypeName);
                            if (ToolUtil.isNotEmpty(drwgrpTypeNameMap)){
                                Object id = drwgrpTypeNameMap.get("id");
                                if (id instanceof String) {
                                    dcDrwgrpInfoVO.setDrwgrpType(Long.parseLong((String) id));
                                }else {
                                    dcDrwgrpInfoVO.setDrwgrpType((Long) id);
                                }
                            }else {
                                errorMessage.append("[图纸类别]"+drwgrpTypeName+":自定义档案错误;");
                                flag = false;
                            }
                        }


                        // 传递单号
                    dcDrwgrpInfoVO.setTransferCode(datas.get(5));

                        // 到图日期
                        String drawArriveDateStr = datas.get(6);
                        if (ToolUtil.isNotEmpty(drawArriveDateStr)) {
                            Date parse = EJCDateUtil.parse(drawArriveDateStr, EJCDateUtil.DATE);
                            dcDrwgrpInfoVO.setDrawArriveDate(parse);
                        }

                        // 设计单位
                        // TODO 设计单位参照
                        String sourceUnitname = datas.get(7);
                        if (ToolUtil.isNotEmpty(sourceUnitname)) {
                            Map<String, Object> sourceUnitnameMap = (Map<String, Object>) sourceUnitnameDataMap.get(sourceUnitname);
                            if (ToolUtil.isNotEmpty(sourceUnitnameMap)){
                                dcDrwgrpInfoVO.setSourceUnitname((String) sourceUnitnameMap.get("name"));
                                Object id = sourceUnitnameMap.get("id");
                                if (id instanceof String) {
                                    dcDrwgrpInfoVO.setSourceUnitid(Long.parseLong((String) sourceUnitnameMap.get("id")));
                                }else {
                                    dcDrwgrpInfoVO.setSourceUnitid((Long) sourceUnitnameMap.get("id"));
                                }

                            }else {
                                errorMessage.append("[设计单位]"+sourceUnitname+":别参照错误;");
                                flag = false;
                            }
                        }



                        // 卷册套数
                        String drwgrpNum = datas.get(8);
                        if (ToolUtil.isNotEmpty(drwgrpNum)) {
                            if (!isInteger(drwgrpNum)){
                                errorMessage.append("[卷册套数]"+drwgrpNum+":为非数字;");
                                flag = false;
                            }else {
                                dcDrwgrpInfoVO.setDrwgrpNum(Integer.parseInt(drwgrpNum));
                            }

                        }
                        // 库存量
                        String surplusNum = datas.get(9);
                        if (ToolUtil.isNotEmpty(surplusNum)) {
                            if (!isInteger(surplusNum)){
                                errorMessage.append("[库存量]"+surplusNum+":为非数字;");
                                flag = false;
                            }
                            dcDrwgrpInfoVO.setSurplusNum(Integer.parseInt(surplusNum));
                        }
//                    备注
                        dcDrwgrpInfoVO.setRemarks(datas.get(10));

                        dcDrwgrpInfoVO.setRowIndex((i+2));
                        Integer integer = selfCheck.get(dcDrwgrpInfoVO.getDrwgrpCode() + dcDrwgrpInfoVO.getDrwgrpVsn());
                        if (ToolUtil.isNotEmpty(integer)){
                            errorMessage.append("excel中已存在该数据与第"+integer+"行重复;");
                            flag = false;
                        }else {
                            selfCheck.put( dcDrwgrpInfoVO.getDrwgrpCode() + dcDrwgrpInfoVO.getDrwgrpVsn(), (i+2));
                        }

                        if (flag) {
                            success500TmpList.add(dcDrwgrpInfoVO);
                            if (success500TmpList.size() == 500) {
                                List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntities = BeanMapper.mapList(success500TmpList, DcDrwgrpInfoEntity.class);
                                List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesExistList = dcDrwgrpInfoService.checkExist(dcDrwgrpInfoEntities);
                                if (ToolUtil.isNotEmpty(dcDrwgrpInfoEntitiesExistList)){
                                    dcDrwgrpInfoEntitiesExistList.stream().forEach(el -> {
                                        DcDrwgrpInfoImportVO map = BeanMapper.map(el, DcDrwgrpInfoImportVO.class);
                                        selfCheckDcDrwgrp.put( el.getDrwgrpCode() + el.getDrwgrpVsn(), map);
                                    });
                                }
                                success500TmpList.stream().forEach(el ->{
                                    DcDrwgrpInfoImportVO dcDrwgrpInfoImportVO = selfCheckDcDrwgrp.get(el.getDrwgrpCode() + el.getDrwgrpVsn());
                                    if (ToolUtil.isNotEmpty(dcDrwgrpInfoImportVO)){
                                        errorMessage.append("数据库中已存在该数据;");
                                        el.setErrorMessage(errorMessage.toString());
                                        errorList.add(el);
                                    }else {
                                        successList.add(el);
                                    }
                                });
                                success500TmpList = new ArrayList<DcDrwgrpInfoImportVO>();
                            }
                        } else {
                            dcDrwgrpInfoVO.setErrorMessage(errorMessage.toString());
                            errorList.add(dcDrwgrpInfoVO);
                        }
                    }

                    if (ToolUtil.isNotEmpty(success500TmpList)) {
                        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntities = BeanMapper.mapList(success500TmpList, DcDrwgrpInfoEntity.class);
                        List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesExistList = dcDrwgrpInfoService.checkExist(dcDrwgrpInfoEntities);
                        if (ToolUtil.isNotEmpty(dcDrwgrpInfoEntitiesExistList)){
                            dcDrwgrpInfoEntitiesExistList.stream().forEach(el -> {
                                DcDrwgrpInfoImportVO map = BeanMapper.map(el, DcDrwgrpInfoImportVO.class);
                                selfCheckDcDrwgrp.put( el.getDrwgrpCode() + el.getDrwgrpVsn(), map);
                            });
                        }
                        success500TmpList.stream().forEach(el ->{
                            DcDrwgrpInfoImportVO dcDrwgrpInfoImportVO = selfCheckDcDrwgrp.get(el.getDrwgrpCode() + el.getDrwgrpVsn());
                            if (ToolUtil.isNotEmpty(dcDrwgrpInfoImportVO)){
                                el.setErrorMessage("数据库中已存在该数据;");
                                errorList.add(el);
                            }else {
                                successList.add(el);
                            }
                        });
                    }
                }
            }
        }

//        返回结果
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        CommonResponse<JSONObject> success = CommonResponse.success(json);
        success.setMsg(comStr.toString());
        return success;
    }

    @Override
    public CommonResponse<JSONObject> excelDcDrawInfoImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<DcDrawInfoImportVO> successList = new ArrayList<>();
        List<DcDrawInfoImportVO> errorList = new ArrayList<>();
        List<DcDrawInfoImportVO> success500TmpList = new ArrayList<>();
        CommonResponse<Map<Object, Map>> drawTypeResponse = iRefApi.queryMapDictByAttributeTbKey("draw_type", "name");
        Map<String, Integer> selfCheck = new HashMap<>();
        Map<String, DcDrwgrpInfoEntity> selfCheckDb = new HashMap<>();
        List<DcDrwgrpInfoEntity> selfCheckDbList = new ArrayList<>();
        Map<Object, Map> drawTypeDataMap = new HashMap<>();
        if (drawTypeResponse.isSuccess()) {
            drawTypeDataMap = drawTypeResponse.getData();
            logger.trace("图纸类型自定义档案查询成功"+JSONObject.toJSONString(drawTypeDataMap));
        } else {
            throw new BusinessException("图纸类型自定义档案查询失败!");
        }
        StringBuilder comStr = new StringBuilder();
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            }

            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                if (result.size() > 10000) {
                    return CommonResponse.error("卷册信息超过10000条，请分批上传！");
                }
                // 开始校验
                for (int i = 0; i < result.size(); i++) {
                    Boolean flag = true;
                    List<String> datas = result.get(i);
                    DcDrawInfoImportVO dcDrawInfoVO = new DcDrawInfoImportVO();
                    StringBuilder errorMessage = new StringBuilder("");
                    dcDrawInfoVO.setId(IdWorker.getId());

//                    // 序号
//                    String order = datas.get(0);
//                    if (ToolUtil.isEmpty(order)) {
//                        int orderInt = Integer.parseInt(order);
//                    }

                    // *图纸编号
                    String drawCode = datas.get(0);
                    if (ToolUtil.isEmpty(drawCode)) {
                        errorMessage.append("[图纸编号]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrawCode(drawCode);

                    // *图纸名称
                    String drawName = datas.get(1);
                    if (ToolUtil.isEmpty(drawName)) {
                        errorMessage.append("[图纸名称]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrawName(drawName);
                    // *图纸版本
                    String drawVsn = datas.get(2);
                    if (ToolUtil.isEmpty(drawVsn)) {
                        errorMessage.append("[图纸版本]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrawVsn(drawVsn);

                    // *卷册编号
                    String drwgrpCode = datas.get(3);
                    if (ToolUtil.isEmpty(drwgrpCode)) {
                        errorMessage.append("[卷册编号]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrwgrpCode(drwgrpCode);


                    // *卷册版本
                    String drwgrpVsn = datas.get(4);
                    if (ToolUtil.isEmpty(drwgrpVsn)) {
                        errorMessage.append("[卷册版本]为空;");
                        flag = false;
                    }
                    dcDrawInfoVO.setDrwgrpVsn(drwgrpVsn);

                    // 传递单号
                    dcDrawInfoVO.setTransferCode(datas.get(5));

                    // 到图日期
                    String drawArriveDateStr = datas.get(6);
                    if (ToolUtil.isNotEmpty(drawArriveDateStr)) {
                        Date parse = EJCDateUtil.parse(drawArriveDateStr, EJCDateUtil.DATE);
                        dcDrawInfoVO.setDrawArriveDate(parse);
                    }

                    // 图纸类型
                    // TODO 图纸类型 自定义档案
                    String drawTypeName = datas.get(7);
                    if (ToolUtil.isNotEmpty(drawTypeName)) {
                        Map<String, Object> drawTypeMap = (Map<String, Object>) drawTypeDataMap.get(drawTypeName);
                        if (ToolUtil.isNotEmpty(drawTypeMap)){
                            Object id = drawTypeMap.get("id");
                            if (id instanceof String){
                                dcDrawInfoVO.setDrawType(Long.parseLong((String) id));
                            }else {
                                dcDrawInfoVO.setDrawType((Long) id);
                            }
                        }else {
                            errorMessage.append("[图纸类型]"+drawTypeName+":自定义档案错误;");
                            flag = false;
                        }
                    }

                    dcDrawInfoVO.setRowIndex((i+2));
                    if (ToolUtil.isNotEmpty(dcDrawInfoVO.getDrwgrpCode())&&ToolUtil.isNotEmpty(dcDrawInfoVO.getDrwgrpVsn())){
                        DcDrwgrpInfoEntity dcDrwgrpInfoEntity = selfCheckDb.get(dcDrawInfoVO.getDrwgrpCode() + dcDrawInfoVO.getDrwgrpVsn());
                        if (ToolUtil.isEmpty(dcDrwgrpInfoEntity)){
                            DcDrwgrpInfoEntity dcDrwgrpInfoEntityTemp = new DcDrwgrpInfoEntity();
                            dcDrwgrpInfoEntityTemp.setDrwgrpCode(dcDrawInfoVO.getDrwgrpCode() );
                            dcDrwgrpInfoEntityTemp.setDrwgrpVsn(dcDrawInfoVO.getDrwgrpVsn());
                            selfCheckDb.put(dcDrawInfoVO.getDrwgrpCode() + dcDrawInfoVO.getDrwgrpVsn(),dcDrwgrpInfoEntityTemp);
                            selfCheckDbList.add(dcDrwgrpInfoEntityTemp);
                        }
                    }
                    Integer integer = selfCheck.get(dcDrawInfoVO.getDrawCode() + dcDrawInfoVO.getDrawVsn());

                    if (ToolUtil.isNotEmpty(integer)){
                        errorMessage.append("excel中已存在该数据与第"+integer+"行重复;");
                        flag = false;
                    }else {
                        selfCheck.put( dcDrawInfoVO.getDrwgrpCode() + dcDrawInfoVO.getDrwgrpVsn(), (i+2));
                    }

                    if (flag) {
                        success500TmpList.add(dcDrawInfoVO);
                        if (success500TmpList.size() == 500) {
                            Map<String, Long> dcDrwgrpMap = new HashMap<String, Long>();
                            Map<String, Integer> dcDrawExist = new HashMap<String, Integer>();
                            List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesDb = dcDrwgrpInfoService.checkExist(selfCheckDbList);
                            dcDrwgrpInfoEntitiesDb.stream().forEach(ce->{
                                dcDrwgrpMap.put(ce.getDrwgrpCode()+ce.getDrwgrpVsn(),ce.getId());
                            });
                            List<DcDrawInfoEntity> dcDrwgrpInfoEntities = new ArrayList<DcDrawInfoEntity>();
                            success500TmpList.stream().forEach(es->{
                                es.setDrwgrpId(dcDrwgrpMap.get(es.getDrwgrpCode()+es.getDrwgrpVsn()));
                                dcDrwgrpInfoEntities.add(BeanMapper.map(es, DcDrawInfoEntity.class));
                            });

                            List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.checkExist(dcDrwgrpInfoEntities);
                            dcDrawInfoEntityList.stream().forEach(ce->{
                                dcDrawExist.put(ce.getDrwgrpCode()+ce.getDrwgrpVsn(),1);
                            });
                            success500TmpList.stream().forEach(ce->{
                                if (ToolUtil.isNotEmpty(dcDrawExist.get(ce.getDrwgrpCode() + ce.getDrwgrpVsn()))){
                                    errorMessage.append("数据库中已存在该数据;");
                                    errorList.add(ce);
                                } else {
                                    successList.add(ce);
                                }
                            });
                        }
                    } else {
                        dcDrawInfoVO.setErrorMessage(errorMessage.toString());
                        errorList.add(dcDrawInfoVO);
                    }
                }

                if (ToolUtil.isNotEmpty(success500TmpList)) {
                    Map<String, Long> dcDrwgrpMap = new HashMap<String, Long>();
                    Map<String, Integer> dcDrawExist = new HashMap<String, Integer>();
                    List<DcDrwgrpInfoEntity> dcDrwgrpInfoEntitiesDb = dcDrwgrpInfoService.checkExist(selfCheckDbList);
                    dcDrwgrpInfoEntitiesDb.stream().forEach(ce->{
                        dcDrwgrpMap.put(ce.getDrwgrpCode()+ce.getDrwgrpVsn(),ce.getId());
                    });
                    List<DcDrawInfoEntity> dcDrwgrpInfoEntities = new ArrayList<DcDrawInfoEntity>();
                    success500TmpList.stream().forEach(es->{
                        es.setDrwgrpId(dcDrwgrpMap.get(es.getDrwgrpCode()+es.getDrwgrpVsn()));
                        dcDrwgrpInfoEntities.add(BeanMapper.map(es, DcDrawInfoEntity.class));
                    });

                    List<DcDrawInfoEntity> dcDrawInfoEntityList = dcDrawInfoService.checkExist(dcDrwgrpInfoEntities);
                    dcDrawInfoEntityList.stream().forEach(ce->{
                        dcDrawExist.put(ce.getDrwgrpCode()+ce.getDrwgrpVsn(),1);
                    });
                    success500TmpList.stream().forEach(ce->{
                        if (ToolUtil.isNotEmpty(dcDrawExist.get(ce.getDrwgrpCode() + ce.getDrwgrpVsn()))){
                            ce.setErrorMessage("数据库中已存在该数据;");
                            errorList.add(ce);
                        } else {
                            successList.add(ce);
                        }
                    });
                }
            }
        }

//        返回结果
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        CommonResponse<JSONObject> success = CommonResponse.success(json);
        success.setMsg(comStr.toString());
        return success;
    }

}
