/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.service.IExcelItemService;
import com.ejianc.business.dc.service.impl.DcDrawInfoServiceImpl;
import com.ejianc.business.dc.service.impl.DcDrwgrpInfoServiceImpl;
import com.ejianc.business.dc.vo.DcDrawInfoImportVO;
import com.ejianc.business.dc.vo.DcDrwgrpInfoImportVO;
import com.ejianc.business.pro.ref.api.IRefApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ImportTemplate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/excelImportService"})
public class ExcelDemoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "LSI_CODE";
    @Autowired
    private IExcelItemService service;
    @Autowired
    private DcDrwgrpInfoServiceImpl dcDrwgrpInfoService;
    @Autowired
    private DcDrawInfoServiceImpl dcDrawInfoService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRefApi iRefApi;

    @RequestMapping(value={"/downloadDcDrwgrpInfo"})
    @ResponseBody
    public void downloadDcDrwgrpInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"drwgrp-import.xlsx", (String)"\u5377\u518c\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/downloadDcDrawInfo"})
    @ResponseBody
    public void downloadDcDrawInfo(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"draw-import.xlsx", (String)"\u56fe\u7eb8\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelDcDrwgrpInfoImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelDcDrwgrpInfoImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response = this.service.excelDcDrwgrpInfoImport(request);
        return response;
    }

    @RequestMapping(value={"/excelDcDrawInfoImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelDcDrawInfoImport(HttpServletRequest request) {
        CommonResponse<JSONObject> response = this.service.excelDcDrawInfoImport(request);
        return response;
    }

    @RequestMapping(value={"/saveImportExcelDcDrwgrpInfoItem"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelDcDrwgrpInfoItem(@RequestBody List<DcDrwgrpInfoImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList list = new ArrayList();
        importVos.forEach(importVO -> {
            DcDrwgrpInfoEntity entity = (DcDrwgrpInfoEntity)((Object)((Object)BeanMapper.map((Object)importVO, DcDrwgrpInfoEntity.class)));
            entity.setDr(0);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            entity.setTenantId(this.sessionManager.getUserContext().getTenantid());
            entity.setCreateDeptId(this.sessionManager.getUserContext().getDeptId());
            entity.setCreateUserCode(this.sessionManager.getUserContext().getUserCode());
            entity.setDrwgrpSts("N");
            entity.setIssueSts("0");
            list.add(entity);
        });
        this.dcDrwgrpInfoService.saveBatch(list, list.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveImportExcelDcDrawInfoItem"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelDcDrawInfoItem(@RequestBody List<DcDrawInfoImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList list = new ArrayList();
        importVos.forEach(importVO -> {
            DcDrawInfoEntity entity = (DcDrawInfoEntity)((Object)((Object)BeanMapper.map((Object)importVO, DcDrawInfoEntity.class)));
            entity.setDr(0);
            entity.setCreateTime(new Date());
            entity.setUpdateTime(new Date());
            entity.setTenantId(this.sessionManager.getUserContext().getTenantid());
            entity.setCreateDeptId(this.sessionManager.getUserContext().getDeptId());
            entity.setCreateUserCode(this.sessionManager.getUserContext().getUserCode());
            entity.setSyncEsFlag(0);
            entity.setIssueSts("0");
            list.add(entity);
        });
        this.dcDrawInfoService.saveBatch(list, list.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

