/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.dc.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class EJCDateUtil {
    static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
    public static final String MONTH = "yyyy-MM";
    public static final String SHORT_MONTH = "yyyyMM";
    public static final String DATE = "yyyy-MM-dd";
    public static final String DATE_TIME = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME = "HHmmss";
    public static final String TIME_WITHOUT_SECOND = "HH:mm";
    public static final String DATE_TIME_WITHOUT_SECONDS = "yyyy-MM-dd HH:mm";

    public static List<Integer> getShortMonthIntBetween(String minDate, String maxDate) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        try {
            min.setTime(sdf.parse(minDate));
            min.set(min.get(1), min.get(2), 1);
            max.setTime(sdf.parse(maxDate));
            max.set(max.get(1), max.get(2), 3);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(Integer.parseInt(EJCDateUtil.format(curr.getTime(), SHORT_MONTH)));
            curr.add(2, 1);
        }
        return result;
    }

    public static List<String> getMonthBetween(String minDate, String maxDate) {
        ArrayList<String> result = new ArrayList<String>();
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        try {
            min.setTime(sdf.parse(minDate));
            min.set(min.get(1), min.get(2), 1);
            max.setTime(sdf.parse(maxDate));
            max.set(max.get(1), max.get(2), 3);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar curr = min;
        while (curr.before(max)) {
            result.add(sdf.format(curr.getTime()));
            curr.add(2, 1);
        }
        return result;
    }

    public static int getYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    public static int getLastYear() {
        Calendar cal = Calendar.getInstance();
        int i = cal.get(1) - 1;
        return i;
    }

    public static int getMonth() {
        Calendar cal = Calendar.getInstance();
        return cal.get(2) + 1;
    }

    public static int getMonthOfDay() {
        LocalTime localTime = LocalTime.now();
        return localTime.get(ChronoField.DAY_OF_MONTH);
    }

    public static String format(Date date, String pattern) {
        Instant instant = date.toInstant();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return localDateTime.format(DateTimeFormatter.ofPattern(pattern));
    }

    public static Date parse(String dateStr, String pattern) {
        LocalDateTime localDateTime = LocalDateTime.parse(dateStr, DateTimeFormatter.ofPattern(pattern));
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Date parseDate(String dateStr, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        dateFormat.setLenient(false);
        try {
            return dateFormat.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date addMinutes(Date date, Long plusMinutes) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime newDateTime = dateTime.plusMinutes(plusMinutes);
        return Date.from(newDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date addHour(Date date, Long hour) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        LocalDateTime localDateTime = dateTime.plusHours(hour);
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date getStartTime() {
        LocalDateTime now = LocalDateTime.now().withHour(0).withMinute(0).withSecond(0);
        return EJCDateUtil.localDateTime2Date(now);
    }

    public static Date getEndTime() {
        LocalDateTime now = LocalDateTime.now().withHour(23).withMinute(59).withSecond(59).withNano(999);
        return EJCDateUtil.localDateTime2Date(now);
    }

    public static Date minusMonths(long monthsToSubtract) {
        LocalDate localDate = LocalDate.now().minusMonths(monthsToSubtract);
        return EJCDateUtil.localDate2Date(localDate);
    }

    public static Date localDate2Date(LocalDate localDate) {
        ZonedDateTime zonedDateTime = localDate.atStartOfDay(ZoneId.systemDefault());
        return Date.from(zonedDateTime.toInstant());
    }

    public static Date localDateTime2Date(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String getFirstDayOfCurrentYear(String pattern) {
        LocalDateTime localDateTime = LocalDateTime.now().withMonth(1).withDayOfMonth(1);
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = "yyyyMMdd";
        }
        return EJCDateUtil.format(EJCDateUtil.localDateTime2Date(localDateTime), pattern);
    }

    public static String getLastMonthFirstDayOfPreviousYear(String pattern) {
        LocalDateTime localDateTime = LocalDateTime.now().minusYears(1L).withMonth(12).withDayOfMonth(1);
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = "yyyyMMdd";
        }
        return EJCDateUtil.format(EJCDateUtil.localDateTime2Date(localDateTime), pattern);
    }

    public static String getLastMonthLastDayOfPreviousYear(String pattern) {
        LocalDateTime localDateTime = LocalDateTime.now().minusYears(1L).with(TemporalAdjusters.lastDayOfYear());
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = "yyyyMMdd";
        }
        return EJCDateUtil.format(EJCDateUtil.localDateTime2Date(localDateTime), pattern);
    }

    public static String getCurrentDay(String pattern) {
        LocalDateTime localDateTime = LocalDateTime.now();
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            pattern = DATE;
        }
        return EJCDateUtil.format(EJCDateUtil.localDateTime2Date(localDateTime), pattern);
    }

    public static String getMonth(int num) {
        Calendar cal = Calendar.getInstance();
        cal.add(2, num);
        return EJCDateUtil.format(cal.getTime(), MONTH);
    }

    public static String getPrevMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        return String.valueOf(year) + month;
    }

    public static List<String> getDayBetween(String startTime, String endTime) {
        ArrayList<String> days = new ArrayList<String>();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE);
        try {
            Date start = dateFormat.parse(startTime);
            Date end = dateFormat.parse(endTime);
            Calendar tempStart = Calendar.getInstance();
            tempStart.setTime(start);
            Calendar tempEnd = Calendar.getInstance();
            tempEnd.setTime(end);
            tempEnd.add(5, 1);
            while (tempStart.before(tempEnd)) {
                days.add(dateFormat.format(tempStart.getTime()));
                tempStart.add(6, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static void main(String[] args) {
        Date parse = EJCDateUtil.parseDate("2023-06-052", DATE);
        System.out.println(parse);
    }
}

