package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.dc.bean.DcDrawdistributeDrwgrpinfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeInfoEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.bean.convert.CtDrawdistributeDrwgrpinfo2CtDrawrecycleDrwgrpinfo;
import com.ejianc.business.dc.bean.convert.CtDrawdistributeInfoDto2CtDrwgrpInfo;
import com.ejianc.business.dc.controller.DcDrawdistributeInfoController;
import com.ejianc.business.dc.controller.DcDrawrecycleInfoController;
import com.ejianc.business.dc.controller.DcDrwgrpInfoController;
import com.ejianc.business.dc.mapper.DcDrawdistributeDrwgrpinfoMapper;
import com.ejianc.business.dc.mapper.DcDrwgrpInfoMapper;
import com.ejianc.business.dc.service.IDcDrawdistributeDrwgrpinfoService;
import com.ejianc.business.dc.vo.DcDrawdistributeDrwgrpinfoVO;
import com.ejianc.business.dc.vo.DcDrawdistributeInfoVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

@Service("dcDrwgrpInfo") 
public class DcDrwgrpInfoBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	ActRuTaskService actRuTaskService;
//	@Autowired
//	private DcDrawdistributeInfoController dcDrawdistributeInfoController;
//	@Autowired
//	private SessionManager sessionManager;
//	@Autowired
//	private CtDrawdistributeInfoDto2CtDrwgrpInfo ctDrawdistributeInfoDto2CtDrwgrpInfo;
//	@Autowired
//	private IDcDrawdistributeDrwgrpinfoService dcDrawdistributeDrwgrpinfoService;
	@Autowired
	private DcDrwgrpInfoMapper dcDrwgrpInfoMapper;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("beforeSubmitProcessor，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
		logger.info("afterApprovalProcessor图纸库数据终审后回调，开始回写状态，nodeType:"+nodeType+"    billId:"+billId+"    state:"+state+"   billTypeCode:"+billTypeCode);
		DcDrwgrpInfoEntity dcDrwgrpInfoEntity = this.dcDrwgrpInfoMapper.selectById(billId);
		if(null != dcDrwgrpInfoEntity) {
//			//签发信息
//			List<DcDrawdistributeDrwgrpinfoEntity> ctDrawdistributeDrwgrpinfoList = dcDrawdistributeDrwgrpinfoService.list(new QueryWrapper<DcDrawdistributeDrwgrpinfoEntity>().lambda()
//					.eq(DcDrawdistributeDrwgrpinfoEntity::getDrwgrpCode, dcDrwgrpInfoEntity.getDrwgrpCode())
//					.eq(DcDrawdistributeDrwgrpinfoEntity::getDrwgrpVsn, dcDrwgrpInfoEntity.getDrwgrpVsn()));
//
//			//bean转换
//			//遍历签发信息    生成每一个图纸签发卷册信息表
//			if(ObjectUtils.allNotNull(ctDrawdistributeDrwgrpinfoList)){
//				DcDrawdistributeInfoEntity dcDrawdistributeInfoEntity = ctDrawdistributeInfoDto2CtDrwgrpInfo.ctDrwgrpInfo2CtDrawdistributeInfoDto(dcDrwgrpInfoEntity);
//				dcDrawdistributeInfoEntity.setIssueUserCode(sessionManager.getUserContext().getUserCode());
//				dcDrawdistributeInfoEntity.setIssueUserName(sessionManager.getUserContext().getUserName());
//				dcDrawdistributeInfoEntity.setIssueDate(new Date());
//				dcDrawdistributeInfoEntity.setCreateTime(new Date());
//				dcDrawdistributeInfoEntity.setCreateDeptId(sessionManager.getUserContext().getDeptId());
//				dcDrawdistributeInfoEntity.setCreateUserCode(sessionManager.getUserContext().getUserCode());
//				dcDrawdistributeInfoEntity.setId(IdWorker.getId());
//				dcDrawdistributeInfoEntity.setBillState(Long.valueOf("0"));
//
//				//将原签发信息删除
//				dcDrawdistributeDrwgrpinfoService.remove(new QueryWrapper<DcDrawdistributeDrwgrpinfoEntity>().lambda()
//						.eq(DcDrawdistributeDrwgrpinfoEntity::getDrwgrpCode, dcDrwgrpInfoEntity.getDrwgrpCode())
//						.eq(DcDrawdistributeDrwgrpinfoEntity::getDrwgrpVsn,dcDrwgrpInfoEntity.getDrwgrpVsn()));
//
//				DcDrawdistributeInfoVO vo = BeanMapper.map(dcDrawdistributeInfoEntity, DcDrawdistributeInfoVO.class);
//				List<DcDrawdistributeDrwgrpinfoVO> dcDrawdistributeDrwgrpinfoVOList = BeanMapper.mapList(ctDrawdistributeDrwgrpinfoList, DcDrawdistributeDrwgrpinfoVO.class);
//				dcDrawdistributeDrwgrpinfoVOList.stream().forEach(e->{
//					e.setPid(dcDrawdistributeInfoEntity.getId());
//				});
//				vo.setDcDrawdistributeDrwgrpinfoEntityList(dcDrawdistributeDrwgrpinfoVOList);
//				dcDrawdistributeInfoController.saveOrUpdate(vo);
//
//			}else {
//				throw new BusinessException("没有添加签发信息不允许申请签发");
//			}
//
			UpdateWrapper<DcDrwgrpInfoEntity> updateWrapper = new UpdateWrapper<>();
			updateWrapper.lambda().eq(DcDrwgrpInfoEntity::getId, dcDrwgrpInfoEntity.getId())
					.set(DcDrwgrpInfoEntity::getDrwgrpSts, "Y");
			int update = this.dcDrwgrpInfoMapper.update(null, updateWrapper);
			if (update != 1) {
				throw new BusinessException("更新数据失败!");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
