package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.utils.ValidateUtil;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.service.IDcSendFileService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.dc.mapper.DcFiledistributeCenterMapper;
import com.ejianc.business.dc.bean.DcFiledistributeCenterEntity;
import com.ejianc.business.dc.service.IDcFiledistributeCenterService;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 文件分发中心
 *
 * @author generator
 */
@Service("dcFiledistributeCenterService")
public class DcFiledistributeCenterServiceImpl extends BaseServiceImpl<DcFiledistributeCenterMapper, DcFiledistributeCenterEntity> implements IDcFiledistributeCenterService {
    @Autowired
    DcFiledistributeCenterMapper dcFiledistributeCenterMapper;
    @Autowired
    IDcSendFileService iDcSendFileService;

    @Override
    public List<Map> selectAttributeByPid(String pid) {
        Long orgId = InvocationInfoProxy.getOrgId();
        return dcFiledistributeCenterMapper.selectAttributeByPid(pid, String.valueOf(orgId));
    }

    @Override
    public List<Map> selectTemplateByCategoryId(String id) {
        Long orgId = InvocationInfoProxy.getOrgId();
        //查到的该项目模版数据
        List<Map> templateList = dcFiledistributeCenterMapper.selectTemplateByCategoryId(id, String.valueOf(orgId));
        if (ValidateUtil.isNotEmpty(templateList)) {
            return templateList;
        } else {
            //这里的orgId为主组织id
            return dcFiledistributeCenterMapper.selectTemplateByCategoryId(id, "1502571152583692289");
        }
    }

    @Override
    public List<Map> selectAttribute() {
        Long orgId = InvocationInfoProxy.getOrgId();
        //查到的该项目数据
        List<Map> templateList = dcFiledistributeCenterMapper.selectAttribute(String.valueOf(orgId));
        if (ValidateUtil.isNotEmpty(templateList)) {
            return templateList;
        } else {
            new BusinessException("未查到数据！！！");
        }
        return null;
    }

    /**
     * @description: 文件状态file_sts改为作废即可，同时将发文管理对应数据的文件状态file_sts改为作废
     * @author: chengminggao
     * @date: 2023/6/1 15:15
     * @param: [entity]
     * @return: boolean
     **/
    @Override
    public boolean cancel(DcFiledistributeCenterEntity entity) {
            this.update(new UpdateWrapper<DcFiledistributeCenterEntity>().lambda()
                    .eq(DcFiledistributeCenterEntity::getId,entity.getId())
                    .set(DcFiledistributeCenterEntity::getFileSts,"N"));
            if (ValidateUtil.isNotEmpty(entity.getSourceTable())&&ValidateUtil.isNotEmpty(entity.getSourceId())){
                if (entity.getSourceTable().equals("dc_send_file")){
                    iDcSendFileService.update(new UpdateWrapper<DcSendFileEntity>().lambda()
                            .eq(DcSendFileEntity::getId,entity.getId())
                            .set(DcSendFileEntity::getFileSts,"N"));
                }
            }else {
                new BusinessException("没有来源表");
            }
        return false;
    }
}
