package com.ejianc.business.dc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.dc.vo.DcSendFileVO;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.BillCodeRuleApiVO;
import com.ejianc.business.ztpc.billcode.bean.GenerateBillCodeSNVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.dc.mapper.DcSendFileMapper;
import com.ejianc.business.dc.bean.DcSendFileEntity;
import com.ejianc.business.dc.service.IDcSendFileService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 发文管理
 * 
 * @author generator
 * 
 */
@Service("dcSendFileService")
public class DcSendFileServiceImpl extends BaseServiceImpl<DcSendFileMapper, DcSendFileEntity> implements IDcSendFileService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DC_SEND_FILE_CODE";//此处需要根据实际修改
    @Autowired
    private IDcSendFileService service;

    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;//取号规则api

    /**
     * @description:将旧版本文件状态置为无效
     * @author: chengminggao
     * @date: 2023/6/1 10:32
     * @param: [entity]
     * @return: boolean
     **/
    @Override
    public boolean upgradeFileSts(DcSendFileEntity entity) {
        return this.update(new UpdateWrapper<DcSendFileEntity>().lambda()
                .eq(DcSendFileEntity::getFileCode,entity.getFileCode())
                .eq(DcSendFileEntity::getProjectId,entity.getProjectId())
                .set(DcSendFileEntity::getFileSts,"N")
        );
    }

    @Override
    public CommonResponse<DcSendFileVO> saveOrUpdate(DcSendFileVO saveOrUpdateVO) {
        DcSendFileEntity entity = BeanMapper.map(saveOrUpdateVO, DcSendFileEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setId(IdWorker.getId());
        }

        //先取号
        BillCodeRuleApiVO apiVO = new BillCodeRuleApiVO();
        apiVO.setProjectId(entity.getProjectId());//项目id
        apiVO.setProjectCode(entity.getProjectCode());//项目编码
        apiVO.setProjectName(entity.getProjectName());//项目名称
        apiVO.setCategoryId(entity.getFiletype());//文件类型
        apiVO.setRuleType("1");//规则类型，0内部编码，1外部编码
        apiVO.setSourcePid(entity.getId());
        apiVO.setSourceCode(entity.getBillCode());
        apiVO.setSourceType("BT230411000000004");
        apiVO.setSourceTypeName("发文管理");
        try {
            JSONArray referEntityValue = ReferObjectUtil.getReferEntityValue(entity.getSpecialty() + "", "data-dictionary");
            JSONObject referJson = (JSONObject) referEntityValue.get(0);
            apiVO.setRule05(referJson.getString("code"));//专业
        }catch (Exception e){
            throw new BusinessException("referCode:data-dictionary id：" + entity.getSpecialty() + "转换出错");
        }

        CommonResponse<GenerateBillCodeSNVO> snCommonResponse = billCodeRuleApi.generateBillCode(apiVO);
        if(!snCommonResponse.isSuccess()){
            return CommonResponse.error(snCommonResponse.getMsg());
        }else{
            entity.setFileCode(snCommonResponse.getData().getGenerateBillCode());
        }

        boolean b = service.saveOrUpdate(entity, false);
        if(b){
            //业务单据保持成功后，提交取号
            GenerateBillCodeSNVO retSnVO = snCommonResponse.getData();
            billCodeRuleApi.commitBillCode(retSnVO);
        }

        DcSendFileVO vo = BeanMapper.map(entity, DcSendFileVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> delete(List<DcSendFileVO> vos) {
        Map sourceIds = new HashMap<String, Object>() ;
        List idList = new ArrayList<String>();

        if(ListUtil.isNotEmpty(vos)){
            for (DcSendFileVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
                idList.add(vo.getId());
            }
        }
        sourceIds.put("ids",idList);
        CommonResponse commonResponse = billCodeRuleApi.releaseBillCode(sourceIds);
        if(commonResponse.isSuccess()){
            service.removeByIds(vos.stream().map(DcSendFileVO::getId).collect(Collectors.toList()),true);
            return CommonResponse.success("删除成功！");
        }else{
            return CommonResponse.error(commonResponse.getMsg());
        }

    }
}
