package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.service.IAttachmentService;
import com.ejianc.business.basem.utils.ValidateUtil;
import com.ejianc.business.dc.bean.DcChangemanageDrawinfoEntity;
import com.ejianc.business.dc.bean.DcChangemanageInfoEntity;
import com.ejianc.business.dc.bean.DcDrawInfoEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.service.IDcChangemanageDrawinfoService;
import com.ejianc.business.dc.service.IDcChangemanageInfoService;
import com.ejianc.business.dc.service.IDcDrawInfoService;
import com.ejianc.support.idworker.util.IdWorker;
import org.checkerframework.checker.units.qual.A;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import javax.validation.Valid;
import java.util.*;

@Service("dcChangemanageInfo")
public class DcChangemanageInfoBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IDcChangemanageInfoService iDcChangemanageInfoService;
    @Autowired
    private IDcChangemanageDrawinfoService iDcChangemanageDrawinfoService;
	@Autowired
	private IDcDrawInfoService iDcDrawInfoService;
    @Autowired
    IAttachmentService iAttachmentService;

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *变更管理提交后，根据受影响图纸信息涉及到的卷册id，将数据插入到dc_draw_info表，涉及到几个卷册，插入几条数据。图纸类型为设计变更，附件也需要复制过去。注意重复提交数据的情况，如果数据存在，不插入数据，更新即可。
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        DcChangemanageInfoEntity dcChangemanageInfoEntity = iDcChangemanageInfoService.selectById(billId);
        List<DcChangemanageDrawinfoEntity> dcChangemanageDrawinfoEntityList = iDcChangemanageDrawinfoService.getBaseMapper().selectList(
                new QueryWrapper<DcChangemanageDrawinfoEntity>().lambda()
                        .eq(DcChangemanageDrawinfoEntity::getPid, billId));
        if (ValidateUtil.isNotEmpty(dcChangemanageDrawinfoEntityList)) {
			Map drwgrpId = new HashMap<>();
            //存要新增的数据
            List<DcDrawInfoEntity> saveList = new ArrayList<>();
			dcChangemanageDrawinfoEntityList.stream().forEach(e ->{
                //先查有没有重复的数据
                Integer count = iDcDrawInfoService.getBaseMapper().selectCount(new QueryWrapper<DcDrawInfoEntity>().lambda()
                        .eq(DcDrawInfoEntity::getDrawCode, dcChangemanageInfoEntity.getFileCode())
                        .eq(DcDrawInfoEntity::getDrawVsn, dcChangemanageInfoEntity.getFileVsn())
                        .eq(DcDrawInfoEntity::getProjectId, dcChangemanageInfoEntity.getProjectId())
                        .eq(DcDrawInfoEntity::getDrwgrpId, e.getDrwgrpId()));
                if (count==0){
                    //如果为空 说明是新的卷册 是新的一条数据
                    if (ValidateUtil.isEmpty(drwgrpId.get(e.getDrwgrpId()))) {
                        drwgrpId.put(e.getDrwgrpId(), "1");
                        //对象赋值
                        DcDrawInfoEntity dcDrawInfoEntity = new DcDrawInfoEntity();
                        dcDrawInfoEntity.setId(IdWorker.getId());
                        dcDrawInfoEntity.setDrwgrpCode(e.getDrwgrpCode());
                        dcDrawInfoEntity.setDrwgrpVsn(e.getDrwgrpVsn());
                        dcDrawInfoEntity.setDrwgrpId(e.getDrwgrpId());
                        //设计变更类型
                        dcDrawInfoEntity.setDrawType(1656552553644560386L);
                        dcDrawInfoEntity.setIssueSts("0");
                        dcDrawInfoEntity.setDrawCode(dcChangemanageInfoEntity.getFileCode());
                        dcDrawInfoEntity.setDrawName(dcChangemanageInfoEntity.getFileName());
                        dcDrawInfoEntity.setDrawArriveDate(dcChangemanageInfoEntity.getArriveDate());
                        dcDrawInfoEntity.setDrawVsn(dcChangemanageInfoEntity.getFileVsn());
                        dcDrawInfoEntity.setCreateDeptId(dcChangemanageInfoEntity.getCreateDeptId());
                        dcDrawInfoEntity.setCreateTime(new Date());
                        dcDrawInfoEntity.setOrgCode(dcChangemanageInfoEntity.getOrgCode());
                        dcDrawInfoEntity.setParentOrgCode(dcChangemanageInfoEntity.getParentOrgCode());
                        dcDrawInfoEntity.setParentOrgId(dcChangemanageInfoEntity.getParentOrgId());
                        dcDrawInfoEntity.setParentOrgName(dcChangemanageInfoEntity.getParentOrgName());
                        dcDrawInfoEntity.setProjectCode(dcChangemanageInfoEntity.getProjectCode());
                        dcDrawInfoEntity.setProjectId(dcChangemanageInfoEntity.getProjectId());
                        dcDrawInfoEntity.setProjectName(dcChangemanageInfoEntity.getProjectName());
                        dcDrawInfoEntity.setDr(dcChangemanageInfoEntity.getDr());
                        dcDrawInfoEntity.setTenantId(dcChangemanageInfoEntity.getTenantId());
                        dcDrawInfoEntity.setVersion(dcChangemanageInfoEntity.getVersion());
                        saveList.add(dcDrawInfoEntity);
                        iAttachmentService.attachmentFileWithFileType("fileAttachment",billId,"BT230601000000001","otherAttachment",dcDrawInfoEntity.getId(),"BT230602000000005");
                    }
                }
                //证明是有数据 做更新操作
                else {
                    DcDrawInfoEntity dcDrawInfoEntity = new DcDrawInfoEntity();
                    dcDrawInfoEntity.setDrwgrpCode(e.getDrwgrpCode());
                    dcDrawInfoEntity.setDrwgrpVsn(e.getDrwgrpVsn());
                    dcDrawInfoEntity.setDrwgrpId(e.getDrwgrpId());
                    dcDrawInfoEntity.setDrawArriveDate(dcChangemanageInfoEntity.getArriveDate());
                    dcDrawInfoEntity.setDrawCode(dcChangemanageInfoEntity.getFileCode());
                    dcDrawInfoEntity.setDrawName(dcChangemanageInfoEntity.getFileName());
                    dcDrawInfoEntity.setDrawVsn(dcChangemanageInfoEntity.getFileVsn());
                    dcDrawInfoEntity.setCreateDeptId(dcChangemanageInfoEntity.getCreateDeptId());
                    dcDrawInfoEntity.setCreateTime(new Date());
                    iDcDrawInfoService.getBaseMapper().update(dcDrawInfoEntity,new UpdateWrapper<DcDrawInfoEntity>().lambda()
                            .eq(DcDrawInfoEntity::getDrawCode, dcChangemanageInfoEntity.getFileCode())
                            .eq(DcDrawInfoEntity::getProjectId, dcChangemanageInfoEntity.getProjectId())
                            .eq(DcDrawInfoEntity::getDrwgrpCode, e.getDrawCode()));
                    iAttachmentService.attachmentFileWithFileType("fileAttachment",billId,"BT230601000000001","otherAttachment",dcDrawInfoEntity.getId(),"BT230602000000005");
                }
			});
            iDcDrawInfoService.saveBatch(saveList);
        }

        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
