package com.ejianc.business.dc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.basem.service.impl.ActRuTaskService;
import com.ejianc.business.dc.bean.DcDrawdistributeDrwgrpinfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeInfoEntity;
import com.ejianc.business.dc.bean.DcDrawdistributeRecordEntity;
import com.ejianc.business.dc.bean.DcDrwgrpInfoEntity;
import com.ejianc.business.dc.controller.DcDrawdistributeInfoController;
import com.ejianc.business.dc.controller.DcDrawdistributeRecordController;
import com.ejianc.business.dc.enumUtils.IssueStsEnum;
import com.ejianc.business.dc.enumUtils.YesOrNoEnum;
import com.ejianc.business.dc.service.IDcDrawdistributeDrwgrpinfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeInfoService;
import com.ejianc.business.dc.service.IDcDrawdistributeRecordService;
import com.ejianc.business.dc.service.IDcDrwgrpInfoService;
import com.ejianc.business.dc.vo.DcDrawdistributeInfoVO;
import com.ejianc.business.dc.vo.DcDrawdistributeRecordVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

@Service("dcDrawdistributeInfo")
public class DcDrawdistributeInfoBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    ActRuTaskService actRuTaskService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDcDrawdistributeRecordService dcDrawdistributeRecordService;
    @Autowired
    private DcDrawdistributeRecordController dcDrawdistributeRecordController;
    @Autowired
    private IDcDrwgrpInfoService dcDrwgrpInfoService;
    @Autowired
    private IDcDrawdistributeInfoService dcDrawdistributeInfoService;
    @Autowired
    private IDcDrawdistributeDrwgrpinfoService dcDrawdistributeDrwgrpinfoService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        DcDrawdistributeInfoEntity entity = dcDrawdistributeInfoService.getById(billId);
        if (null != entity) {
            if ("pass_a".equals(nodeType)) {
                //更新图纸签发主表签发信息
                dcDrawdistributeInfoService.update(new UpdateWrapper<DcDrawdistributeInfoEntity>().lambda()
                        .eq(DcDrawdistributeInfoEntity::getId, billId)
                        .set(DcDrawdistributeInfoEntity::getIssueDate, new Date())
                        .set(DcDrawdistributeInfoEntity::getIssueUserCode, sessionManager.getUserContext().getUserCode())
                        .set(DcDrawdistributeInfoEntity::getIssueUserName, sessionManager.getUserContext().getUserName()));
                //更新卷册签发信息
                dcDrwgrpInfoService.update(new UpdateWrapper<DcDrwgrpInfoEntity>().lambda()
                        .eq(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                        .set(DcDrwgrpInfoEntity::getIssueDate, new Date())
                        .set(DcDrwgrpInfoEntity::getIssueUserCode, sessionManager.getUserContext().getUserCode())
                        .set(DcDrwgrpInfoEntity::getIssueUserName, sessionManager.getUserContext().getUserName()));
            }
        }
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        String nodeType = actRuTaskService.getNodeType(String.valueOf(billId));
        DcDrawdistributeInfoEntity entity = dcDrawdistributeInfoService.getById(billId);
        if (null != entity) {
            if ("pass_b".equals(nodeType)) {
                List<DcDrawdistributeDrwgrpinfoEntity> dcDrawdistributeDrwgrpinfoEntityList = dcDrawdistributeDrwgrpinfoService.list(new QueryWrapper<DcDrawdistributeDrwgrpinfoEntity>().lambda()
                        .eq(DcDrawdistributeDrwgrpinfoEntity::getPid, billId)
                        .eq(DcDrawdistributeDrwgrpinfoEntity::getDr, 0));
                BillCodeParam billCodeParam = BillCodeParam.build(DcDrawdistributeInfoController.BILL_CODE, InvocationInfoProxy.getTenantid(), BeanMapper.map(entity, DcDrawdistributeInfoVO.class));
                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
                if (billCode.isSuccess()) {
                    //更新图纸签发主表分发信息
                    dcDrawdistributeInfoService.update(new UpdateWrapper<DcDrawdistributeInfoEntity>().lambda()
                            .eq(DcDrawdistributeInfoEntity::getId, billId)
                            .set(DcDrawdistributeInfoEntity::getDistDate, new Date())
                            .set(DcDrawdistributeInfoEntity::getDistCode, billCode.getData())
                            .set(DcDrawdistributeInfoEntity::getDistUserCode, sessionManager.getUserContext().getUserCode())
                            .set(DcDrawdistributeInfoEntity::getDistUserName, sessionManager.getUserContext().getUserName()));
                    dcDrwgrpInfoService.update(new UpdateWrapper<DcDrwgrpInfoEntity>().lambda()
                            .eq(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                            .set(DcDrwgrpInfoEntity::getIssueSts, IssueStsEnum.NOT_ISSUE.getCode()));
                    DcDrwgrpInfoEntity dcDrwgrpInfoEntity = dcDrwgrpInfoService.getById(entity.getDrwgrpId());
                    //判断是否有签发信息,如果存在签发信息，判断总的签发份数是否大于库存数；如果不存在签发信息不允许签发
                    if (dcDrawdistributeDrwgrpinfoEntityList.size() > 0) {
                        if (null != dcDrwgrpInfoEntity && dcDrwgrpInfoEntity.getSurplusNum() > 0) {
                            int i = dcDrawdistributeDrwgrpinfoEntityList.stream()
                                    .filter(e -> YesOrNoEnum.Y.getCode().equals(e.getPaperFlag()) && e.getNum() != null)
                                    .mapToInt(DcDrawdistributeDrwgrpinfoEntity::getNum).sum();
                            if (BigDecimal.valueOf(dcDrwgrpInfoEntity.getSurplusNum()).compareTo(BigDecimal.valueOf(i)) >= 0) {
                                dcDrwgrpInfoService.update(new UpdateWrapper<DcDrwgrpInfoEntity>().lambda()
                                        .eq(DcDrwgrpInfoEntity::getId, entity.getDrwgrpId())
                                        .set(DcDrwgrpInfoEntity::getSurplusNum, dcDrwgrpInfoEntity.getSurplusNum() - i));
                            } else {
                                return CommonResponse.error("您签发的卷册号为【" + entity.getDrwgrpCode() + "】的总份数【" + i + "】大于该卷册库存量【" + dcDrwgrpInfoEntity.getSurplusNum() + "】!");
                            }
                        }
                    } else {
                        return CommonResponse.error("没有添加签发信息不允许签发!");
                    }
                } else {
                    return CommonResponse.error("网络异常， 编码生成失败， 请稍后再试");
                }
                //签发流程结束后，数据添加到签发记录表（如果用户已持有该卷册，不增加数据。）
                dcDrawdistributeDrwgrpinfoEntityList.forEach(dcDrawdistributeDrwgrpinfoEntity -> {
                    DcDrawdistributeRecordEntity dcDrawdistributeRecordEntity = dcDrawdistributeRecordService.getOne(new QueryWrapper<DcDrawdistributeRecordEntity>().lambda()
                            .eq(DcDrawdistributeRecordEntity::getDrwgrpId, dcDrawdistributeDrwgrpinfoEntity.getDrwgrpId())
                            .eq(DcDrawdistributeRecordEntity::getReceiveUserCode, dcDrawdistributeDrwgrpinfoEntity.getReceiveUserCode())
                            .eq(DcDrawdistributeRecordEntity::getDr, 0));
                    if (dcDrawdistributeRecordEntity == null) {
                        DcDrawdistributeRecordEntity drawdistributeRecordEntity = BeanMapper.map(dcDrawdistributeDrwgrpinfoEntity, DcDrawdistributeRecordEntity.class);
                        drawdistributeRecordEntity.setId(null);
                        drawdistributeRecordEntity.setIssueDate(entity.getIssueDate());
                        drawdistributeRecordEntity.setIssueUserCode(entity.getIssueUserCode());
                        drawdistributeRecordEntity.setIssueUserName(entity.getIssueUserName());
                        drawdistributeRecordEntity.setSourceUnitid(entity.getSourceUnitid());
                        drawdistributeRecordEntity.setSourceUnitname(entity.getSourceUnitname());
                        drawdistributeRecordEntity.setSys(entity.getSys());
                        drawdistributeRecordEntity.setDrawArriveDate(entity.getDrawArriveDate());
                        drawdistributeRecordEntity.setTenantId(null);
                        drawdistributeRecordEntity.setCreateTime(null);
                        drawdistributeRecordEntity.setCreateUserCode(null);
                        drawdistributeRecordEntity.setUpdateTime(null);
                        drawdistributeRecordEntity.setUpdateUserCode(null);
                        dcDrawdistributeRecordController.saveOrUpdate(BeanMapper.map(drawdistributeRecordEntity, DcDrawdistributeRecordVO.class));
                    }
                });
            }
        }
        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        // 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
         if(!resp.isSuccess()){
         return CommonResponse.error("无法撤回！"+resp.getMsg());
         }*/
        return CommonResponse.success();
    }

}
